"use strict";
/*
 * To generate the initial file, we took the output of all submodules for
 * 'AAPL', 'OCDO.L', '0700.HK' and '^IXIC' and ran the results through
 * the awesome https://app.quicktype.io/.
 *
 * Manual cleanup afterwards:
 *
 *  1) Spaces: 4 to 2
 *  ~~2) Wrapped in a module~~ <--- undid this after tooling issues.
 *  3) Alphabeticalize QuoteSummaryResult
 *  4) RawNumberObj type to Date|number for coersion
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Grade = exports.Action = exports.OwnershipEnum = exports.Relation = void 0;
var Relation;
(function (Relation) {
    Relation["ChairmanOfTheBoard"] = "Chairman of the Board";
    Relation["ChiefExecutiveOfficer"] = "Chief Executive Officer";
    Relation["ChiefFinancialOfficer"] = "Chief Financial Officer";
    Relation["ChiefOperatingOfficer"] = "Chief Operating Officer";
    Relation["ChiefTechnologyOfficer"] = "Chief Technology Officer";
    Relation["Director"] = "Director";
    Relation["DirectorIndependent"] = "Director (Independent)";
    Relation["Empty"] = "";
    Relation["GeneralCounsel"] = "General Counsel";
    Relation["IndependentNonExecutiveDirector"] = "Independent Non-Executive Director";
    Relation["Officer"] = "Officer";
    Relation["President"] = "President";
})(Relation || (exports.Relation = Relation = {}));
var OwnershipEnum;
(function (OwnershipEnum) {
    OwnershipEnum["D"] = "D";
    OwnershipEnum["I"] = "I";
})(OwnershipEnum || (exports.OwnershipEnum = OwnershipEnum = {}));
var Action;
(function (Action) {
    Action["Down"] = "down";
    Action["Init"] = "init";
    Action["Main"] = "main";
    Action["Reit"] = "reit";
    Action["Up"] = "up";
})(Action || (exports.Action = Action = {}));
var Grade;
(function (Grade) {
    Grade["Accumulate"] = "Accumulate";
    Grade["Add"] = "Add";
    Grade["Average"] = "Average";
    Grade["BelowAverage"] = "Below Average";
    Grade["Buy"] = "Buy";
    Grade["ConvictionBuy"] = "Conviction Buy";
    Grade["Empty"] = "";
    Grade["EqualWeight"] = "Equal-Weight";
    Grade["FairValue"] = "Fair Value";
    Grade["GradeEqualWeight"] = "Equal-weight";
    Grade["GradeLongTermBuy"] = "Long-term Buy";
    Grade["Hold"] = "Hold";
    Grade["LongTermBuy"] = "Long-Term Buy";
    Grade["MarketOutperform"] = "Market Outperform";
    Grade["MarketPerform"] = "Market Perform";
    Grade["Mixed"] = "Mixed";
    Grade["Negative"] = "Negative";
    Grade["Neutral"] = "Neutral";
    Grade["InLine"] = "In-Line";
    Grade["Outperform"] = "Outperform";
    Grade["Overweight"] = "Overweight";
    Grade["PeerPerform"] = "Peer Perform";
    Grade["Perform"] = "Perform";
    Grade["Positive"] = "Positive";
    Grade["Reduce"] = "Reduce";
    Grade["SectorOutperform"] = "Sector Outperform";
    Grade["SectorPerform"] = "Sector Perform";
    Grade["SectorWeight"] = "Sector Weight";
    Grade["Sell"] = "Sell";
    Grade["StrongBuy"] = "Strong Buy";
    Grade["TopPick"] = "Top Pick";
    Grade["Underperform"] = "Underperform";
    Grade["Underperformer"] = "Underperformer";
    Grade["Underweight"] = "Underweight";
    Grade["Trim"] = "Trim";
    Grade["AboveAverage"] = "Above Average";
    Grade["Inline"] = "In-line";
    Grade["Outperformer"] = "Outperformer";
    Grade["OVerweight"] = "OVerweight";
    Grade["Cautious"] = "Cautious";
    Grade["MarketWeight"] = "Market Weight";
    Grade["SectorUnderperform"] = "Sector Underperform";
    Grade["MarketUnderperform"] = "Market Underperform";
    Grade["Peerperform"] = "Peer perform";
    Grade["GraduallyAccumulate"] = "Gradually Accumulate";
    Grade["ActionListBuy"] = "Action List Buy";
    Grade["Performer"] = "Performer";
    Grade["SectorPerformer"] = "Sector Performer";
    Grade["SpeculativeBuy"] = "Speculative Buy";
    Grade["StrongSell"] = "Strong Sell";
    Grade["SpeculativeHold"] = "Speculative Hold";
    Grade["NotRated"] = "Not Rated";
    Grade["HoldNeutral"] = "Hold Neutral";
    Grade["Developing"] = "Developing";
    Grade["buy"] = "buy";
    Grade["HOld"] = "HOld";
    Grade["TradingSell"] = "Trading Sell";
    Grade["Tender"] = "Tender";
    Grade["marketperform"] = "market perform";
    Grade["BUy"] = "BUy";
})(Grade || (exports.Grade = Grade = {}));
