"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = {
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$comment": "DO NOT EDIT THIS FILE.  It is generated automatically from typescript interfaces in the project.  To update, run `deno task schema` (with optional `--watch`).  In VSCode, this is run automatically for you on folder open.",
    "definitions": {
        "OptionsResult": {
            "type": "object",
            "properties": {
                "underlyingSymbol": {
                    "type": "string"
                },
                "expirationDates": {
                    "type": "array",
                    "items": {
                        "type": "string",
                        "format": "date-time"
                    }
                },
                "strikes": {
                    "type": "array",
                    "items": {
                        "type": "number"
                    }
                },
                "hasMiniOptions": {
                    "type": "boolean"
                },
                "quote": {
                    "$ref": "#/definitions/Quote"
                },
                "options": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/Option"
                    }
                }
            },
            "required": [
                "underlyingSymbol",
                "expirationDates",
                "strikes",
                "hasMiniOptions",
                "quote",
                "options"
            ],
            "additionalProperties": {}
        },
        "Quote": {
            "type": "object",
            "discriminator": {
                "propertyName": "quoteType"
            },
            "required": [
                "quoteType"
            ],
            "oneOf": [
                {
                    "$ref": "#/definitions/QuoteAltSymbol"
                },
                {
                    "$ref": "#/definitions/QuoteCryptoCurrency"
                },
                {
                    "$ref": "#/definitions/QuoteCurrency"
                },
                {
                    "$ref": "#/definitions/QuoteECNQuote"
                },
                {
                    "$ref": "#/definitions/QuoteEtf"
                },
                {
                    "$ref": "#/definitions/QuoteEquity"
                },
                {
                    "$ref": "#/definitions/QuoteFuture"
                },
                {
                    "$ref": "#/definitions/QuoteIndex"
                },
                {
                    "$ref": "#/definitions/QuoteMutualfund"
                },
                {
                    "$ref": "#/definitions/QuoteOption"
                },
                {
                    "$ref": "#/definitions/QuoteMoneyMarket"
                }
            ]
        },
        "QuoteAltSymbol": {
            "type": "object",
            "properties": {
                "language": {
                    "type": "string"
                },
                "region": {
                    "type": "string"
                },
                "quoteType": {
                    "type": "string",
                    "const": "ALTSYMBOL"
                },
                "typeDisp": {
                    "type": "string",
                    "const": "ALTSYMBOL"
                },
                "quoteSourceName": {
                    "type": "string"
                },
                "triggerable": {
                    "type": "boolean"
                },
                "currency": {
                    "type": "string"
                },
                "customPriceAlertConfidence": {
                    "type": "string"
                },
                "marketState": {
                    "type": "string",
                    "enum": [
                        "REGULAR",
                        "CLOSED",
                        "PRE",
                        "PREPRE",
                        "POST",
                        "POSTPOST"
                    ]
                },
                "tradeable": {
                    "type": "boolean"
                },
                "cryptoTradeable": {
                    "type": "boolean"
                },
                "corporateActions": {
                    "type": "array",
                    "items": {}
                },
                "exchange": {
                    "type": "string"
                },
                "shortName": {
                    "type": "string"
                },
                "longName": {
                    "type": "string"
                },
                "messageBoardId": {
                    "type": "string"
                },
                "exchangeTimezoneName": {
                    "type": "string"
                },
                "exchangeTimezoneShortName": {
                    "type": "string"
                },
                "gmtOffSetMilliseconds": {
                    "type": "number"
                },
                "market": {
                    "type": "string"
                },
                "esgPopulated": {
                    "type": "boolean"
                },
                "fiftyTwoWeekLowChange": {
                    "type": "number"
                },
                "fiftyTwoWeekLowChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "fiftyTwoWeekHighChange": {
                    "type": "number"
                },
                "fiftyTwoWeekHighChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekLow": {
                    "type": "number"
                },
                "fiftyTwoWeekHigh": {
                    "type": "number"
                },
                "fiftyTwoWeekChangePercent": {
                    "type": "number"
                },
                "dividendDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestamp": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "isEarningsDateEstimate": {
                    "type": "boolean"
                },
                "trailingAnnualDividendRate": {
                    "type": "number"
                },
                "trailingPE": {
                    "type": "number"
                },
                "trailingAnnualDividendYield": {
                    "type": "number"
                },
                "epsTrailingTwelveMonths": {
                    "type": "number"
                },
                "epsForward": {
                    "type": "number"
                },
                "epsCurrentYear": {
                    "type": "number"
                },
                "priceEpsCurrentYear": {
                    "type": "number"
                },
                "sharesOutstanding": {
                    "type": "number"
                },
                "bookValue": {
                    "type": "number"
                },
                "fiftyDayAverage": {
                    "type": "number"
                },
                "fiftyDayAverageChange": {
                    "type": "number"
                },
                "fiftyDayAverageChangePercent": {
                    "type": "number"
                },
                "twoHundredDayAverage": {
                    "type": "number"
                },
                "twoHundredDayAverageChange": {
                    "type": "number"
                },
                "twoHundredDayAverageChangePercent": {
                    "type": "number"
                },
                "marketCap": {
                    "type": "number"
                },
                "forwardPE": {
                    "type": "number"
                },
                "priceToBook": {
                    "type": "number"
                },
                "sourceInterval": {
                    "type": "number"
                },
                "exchangeDataDelayedBy": {
                    "type": "number"
                },
                "firstTradeDateMilliseconds": {
                    "$ref": "#/definitions/DateInMs"
                },
                "priceHint": {
                    "type": "number"
                },
                "postMarketChangePercent": {
                    "type": "number"
                },
                "postMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "postMarketPrice": {
                    "type": "number"
                },
                "postMarketChange": {
                    "type": "number"
                },
                "hasPrePostMarketData": {
                    "type": "boolean"
                },
                "extendedMarketChange": {
                    "type": "number"
                },
                "extendedMarketChangePercent": {
                    "type": "number"
                },
                "extendedMarketPrice": {
                    "type": "number"
                },
                "extendedMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketChange": {
                    "type": "number"
                },
                "regularMarketChangePercent": {
                    "type": "number"
                },
                "regularMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketPrice": {
                    "type": "number"
                },
                "regularMarketDayHigh": {
                    "type": "number"
                },
                "regularMarketDayRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "regularMarketDayLow": {
                    "type": "number"
                },
                "regularMarketVolume": {
                    "type": "number"
                },
                "dayHigh": {
                    "type": "number"
                },
                "dayLow": {
                    "type": "number"
                },
                "volume": {
                    "type": "number"
                },
                "regularMarketPreviousClose": {
                    "type": "number"
                },
                "preMarketChange": {
                    "type": "number"
                },
                "preMarketChangePercent": {
                    "type": "number"
                },
                "preMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "preMarketPrice": {
                    "type": "number"
                },
                "bid": {
                    "type": "number"
                },
                "ask": {
                    "type": "number"
                },
                "bidSize": {
                    "type": "number"
                },
                "askSize": {
                    "type": "number"
                },
                "fullExchangeName": {
                    "type": "string"
                },
                "financialCurrency": {
                    "type": "string"
                },
                "regularMarketOpen": {
                    "type": "number"
                },
                "averageDailyVolume3Month": {
                    "type": "number"
                },
                "averageDailyVolume10Day": {
                    "type": "number"
                },
                "displayName": {
                    "type": "string"
                },
                "symbol": {
                    "type": "string"
                },
                "underlyingSymbol": {
                    "type": "string"
                },
                "ytdReturn": {
                    "type": "number"
                },
                "trailingThreeMonthReturns": {
                    "type": "number"
                },
                "trailingThreeMonthNavReturns": {
                    "type": "number"
                },
                "ipoExpectedDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "newListingDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "nameChangeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "prevName": {
                    "type": "string"
                },
                "averageAnalystRating": {
                    "type": "string"
                },
                "pageViewGrowthWeekly": {
                    "type": "number"
                },
                "openInterest": {
                    "type": "number"
                },
                "beta": {
                    "type": "number"
                },
                "companyLogoUrl": {
                    "type": "string"
                },
                "logoUrl": {
                    "type": "string"
                },
                "underlyingExchangeSymbol": {
                    "type": "string"
                },
                "expireDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "expireIsoDate": {
                    "type": "string"
                }
            },
            "required": [
                "esgPopulated",
                "exchange",
                "exchangeDataDelayedBy",
                "exchangeTimezoneName",
                "exchangeTimezoneShortName",
                "expireDate",
                "expireIsoDate",
                "fullExchangeName",
                "gmtOffSetMilliseconds",
                "language",
                "market",
                "marketState",
                "quoteType",
                "region",
                "sourceInterval",
                "symbol",
                "tradeable",
                "triggerable",
                "typeDisp",
                "underlyingExchangeSymbol"
            ]
        },
        "QuoteBase": {
            "type": "object",
            "properties": {
                "language": {
                    "type": "string"
                },
                "region": {
                    "type": "string"
                },
                "quoteType": {
                    "type": "string"
                },
                "typeDisp": {
                    "type": "string"
                },
                "quoteSourceName": {
                    "type": "string"
                },
                "triggerable": {
                    "type": "boolean"
                },
                "currency": {
                    "type": "string"
                },
                "customPriceAlertConfidence": {
                    "type": "string"
                },
                "marketState": {
                    "type": "string",
                    "enum": [
                        "REGULAR",
                        "CLOSED",
                        "PRE",
                        "PREPRE",
                        "POST",
                        "POSTPOST"
                    ]
                },
                "tradeable": {
                    "type": "boolean"
                },
                "cryptoTradeable": {
                    "type": "boolean"
                },
                "corporateActions": {
                    "type": "array",
                    "items": {}
                },
                "exchange": {
                    "type": "string"
                },
                "shortName": {
                    "type": "string"
                },
                "longName": {
                    "type": "string"
                },
                "messageBoardId": {
                    "type": "string"
                },
                "exchangeTimezoneName": {
                    "type": "string"
                },
                "exchangeTimezoneShortName": {
                    "type": "string"
                },
                "gmtOffSetMilliseconds": {
                    "type": "number"
                },
                "market": {
                    "type": "string"
                },
                "esgPopulated": {
                    "type": "boolean"
                },
                "fiftyTwoWeekLowChange": {
                    "type": "number"
                },
                "fiftyTwoWeekLowChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "fiftyTwoWeekHighChange": {
                    "type": "number"
                },
                "fiftyTwoWeekHighChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekLow": {
                    "type": "number"
                },
                "fiftyTwoWeekHigh": {
                    "type": "number"
                },
                "fiftyTwoWeekChangePercent": {
                    "type": "number"
                },
                "dividendDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestamp": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "isEarningsDateEstimate": {
                    "type": "boolean"
                },
                "trailingAnnualDividendRate": {
                    "type": "number"
                },
                "trailingPE": {
                    "type": "number"
                },
                "trailingAnnualDividendYield": {
                    "type": "number"
                },
                "epsTrailingTwelveMonths": {
                    "type": "number"
                },
                "epsForward": {
                    "type": "number"
                },
                "epsCurrentYear": {
                    "type": "number"
                },
                "priceEpsCurrentYear": {
                    "type": "number"
                },
                "sharesOutstanding": {
                    "type": "number"
                },
                "bookValue": {
                    "type": "number"
                },
                "fiftyDayAverage": {
                    "type": "number"
                },
                "fiftyDayAverageChange": {
                    "type": "number"
                },
                "fiftyDayAverageChangePercent": {
                    "type": "number"
                },
                "twoHundredDayAverage": {
                    "type": "number"
                },
                "twoHundredDayAverageChange": {
                    "type": "number"
                },
                "twoHundredDayAverageChangePercent": {
                    "type": "number"
                },
                "marketCap": {
                    "type": "number"
                },
                "forwardPE": {
                    "type": "number"
                },
                "priceToBook": {
                    "type": "number"
                },
                "sourceInterval": {
                    "type": "number"
                },
                "exchangeDataDelayedBy": {
                    "type": "number"
                },
                "firstTradeDateMilliseconds": {
                    "$ref": "#/definitions/DateInMs"
                },
                "priceHint": {
                    "type": "number"
                },
                "postMarketChangePercent": {
                    "type": "number"
                },
                "postMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "postMarketPrice": {
                    "type": "number"
                },
                "postMarketChange": {
                    "type": "number"
                },
                "hasPrePostMarketData": {
                    "type": "boolean"
                },
                "extendedMarketChange": {
                    "type": "number"
                },
                "extendedMarketChangePercent": {
                    "type": "number"
                },
                "extendedMarketPrice": {
                    "type": "number"
                },
                "extendedMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketChange": {
                    "type": "number"
                },
                "regularMarketChangePercent": {
                    "type": "number"
                },
                "regularMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketPrice": {
                    "type": "number"
                },
                "regularMarketDayHigh": {
                    "type": "number"
                },
                "regularMarketDayRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "regularMarketDayLow": {
                    "type": "number"
                },
                "regularMarketVolume": {
                    "type": "number"
                },
                "dayHigh": {
                    "type": "number"
                },
                "dayLow": {
                    "type": "number"
                },
                "volume": {
                    "type": "number"
                },
                "regularMarketPreviousClose": {
                    "type": "number"
                },
                "preMarketChange": {
                    "type": "number"
                },
                "preMarketChangePercent": {
                    "type": "number"
                },
                "preMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "preMarketPrice": {
                    "type": "number"
                },
                "bid": {
                    "type": "number"
                },
                "ask": {
                    "type": "number"
                },
                "bidSize": {
                    "type": "number"
                },
                "askSize": {
                    "type": "number"
                },
                "fullExchangeName": {
                    "type": "string"
                },
                "financialCurrency": {
                    "type": "string"
                },
                "regularMarketOpen": {
                    "type": "number"
                },
                "averageDailyVolume3Month": {
                    "type": "number"
                },
                "averageDailyVolume10Day": {
                    "type": "number"
                },
                "displayName": {
                    "type": "string"
                },
                "symbol": {
                    "type": "string"
                },
                "underlyingSymbol": {
                    "type": "string"
                },
                "ytdReturn": {
                    "type": "number"
                },
                "trailingThreeMonthReturns": {
                    "type": "number"
                },
                "trailingThreeMonthNavReturns": {
                    "type": "number"
                },
                "ipoExpectedDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "newListingDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "nameChangeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "prevName": {
                    "type": "string"
                },
                "averageAnalystRating": {
                    "type": "string"
                },
                "pageViewGrowthWeekly": {
                    "type": "number"
                },
                "openInterest": {
                    "type": "number"
                },
                "beta": {
                    "type": "number"
                },
                "companyLogoUrl": {
                    "type": "string"
                },
                "logoUrl": {
                    "type": "string"
                }
            },
            "required": [
                "language",
                "region",
                "quoteType",
                "triggerable",
                "marketState",
                "tradeable",
                "exchange",
                "exchangeTimezoneName",
                "exchangeTimezoneShortName",
                "gmtOffSetMilliseconds",
                "market",
                "esgPopulated",
                "sourceInterval",
                "exchangeDataDelayedBy",
                "fullExchangeName",
                "symbol"
            ]
        },
        "TwoNumberRange": {
            "type": "object",
            "properties": {
                "low": {
                    "type": "number"
                },
                "high": {
                    "type": "number"
                }
            },
            "required": [
                "low",
                "high"
            ],
            "additionalProperties": false
        },
        "DateInMs": {
            "type": "string",
            "format": "date-time"
        },
        "QuoteCryptoCurrency": {
            "type": "object",
            "properties": {
                "language": {
                    "type": "string"
                },
                "region": {
                    "type": "string"
                },
                "quoteType": {
                    "type": "string",
                    "const": "CRYPTOCURRENCY"
                },
                "typeDisp": {
                    "type": "string"
                },
                "quoteSourceName": {
                    "type": "string"
                },
                "triggerable": {
                    "type": "boolean"
                },
                "currency": {
                    "type": "string"
                },
                "customPriceAlertConfidence": {
                    "type": "string"
                },
                "marketState": {
                    "type": "string",
                    "enum": [
                        "REGULAR",
                        "CLOSED",
                        "PRE",
                        "PREPRE",
                        "POST",
                        "POSTPOST"
                    ]
                },
                "tradeable": {
                    "type": "boolean"
                },
                "cryptoTradeable": {
                    "type": "boolean"
                },
                "corporateActions": {
                    "type": "array",
                    "items": {}
                },
                "exchange": {
                    "type": "string"
                },
                "shortName": {
                    "type": "string"
                },
                "longName": {
                    "type": "string"
                },
                "messageBoardId": {
                    "type": "string"
                },
                "exchangeTimezoneName": {
                    "type": "string"
                },
                "exchangeTimezoneShortName": {
                    "type": "string"
                },
                "gmtOffSetMilliseconds": {
                    "type": "number"
                },
                "market": {
                    "type": "string"
                },
                "esgPopulated": {
                    "type": "boolean"
                },
                "fiftyTwoWeekLowChange": {
                    "type": "number"
                },
                "fiftyTwoWeekLowChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "fiftyTwoWeekHighChange": {
                    "type": "number"
                },
                "fiftyTwoWeekHighChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekLow": {
                    "type": "number"
                },
                "fiftyTwoWeekHigh": {
                    "type": "number"
                },
                "fiftyTwoWeekChangePercent": {
                    "type": "number"
                },
                "dividendDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestamp": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "isEarningsDateEstimate": {
                    "type": "boolean"
                },
                "trailingAnnualDividendRate": {
                    "type": "number"
                },
                "trailingPE": {
                    "type": "number"
                },
                "trailingAnnualDividendYield": {
                    "type": "number"
                },
                "epsTrailingTwelveMonths": {
                    "type": "number"
                },
                "epsForward": {
                    "type": "number"
                },
                "epsCurrentYear": {
                    "type": "number"
                },
                "priceEpsCurrentYear": {
                    "type": "number"
                },
                "sharesOutstanding": {
                    "type": "number"
                },
                "bookValue": {
                    "type": "number"
                },
                "fiftyDayAverage": {
                    "type": "number"
                },
                "fiftyDayAverageChange": {
                    "type": "number"
                },
                "fiftyDayAverageChangePercent": {
                    "type": "number"
                },
                "twoHundredDayAverage": {
                    "type": "number"
                },
                "twoHundredDayAverageChange": {
                    "type": "number"
                },
                "twoHundredDayAverageChangePercent": {
                    "type": "number"
                },
                "marketCap": {
                    "type": "number"
                },
                "forwardPE": {
                    "type": "number"
                },
                "priceToBook": {
                    "type": "number"
                },
                "sourceInterval": {
                    "type": "number"
                },
                "exchangeDataDelayedBy": {
                    "type": "number"
                },
                "firstTradeDateMilliseconds": {
                    "$ref": "#/definitions/DateInMs"
                },
                "priceHint": {
                    "type": "number"
                },
                "postMarketChangePercent": {
                    "type": "number"
                },
                "postMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "postMarketPrice": {
                    "type": "number"
                },
                "postMarketChange": {
                    "type": "number"
                },
                "hasPrePostMarketData": {
                    "type": "boolean"
                },
                "extendedMarketChange": {
                    "type": "number"
                },
                "extendedMarketChangePercent": {
                    "type": "number"
                },
                "extendedMarketPrice": {
                    "type": "number"
                },
                "extendedMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketChange": {
                    "type": "number"
                },
                "regularMarketChangePercent": {
                    "type": "number"
                },
                "regularMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketPrice": {
                    "type": "number"
                },
                "regularMarketDayHigh": {
                    "type": "number"
                },
                "regularMarketDayRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "regularMarketDayLow": {
                    "type": "number"
                },
                "regularMarketVolume": {
                    "type": "number"
                },
                "dayHigh": {
                    "type": "number"
                },
                "dayLow": {
                    "type": "number"
                },
                "volume": {
                    "type": "number"
                },
                "regularMarketPreviousClose": {
                    "type": "number"
                },
                "preMarketChange": {
                    "type": "number"
                },
                "preMarketChangePercent": {
                    "type": "number"
                },
                "preMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "preMarketPrice": {
                    "type": "number"
                },
                "bid": {
                    "type": "number"
                },
                "ask": {
                    "type": "number"
                },
                "bidSize": {
                    "type": "number"
                },
                "askSize": {
                    "type": "number"
                },
                "fullExchangeName": {
                    "type": "string"
                },
                "financialCurrency": {
                    "type": "string"
                },
                "regularMarketOpen": {
                    "type": "number"
                },
                "averageDailyVolume3Month": {
                    "type": "number"
                },
                "averageDailyVolume10Day": {
                    "type": "number"
                },
                "displayName": {
                    "type": "string"
                },
                "symbol": {
                    "type": "string"
                },
                "underlyingSymbol": {
                    "type": "string"
                },
                "ytdReturn": {
                    "type": "number"
                },
                "trailingThreeMonthReturns": {
                    "type": "number"
                },
                "trailingThreeMonthNavReturns": {
                    "type": "number"
                },
                "ipoExpectedDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "newListingDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "nameChangeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "prevName": {
                    "type": "string"
                },
                "averageAnalystRating": {
                    "type": "string"
                },
                "pageViewGrowthWeekly": {
                    "type": "number"
                },
                "openInterest": {
                    "type": "number"
                },
                "beta": {
                    "type": "number"
                },
                "companyLogoUrl": {
                    "type": "string"
                },
                "logoUrl": {
                    "type": "string"
                },
                "circulatingSupply": {
                    "type": "number"
                },
                "fromCurrency": {
                    "type": "string"
                },
                "toCurrency": {
                    "type": "string"
                },
                "lastMarket": {
                    "type": "string"
                },
                "coinImageUrl": {
                    "type": "string"
                },
                "volume24Hr": {
                    "type": "number"
                },
                "volumeAllCurrencies": {
                    "type": "number"
                },
                "startDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "coinMarketCapLink": {
                    "type": "string"
                }
            },
            "required": [
                "esgPopulated",
                "exchange",
                "exchangeDataDelayedBy",
                "exchangeTimezoneName",
                "exchangeTimezoneShortName",
                "fullExchangeName",
                "gmtOffSetMilliseconds",
                "language",
                "market",
                "marketState",
                "quoteType",
                "region",
                "sourceInterval",
                "symbol",
                "tradeable",
                "triggerable"
            ]
        },
        "QuoteCurrency": {
            "type": "object",
            "properties": {
                "language": {
                    "type": "string"
                },
                "region": {
                    "type": "string"
                },
                "quoteType": {
                    "type": "string",
                    "const": "CURRENCY"
                },
                "typeDisp": {
                    "type": "string"
                },
                "quoteSourceName": {
                    "type": "string"
                },
                "triggerable": {
                    "type": "boolean"
                },
                "currency": {
                    "type": "string"
                },
                "customPriceAlertConfidence": {
                    "type": "string"
                },
                "marketState": {
                    "type": "string",
                    "enum": [
                        "REGULAR",
                        "CLOSED",
                        "PRE",
                        "PREPRE",
                        "POST",
                        "POSTPOST"
                    ]
                },
                "tradeable": {
                    "type": "boolean"
                },
                "cryptoTradeable": {
                    "type": "boolean"
                },
                "corporateActions": {
                    "type": "array",
                    "items": {}
                },
                "exchange": {
                    "type": "string"
                },
                "shortName": {
                    "type": "string"
                },
                "longName": {
                    "type": "string"
                },
                "messageBoardId": {
                    "type": "string"
                },
                "exchangeTimezoneName": {
                    "type": "string"
                },
                "exchangeTimezoneShortName": {
                    "type": "string"
                },
                "gmtOffSetMilliseconds": {
                    "type": "number"
                },
                "market": {
                    "type": "string"
                },
                "esgPopulated": {
                    "type": "boolean"
                },
                "fiftyTwoWeekLowChange": {
                    "type": "number"
                },
                "fiftyTwoWeekLowChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "fiftyTwoWeekHighChange": {
                    "type": "number"
                },
                "fiftyTwoWeekHighChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekLow": {
                    "type": "number"
                },
                "fiftyTwoWeekHigh": {
                    "type": "number"
                },
                "fiftyTwoWeekChangePercent": {
                    "type": "number"
                },
                "dividendDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestamp": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "isEarningsDateEstimate": {
                    "type": "boolean"
                },
                "trailingAnnualDividendRate": {
                    "type": "number"
                },
                "trailingPE": {
                    "type": "number"
                },
                "trailingAnnualDividendYield": {
                    "type": "number"
                },
                "epsTrailingTwelveMonths": {
                    "type": "number"
                },
                "epsForward": {
                    "type": "number"
                },
                "epsCurrentYear": {
                    "type": "number"
                },
                "priceEpsCurrentYear": {
                    "type": "number"
                },
                "sharesOutstanding": {
                    "type": "number"
                },
                "bookValue": {
                    "type": "number"
                },
                "fiftyDayAverage": {
                    "type": "number"
                },
                "fiftyDayAverageChange": {
                    "type": "number"
                },
                "fiftyDayAverageChangePercent": {
                    "type": "number"
                },
                "twoHundredDayAverage": {
                    "type": "number"
                },
                "twoHundredDayAverageChange": {
                    "type": "number"
                },
                "twoHundredDayAverageChangePercent": {
                    "type": "number"
                },
                "marketCap": {
                    "type": "number"
                },
                "forwardPE": {
                    "type": "number"
                },
                "priceToBook": {
                    "type": "number"
                },
                "sourceInterval": {
                    "type": "number"
                },
                "exchangeDataDelayedBy": {
                    "type": "number"
                },
                "firstTradeDateMilliseconds": {
                    "$ref": "#/definitions/DateInMs"
                },
                "priceHint": {
                    "type": "number"
                },
                "postMarketChangePercent": {
                    "type": "number"
                },
                "postMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "postMarketPrice": {
                    "type": "number"
                },
                "postMarketChange": {
                    "type": "number"
                },
                "hasPrePostMarketData": {
                    "type": "boolean"
                },
                "extendedMarketChange": {
                    "type": "number"
                },
                "extendedMarketChangePercent": {
                    "type": "number"
                },
                "extendedMarketPrice": {
                    "type": "number"
                },
                "extendedMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketChange": {
                    "type": "number"
                },
                "regularMarketChangePercent": {
                    "type": "number"
                },
                "regularMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketPrice": {
                    "type": "number"
                },
                "regularMarketDayHigh": {
                    "type": "number"
                },
                "regularMarketDayRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "regularMarketDayLow": {
                    "type": "number"
                },
                "regularMarketVolume": {
                    "type": "number"
                },
                "dayHigh": {
                    "type": "number"
                },
                "dayLow": {
                    "type": "number"
                },
                "volume": {
                    "type": "number"
                },
                "regularMarketPreviousClose": {
                    "type": "number"
                },
                "preMarketChange": {
                    "type": "number"
                },
                "preMarketChangePercent": {
                    "type": "number"
                },
                "preMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "preMarketPrice": {
                    "type": "number"
                },
                "bid": {
                    "type": "number"
                },
                "ask": {
                    "type": "number"
                },
                "bidSize": {
                    "type": "number"
                },
                "askSize": {
                    "type": "number"
                },
                "fullExchangeName": {
                    "type": "string"
                },
                "financialCurrency": {
                    "type": "string"
                },
                "regularMarketOpen": {
                    "type": "number"
                },
                "averageDailyVolume3Month": {
                    "type": "number"
                },
                "averageDailyVolume10Day": {
                    "type": "number"
                },
                "displayName": {
                    "type": "string"
                },
                "symbol": {
                    "type": "string"
                },
                "underlyingSymbol": {
                    "type": "string"
                },
                "ytdReturn": {
                    "type": "number"
                },
                "trailingThreeMonthReturns": {
                    "type": "number"
                },
                "trailingThreeMonthNavReturns": {
                    "type": "number"
                },
                "ipoExpectedDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "newListingDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "nameChangeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "prevName": {
                    "type": "string"
                },
                "averageAnalystRating": {
                    "type": "string"
                },
                "pageViewGrowthWeekly": {
                    "type": "number"
                },
                "openInterest": {
                    "type": "number"
                },
                "beta": {
                    "type": "number"
                },
                "companyLogoUrl": {
                    "type": "string"
                },
                "logoUrl": {
                    "type": "string"
                }
            },
            "required": [
                "esgPopulated",
                "exchange",
                "exchangeDataDelayedBy",
                "exchangeTimezoneName",
                "exchangeTimezoneShortName",
                "fullExchangeName",
                "gmtOffSetMilliseconds",
                "language",
                "market",
                "marketState",
                "quoteType",
                "region",
                "sourceInterval",
                "symbol",
                "tradeable",
                "triggerable"
            ]
        },
        "QuoteECNQuote": {
            "type": "object",
            "properties": {
                "dividendRate": {
                    "type": "number"
                },
                "dividendYield": {
                    "type": "number"
                },
                "language": {
                    "type": "string"
                },
                "region": {
                    "type": "string"
                },
                "typeDisp": {
                    "type": "string"
                },
                "quoteSourceName": {
                    "type": "string"
                },
                "triggerable": {
                    "type": "boolean"
                },
                "currency": {
                    "type": "string"
                },
                "customPriceAlertConfidence": {
                    "type": "string"
                },
                "marketState": {
                    "type": "string",
                    "enum": [
                        "REGULAR",
                        "CLOSED",
                        "PRE",
                        "PREPRE",
                        "POST",
                        "POSTPOST"
                    ]
                },
                "tradeable": {
                    "type": "boolean"
                },
                "cryptoTradeable": {
                    "type": "boolean"
                },
                "corporateActions": {
                    "type": "array",
                    "items": {}
                },
                "exchange": {
                    "type": "string"
                },
                "shortName": {
                    "type": "string"
                },
                "longName": {
                    "type": "string"
                },
                "messageBoardId": {
                    "type": "string"
                },
                "exchangeTimezoneName": {
                    "type": "string"
                },
                "exchangeTimezoneShortName": {
                    "type": "string"
                },
                "gmtOffSetMilliseconds": {
                    "type": "number"
                },
                "market": {
                    "type": "string"
                },
                "esgPopulated": {
                    "type": "boolean"
                },
                "fiftyTwoWeekLowChange": {
                    "type": "number"
                },
                "fiftyTwoWeekLowChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "fiftyTwoWeekHighChange": {
                    "type": "number"
                },
                "fiftyTwoWeekHighChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekLow": {
                    "type": "number"
                },
                "fiftyTwoWeekHigh": {
                    "type": "number"
                },
                "fiftyTwoWeekChangePercent": {
                    "type": "number"
                },
                "dividendDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestamp": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "isEarningsDateEstimate": {
                    "type": "boolean"
                },
                "trailingAnnualDividendRate": {
                    "type": "number"
                },
                "trailingPE": {
                    "type": "number"
                },
                "trailingAnnualDividendYield": {
                    "type": "number"
                },
                "epsTrailingTwelveMonths": {
                    "type": "number"
                },
                "epsForward": {
                    "type": "number"
                },
                "epsCurrentYear": {
                    "type": "number"
                },
                "priceEpsCurrentYear": {
                    "type": "number"
                },
                "sharesOutstanding": {
                    "type": "number"
                },
                "bookValue": {
                    "type": "number"
                },
                "fiftyDayAverage": {
                    "type": "number"
                },
                "fiftyDayAverageChange": {
                    "type": "number"
                },
                "fiftyDayAverageChangePercent": {
                    "type": "number"
                },
                "twoHundredDayAverage": {
                    "type": "number"
                },
                "twoHundredDayAverageChange": {
                    "type": "number"
                },
                "twoHundredDayAverageChangePercent": {
                    "type": "number"
                },
                "marketCap": {
                    "type": "number"
                },
                "forwardPE": {
                    "type": "number"
                },
                "priceToBook": {
                    "type": "number"
                },
                "sourceInterval": {
                    "type": "number"
                },
                "exchangeDataDelayedBy": {
                    "type": "number"
                },
                "firstTradeDateMilliseconds": {
                    "$ref": "#/definitions/DateInMs"
                },
                "priceHint": {
                    "type": "number"
                },
                "postMarketChangePercent": {
                    "type": "number"
                },
                "postMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "postMarketPrice": {
                    "type": "number"
                },
                "postMarketChange": {
                    "type": "number"
                },
                "hasPrePostMarketData": {
                    "type": "boolean"
                },
                "extendedMarketChange": {
                    "type": "number"
                },
                "extendedMarketChangePercent": {
                    "type": "number"
                },
                "extendedMarketPrice": {
                    "type": "number"
                },
                "extendedMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketChange": {
                    "type": "number"
                },
                "regularMarketChangePercent": {
                    "type": "number"
                },
                "regularMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketPrice": {
                    "type": "number"
                },
                "regularMarketDayHigh": {
                    "type": "number"
                },
                "regularMarketDayRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "regularMarketDayLow": {
                    "type": "number"
                },
                "regularMarketVolume": {
                    "type": "number"
                },
                "dayHigh": {
                    "type": "number"
                },
                "dayLow": {
                    "type": "number"
                },
                "volume": {
                    "type": "number"
                },
                "regularMarketPreviousClose": {
                    "type": "number"
                },
                "preMarketChange": {
                    "type": "number"
                },
                "preMarketChangePercent": {
                    "type": "number"
                },
                "preMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "preMarketPrice": {
                    "type": "number"
                },
                "bid": {
                    "type": "number"
                },
                "ask": {
                    "type": "number"
                },
                "bidSize": {
                    "type": "number"
                },
                "askSize": {
                    "type": "number"
                },
                "fullExchangeName": {
                    "type": "string"
                },
                "financialCurrency": {
                    "type": "string"
                },
                "regularMarketOpen": {
                    "type": "number"
                },
                "averageDailyVolume3Month": {
                    "type": "number"
                },
                "averageDailyVolume10Day": {
                    "type": "number"
                },
                "displayName": {
                    "type": "string"
                },
                "symbol": {
                    "type": "string"
                },
                "underlyingSymbol": {
                    "type": "string"
                },
                "ytdReturn": {
                    "type": "number"
                },
                "trailingThreeMonthReturns": {
                    "type": "number"
                },
                "trailingThreeMonthNavReturns": {
                    "type": "number"
                },
                "ipoExpectedDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "newListingDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "nameChangeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "prevName": {
                    "type": "string"
                },
                "averageAnalystRating": {
                    "type": "string"
                },
                "pageViewGrowthWeekly": {
                    "type": "number"
                },
                "openInterest": {
                    "type": "number"
                },
                "beta": {
                    "type": "number"
                },
                "companyLogoUrl": {
                    "type": "string"
                },
                "logoUrl": {
                    "type": "string"
                },
                "quoteType": {
                    "type": "string",
                    "const": "ECNQUOTE"
                }
            },
            "required": [
                "esgPopulated",
                "exchange",
                "exchangeDataDelayedBy",
                "exchangeTimezoneName",
                "exchangeTimezoneShortName",
                "fullExchangeName",
                "gmtOffSetMilliseconds",
                "language",
                "market",
                "marketState",
                "quoteType",
                "region",
                "sourceInterval",
                "symbol",
                "tradeable",
                "triggerable"
            ],
            "additionalProperties": false
        },
        "QuoteEtf": {
            "type": "object",
            "properties": {
                "language": {
                    "type": "string"
                },
                "region": {
                    "type": "string"
                },
                "quoteType": {
                    "type": "string",
                    "const": "ETF"
                },
                "typeDisp": {
                    "type": "string"
                },
                "quoteSourceName": {
                    "type": "string"
                },
                "triggerable": {
                    "type": "boolean"
                },
                "currency": {
                    "type": "string"
                },
                "customPriceAlertConfidence": {
                    "type": "string"
                },
                "marketState": {
                    "type": "string",
                    "enum": [
                        "REGULAR",
                        "CLOSED",
                        "PRE",
                        "PREPRE",
                        "POST",
                        "POSTPOST"
                    ]
                },
                "tradeable": {
                    "type": "boolean"
                },
                "cryptoTradeable": {
                    "type": "boolean"
                },
                "corporateActions": {
                    "type": "array",
                    "items": {}
                },
                "exchange": {
                    "type": "string"
                },
                "shortName": {
                    "type": "string"
                },
                "longName": {
                    "type": "string"
                },
                "messageBoardId": {
                    "type": "string"
                },
                "exchangeTimezoneName": {
                    "type": "string"
                },
                "exchangeTimezoneShortName": {
                    "type": "string"
                },
                "gmtOffSetMilliseconds": {
                    "type": "number"
                },
                "market": {
                    "type": "string"
                },
                "esgPopulated": {
                    "type": "boolean"
                },
                "fiftyTwoWeekLowChange": {
                    "type": "number"
                },
                "fiftyTwoWeekLowChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "fiftyTwoWeekHighChange": {
                    "type": "number"
                },
                "fiftyTwoWeekHighChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekLow": {
                    "type": "number"
                },
                "fiftyTwoWeekHigh": {
                    "type": "number"
                },
                "fiftyTwoWeekChangePercent": {
                    "type": "number"
                },
                "dividendDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestamp": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "isEarningsDateEstimate": {
                    "type": "boolean"
                },
                "trailingAnnualDividendRate": {
                    "type": "number"
                },
                "trailingPE": {
                    "type": "number"
                },
                "trailingAnnualDividendYield": {
                    "type": "number"
                },
                "epsTrailingTwelveMonths": {
                    "type": "number"
                },
                "epsForward": {
                    "type": "number"
                },
                "epsCurrentYear": {
                    "type": "number"
                },
                "priceEpsCurrentYear": {
                    "type": "number"
                },
                "sharesOutstanding": {
                    "type": "number"
                },
                "bookValue": {
                    "type": "number"
                },
                "fiftyDayAverage": {
                    "type": "number"
                },
                "fiftyDayAverageChange": {
                    "type": "number"
                },
                "fiftyDayAverageChangePercent": {
                    "type": "number"
                },
                "twoHundredDayAverage": {
                    "type": "number"
                },
                "twoHundredDayAverageChange": {
                    "type": "number"
                },
                "twoHundredDayAverageChangePercent": {
                    "type": "number"
                },
                "marketCap": {
                    "type": "number"
                },
                "forwardPE": {
                    "type": "number"
                },
                "priceToBook": {
                    "type": "number"
                },
                "sourceInterval": {
                    "type": "number"
                },
                "exchangeDataDelayedBy": {
                    "type": "number"
                },
                "firstTradeDateMilliseconds": {
                    "$ref": "#/definitions/DateInMs"
                },
                "priceHint": {
                    "type": "number"
                },
                "postMarketChangePercent": {
                    "type": "number"
                },
                "postMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "postMarketPrice": {
                    "type": "number"
                },
                "postMarketChange": {
                    "type": "number"
                },
                "hasPrePostMarketData": {
                    "type": "boolean"
                },
                "extendedMarketChange": {
                    "type": "number"
                },
                "extendedMarketChangePercent": {
                    "type": "number"
                },
                "extendedMarketPrice": {
                    "type": "number"
                },
                "extendedMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketChange": {
                    "type": "number"
                },
                "regularMarketChangePercent": {
                    "type": "number"
                },
                "regularMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketPrice": {
                    "type": "number"
                },
                "regularMarketDayHigh": {
                    "type": "number"
                },
                "regularMarketDayRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "regularMarketDayLow": {
                    "type": "number"
                },
                "regularMarketVolume": {
                    "type": "number"
                },
                "dayHigh": {
                    "type": "number"
                },
                "dayLow": {
                    "type": "number"
                },
                "volume": {
                    "type": "number"
                },
                "regularMarketPreviousClose": {
                    "type": "number"
                },
                "preMarketChange": {
                    "type": "number"
                },
                "preMarketChangePercent": {
                    "type": "number"
                },
                "preMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "preMarketPrice": {
                    "type": "number"
                },
                "bid": {
                    "type": "number"
                },
                "ask": {
                    "type": "number"
                },
                "bidSize": {
                    "type": "number"
                },
                "askSize": {
                    "type": "number"
                },
                "fullExchangeName": {
                    "type": "string"
                },
                "financialCurrency": {
                    "type": "string"
                },
                "regularMarketOpen": {
                    "type": "number"
                },
                "averageDailyVolume3Month": {
                    "type": "number"
                },
                "averageDailyVolume10Day": {
                    "type": "number"
                },
                "displayName": {
                    "type": "string"
                },
                "symbol": {
                    "type": "string"
                },
                "underlyingSymbol": {
                    "type": "string"
                },
                "ytdReturn": {
                    "type": "number"
                },
                "trailingThreeMonthReturns": {
                    "type": "number"
                },
                "trailingThreeMonthNavReturns": {
                    "type": "number"
                },
                "ipoExpectedDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "newListingDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "nameChangeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "prevName": {
                    "type": "string"
                },
                "averageAnalystRating": {
                    "type": "string"
                },
                "pageViewGrowthWeekly": {
                    "type": "number"
                },
                "openInterest": {
                    "type": "number"
                },
                "beta": {
                    "type": "number"
                },
                "companyLogoUrl": {
                    "type": "string"
                },
                "logoUrl": {
                    "type": "string"
                },
                "dividendYield": {
                    "type": "number"
                },
                "netAssets": {
                    "type": "number"
                },
                "netExpenseRatio": {
                    "type": "number"
                }
            },
            "required": [
                "esgPopulated",
                "exchange",
                "exchangeDataDelayedBy",
                "exchangeTimezoneName",
                "exchangeTimezoneShortName",
                "fullExchangeName",
                "gmtOffSetMilliseconds",
                "language",
                "market",
                "marketState",
                "quoteType",
                "region",
                "sourceInterval",
                "symbol",
                "tradeable",
                "triggerable"
            ]
        },
        "QuoteEquity": {
            "type": "object",
            "properties": {
                "language": {
                    "type": "string"
                },
                "region": {
                    "type": "string"
                },
                "quoteType": {
                    "type": "string",
                    "const": "EQUITY"
                },
                "typeDisp": {
                    "type": "string"
                },
                "quoteSourceName": {
                    "type": "string"
                },
                "triggerable": {
                    "type": "boolean"
                },
                "currency": {
                    "type": "string"
                },
                "customPriceAlertConfidence": {
                    "type": "string"
                },
                "marketState": {
                    "type": "string",
                    "enum": [
                        "REGULAR",
                        "CLOSED",
                        "PRE",
                        "PREPRE",
                        "POST",
                        "POSTPOST"
                    ]
                },
                "tradeable": {
                    "type": "boolean"
                },
                "cryptoTradeable": {
                    "type": "boolean"
                },
                "corporateActions": {
                    "type": "array",
                    "items": {}
                },
                "exchange": {
                    "type": "string"
                },
                "shortName": {
                    "type": "string"
                },
                "longName": {
                    "type": "string"
                },
                "messageBoardId": {
                    "type": "string"
                },
                "exchangeTimezoneName": {
                    "type": "string"
                },
                "exchangeTimezoneShortName": {
                    "type": "string"
                },
                "gmtOffSetMilliseconds": {
                    "type": "number"
                },
                "market": {
                    "type": "string"
                },
                "esgPopulated": {
                    "type": "boolean"
                },
                "fiftyTwoWeekLowChange": {
                    "type": "number"
                },
                "fiftyTwoWeekLowChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "fiftyTwoWeekHighChange": {
                    "type": "number"
                },
                "fiftyTwoWeekHighChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekLow": {
                    "type": "number"
                },
                "fiftyTwoWeekHigh": {
                    "type": "number"
                },
                "fiftyTwoWeekChangePercent": {
                    "type": "number"
                },
                "dividendDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestamp": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "isEarningsDateEstimate": {
                    "type": "boolean"
                },
                "trailingAnnualDividendRate": {
                    "type": "number"
                },
                "trailingPE": {
                    "type": "number"
                },
                "trailingAnnualDividendYield": {
                    "type": "number"
                },
                "epsTrailingTwelveMonths": {
                    "type": "number"
                },
                "epsForward": {
                    "type": "number"
                },
                "epsCurrentYear": {
                    "type": "number"
                },
                "priceEpsCurrentYear": {
                    "type": "number"
                },
                "sharesOutstanding": {
                    "type": "number"
                },
                "bookValue": {
                    "type": "number"
                },
                "fiftyDayAverage": {
                    "type": "number"
                },
                "fiftyDayAverageChange": {
                    "type": "number"
                },
                "fiftyDayAverageChangePercent": {
                    "type": "number"
                },
                "twoHundredDayAverage": {
                    "type": "number"
                },
                "twoHundredDayAverageChange": {
                    "type": "number"
                },
                "twoHundredDayAverageChangePercent": {
                    "type": "number"
                },
                "marketCap": {
                    "type": "number"
                },
                "forwardPE": {
                    "type": "number"
                },
                "priceToBook": {
                    "type": "number"
                },
                "sourceInterval": {
                    "type": "number"
                },
                "exchangeDataDelayedBy": {
                    "type": "number"
                },
                "firstTradeDateMilliseconds": {
                    "$ref": "#/definitions/DateInMs"
                },
                "priceHint": {
                    "type": "number"
                },
                "postMarketChangePercent": {
                    "type": "number"
                },
                "postMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "postMarketPrice": {
                    "type": "number"
                },
                "postMarketChange": {
                    "type": "number"
                },
                "hasPrePostMarketData": {
                    "type": "boolean"
                },
                "extendedMarketChange": {
                    "type": "number"
                },
                "extendedMarketChangePercent": {
                    "type": "number"
                },
                "extendedMarketPrice": {
                    "type": "number"
                },
                "extendedMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketChange": {
                    "type": "number"
                },
                "regularMarketChangePercent": {
                    "type": "number"
                },
                "regularMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketPrice": {
                    "type": "number"
                },
                "regularMarketDayHigh": {
                    "type": "number"
                },
                "regularMarketDayRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "regularMarketDayLow": {
                    "type": "number"
                },
                "regularMarketVolume": {
                    "type": "number"
                },
                "dayHigh": {
                    "type": "number"
                },
                "dayLow": {
                    "type": "number"
                },
                "volume": {
                    "type": "number"
                },
                "regularMarketPreviousClose": {
                    "type": "number"
                },
                "preMarketChange": {
                    "type": "number"
                },
                "preMarketChangePercent": {
                    "type": "number"
                },
                "preMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "preMarketPrice": {
                    "type": "number"
                },
                "bid": {
                    "type": "number"
                },
                "ask": {
                    "type": "number"
                },
                "bidSize": {
                    "type": "number"
                },
                "askSize": {
                    "type": "number"
                },
                "fullExchangeName": {
                    "type": "string"
                },
                "financialCurrency": {
                    "type": "string"
                },
                "regularMarketOpen": {
                    "type": "number"
                },
                "averageDailyVolume3Month": {
                    "type": "number"
                },
                "averageDailyVolume10Day": {
                    "type": "number"
                },
                "displayName": {
                    "type": "string"
                },
                "symbol": {
                    "type": "string"
                },
                "underlyingSymbol": {
                    "type": "string"
                },
                "ytdReturn": {
                    "type": "number"
                },
                "trailingThreeMonthReturns": {
                    "type": "number"
                },
                "trailingThreeMonthNavReturns": {
                    "type": "number"
                },
                "ipoExpectedDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "newListingDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "nameChangeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "prevName": {
                    "type": "string"
                },
                "averageAnalystRating": {
                    "type": "string"
                },
                "pageViewGrowthWeekly": {
                    "type": "number"
                },
                "openInterest": {
                    "type": "number"
                },
                "beta": {
                    "type": "number"
                },
                "companyLogoUrl": {
                    "type": "string"
                },
                "logoUrl": {
                    "type": "string"
                },
                "dividendRate": {
                    "type": "number"
                },
                "dividendYield": {
                    "type": "number"
                }
            },
            "required": [
                "esgPopulated",
                "exchange",
                "exchangeDataDelayedBy",
                "exchangeTimezoneName",
                "exchangeTimezoneShortName",
                "fullExchangeName",
                "gmtOffSetMilliseconds",
                "language",
                "market",
                "marketState",
                "quoteType",
                "region",
                "sourceInterval",
                "symbol",
                "tradeable",
                "triggerable"
            ]
        },
        "QuoteFuture": {
            "type": "object",
            "properties": {
                "language": {
                    "type": "string"
                },
                "region": {
                    "type": "string"
                },
                "quoteType": {
                    "type": "string",
                    "const": "FUTURE"
                },
                "typeDisp": {
                    "type": "string"
                },
                "quoteSourceName": {
                    "type": "string"
                },
                "triggerable": {
                    "type": "boolean"
                },
                "currency": {
                    "type": "string"
                },
                "customPriceAlertConfidence": {
                    "type": "string"
                },
                "marketState": {
                    "type": "string",
                    "enum": [
                        "REGULAR",
                        "CLOSED",
                        "PRE",
                        "PREPRE",
                        "POST",
                        "POSTPOST"
                    ]
                },
                "tradeable": {
                    "type": "boolean"
                },
                "cryptoTradeable": {
                    "type": "boolean"
                },
                "corporateActions": {
                    "type": "array",
                    "items": {}
                },
                "exchange": {
                    "type": "string"
                },
                "shortName": {
                    "type": "string"
                },
                "longName": {
                    "type": "string"
                },
                "messageBoardId": {
                    "type": "string"
                },
                "exchangeTimezoneName": {
                    "type": "string"
                },
                "exchangeTimezoneShortName": {
                    "type": "string"
                },
                "gmtOffSetMilliseconds": {
                    "type": "number"
                },
                "market": {
                    "type": "string"
                },
                "esgPopulated": {
                    "type": "boolean"
                },
                "fiftyTwoWeekLowChange": {
                    "type": "number"
                },
                "fiftyTwoWeekLowChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "fiftyTwoWeekHighChange": {
                    "type": "number"
                },
                "fiftyTwoWeekHighChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekLow": {
                    "type": "number"
                },
                "fiftyTwoWeekHigh": {
                    "type": "number"
                },
                "fiftyTwoWeekChangePercent": {
                    "type": "number"
                },
                "dividendDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestamp": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "isEarningsDateEstimate": {
                    "type": "boolean"
                },
                "trailingAnnualDividendRate": {
                    "type": "number"
                },
                "trailingPE": {
                    "type": "number"
                },
                "trailingAnnualDividendYield": {
                    "type": "number"
                },
                "epsTrailingTwelveMonths": {
                    "type": "number"
                },
                "epsForward": {
                    "type": "number"
                },
                "epsCurrentYear": {
                    "type": "number"
                },
                "priceEpsCurrentYear": {
                    "type": "number"
                },
                "sharesOutstanding": {
                    "type": "number"
                },
                "bookValue": {
                    "type": "number"
                },
                "fiftyDayAverage": {
                    "type": "number"
                },
                "fiftyDayAverageChange": {
                    "type": "number"
                },
                "fiftyDayAverageChangePercent": {
                    "type": "number"
                },
                "twoHundredDayAverage": {
                    "type": "number"
                },
                "twoHundredDayAverageChange": {
                    "type": "number"
                },
                "twoHundredDayAverageChangePercent": {
                    "type": "number"
                },
                "marketCap": {
                    "type": "number"
                },
                "forwardPE": {
                    "type": "number"
                },
                "priceToBook": {
                    "type": "number"
                },
                "sourceInterval": {
                    "type": "number"
                },
                "exchangeDataDelayedBy": {
                    "type": "number"
                },
                "firstTradeDateMilliseconds": {
                    "$ref": "#/definitions/DateInMs"
                },
                "priceHint": {
                    "type": "number"
                },
                "postMarketChangePercent": {
                    "type": "number"
                },
                "postMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "postMarketPrice": {
                    "type": "number"
                },
                "postMarketChange": {
                    "type": "number"
                },
                "hasPrePostMarketData": {
                    "type": "boolean"
                },
                "extendedMarketChange": {
                    "type": "number"
                },
                "extendedMarketChangePercent": {
                    "type": "number"
                },
                "extendedMarketPrice": {
                    "type": "number"
                },
                "extendedMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketChange": {
                    "type": "number"
                },
                "regularMarketChangePercent": {
                    "type": "number"
                },
                "regularMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketPrice": {
                    "type": "number"
                },
                "regularMarketDayHigh": {
                    "type": "number"
                },
                "regularMarketDayRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "regularMarketDayLow": {
                    "type": "number"
                },
                "regularMarketVolume": {
                    "type": "number"
                },
                "dayHigh": {
                    "type": "number"
                },
                "dayLow": {
                    "type": "number"
                },
                "volume": {
                    "type": "number"
                },
                "regularMarketPreviousClose": {
                    "type": "number"
                },
                "preMarketChange": {
                    "type": "number"
                },
                "preMarketChangePercent": {
                    "type": "number"
                },
                "preMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "preMarketPrice": {
                    "type": "number"
                },
                "bid": {
                    "type": "number"
                },
                "ask": {
                    "type": "number"
                },
                "bidSize": {
                    "type": "number"
                },
                "askSize": {
                    "type": "number"
                },
                "fullExchangeName": {
                    "type": "string"
                },
                "financialCurrency": {
                    "type": "string"
                },
                "regularMarketOpen": {
                    "type": "number"
                },
                "averageDailyVolume3Month": {
                    "type": "number"
                },
                "averageDailyVolume10Day": {
                    "type": "number"
                },
                "displayName": {
                    "type": "string"
                },
                "symbol": {
                    "type": "string"
                },
                "underlyingSymbol": {
                    "type": "string"
                },
                "ytdReturn": {
                    "type": "number"
                },
                "trailingThreeMonthReturns": {
                    "type": "number"
                },
                "trailingThreeMonthNavReturns": {
                    "type": "number"
                },
                "ipoExpectedDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "newListingDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "nameChangeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "prevName": {
                    "type": "string"
                },
                "averageAnalystRating": {
                    "type": "string"
                },
                "pageViewGrowthWeekly": {
                    "type": "number"
                },
                "openInterest": {
                    "type": "number"
                },
                "beta": {
                    "type": "number"
                },
                "companyLogoUrl": {
                    "type": "string"
                },
                "logoUrl": {
                    "type": "string"
                },
                "headSymbolAsString": {
                    "type": "string"
                },
                "contractSymbol": {
                    "type": "boolean"
                },
                "underlyingExchangeSymbol": {
                    "type": "string"
                },
                "expireDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "expireIsoDate": {
                    "type": "string",
                    "format": "date-time"
                }
            },
            "required": [
                "contractSymbol",
                "esgPopulated",
                "exchange",
                "exchangeDataDelayedBy",
                "exchangeTimezoneName",
                "exchangeTimezoneShortName",
                "expireDate",
                "expireIsoDate",
                "fullExchangeName",
                "gmtOffSetMilliseconds",
                "language",
                "market",
                "marketState",
                "quoteType",
                "region",
                "sourceInterval",
                "symbol",
                "tradeable",
                "triggerable",
                "underlyingExchangeSymbol"
            ]
        },
        "QuoteIndex": {
            "type": "object",
            "properties": {
                "language": {
                    "type": "string"
                },
                "region": {
                    "type": "string"
                },
                "quoteType": {
                    "type": "string",
                    "const": "INDEX"
                },
                "typeDisp": {
                    "type": "string"
                },
                "quoteSourceName": {
                    "type": "string"
                },
                "triggerable": {
                    "type": "boolean"
                },
                "currency": {
                    "type": "string"
                },
                "customPriceAlertConfidence": {
                    "type": "string"
                },
                "marketState": {
                    "type": "string",
                    "enum": [
                        "REGULAR",
                        "CLOSED",
                        "PRE",
                        "PREPRE",
                        "POST",
                        "POSTPOST"
                    ]
                },
                "tradeable": {
                    "type": "boolean"
                },
                "cryptoTradeable": {
                    "type": "boolean"
                },
                "corporateActions": {
                    "type": "array",
                    "items": {}
                },
                "exchange": {
                    "type": "string"
                },
                "shortName": {
                    "type": "string"
                },
                "longName": {
                    "type": "string"
                },
                "messageBoardId": {
                    "type": "string"
                },
                "exchangeTimezoneName": {
                    "type": "string"
                },
                "exchangeTimezoneShortName": {
                    "type": "string"
                },
                "gmtOffSetMilliseconds": {
                    "type": "number"
                },
                "market": {
                    "type": "string"
                },
                "esgPopulated": {
                    "type": "boolean"
                },
                "fiftyTwoWeekLowChange": {
                    "type": "number"
                },
                "fiftyTwoWeekLowChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "fiftyTwoWeekHighChange": {
                    "type": "number"
                },
                "fiftyTwoWeekHighChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekLow": {
                    "type": "number"
                },
                "fiftyTwoWeekHigh": {
                    "type": "number"
                },
                "fiftyTwoWeekChangePercent": {
                    "type": "number"
                },
                "dividendDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestamp": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "isEarningsDateEstimate": {
                    "type": "boolean"
                },
                "trailingAnnualDividendRate": {
                    "type": "number"
                },
                "trailingPE": {
                    "type": "number"
                },
                "trailingAnnualDividendYield": {
                    "type": "number"
                },
                "epsTrailingTwelveMonths": {
                    "type": "number"
                },
                "epsForward": {
                    "type": "number"
                },
                "epsCurrentYear": {
                    "type": "number"
                },
                "priceEpsCurrentYear": {
                    "type": "number"
                },
                "sharesOutstanding": {
                    "type": "number"
                },
                "bookValue": {
                    "type": "number"
                },
                "fiftyDayAverage": {
                    "type": "number"
                },
                "fiftyDayAverageChange": {
                    "type": "number"
                },
                "fiftyDayAverageChangePercent": {
                    "type": "number"
                },
                "twoHundredDayAverage": {
                    "type": "number"
                },
                "twoHundredDayAverageChange": {
                    "type": "number"
                },
                "twoHundredDayAverageChangePercent": {
                    "type": "number"
                },
                "marketCap": {
                    "type": "number"
                },
                "forwardPE": {
                    "type": "number"
                },
                "priceToBook": {
                    "type": "number"
                },
                "sourceInterval": {
                    "type": "number"
                },
                "exchangeDataDelayedBy": {
                    "type": "number"
                },
                "firstTradeDateMilliseconds": {
                    "$ref": "#/definitions/DateInMs"
                },
                "priceHint": {
                    "type": "number"
                },
                "postMarketChangePercent": {
                    "type": "number"
                },
                "postMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "postMarketPrice": {
                    "type": "number"
                },
                "postMarketChange": {
                    "type": "number"
                },
                "hasPrePostMarketData": {
                    "type": "boolean"
                },
                "extendedMarketChange": {
                    "type": "number"
                },
                "extendedMarketChangePercent": {
                    "type": "number"
                },
                "extendedMarketPrice": {
                    "type": "number"
                },
                "extendedMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketChange": {
                    "type": "number"
                },
                "regularMarketChangePercent": {
                    "type": "number"
                },
                "regularMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketPrice": {
                    "type": "number"
                },
                "regularMarketDayHigh": {
                    "type": "number"
                },
                "regularMarketDayRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "regularMarketDayLow": {
                    "type": "number"
                },
                "regularMarketVolume": {
                    "type": "number"
                },
                "dayHigh": {
                    "type": "number"
                },
                "dayLow": {
                    "type": "number"
                },
                "volume": {
                    "type": "number"
                },
                "regularMarketPreviousClose": {
                    "type": "number"
                },
                "preMarketChange": {
                    "type": "number"
                },
                "preMarketChangePercent": {
                    "type": "number"
                },
                "preMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "preMarketPrice": {
                    "type": "number"
                },
                "bid": {
                    "type": "number"
                },
                "ask": {
                    "type": "number"
                },
                "bidSize": {
                    "type": "number"
                },
                "askSize": {
                    "type": "number"
                },
                "fullExchangeName": {
                    "type": "string"
                },
                "financialCurrency": {
                    "type": "string"
                },
                "regularMarketOpen": {
                    "type": "number"
                },
                "averageDailyVolume3Month": {
                    "type": "number"
                },
                "averageDailyVolume10Day": {
                    "type": "number"
                },
                "displayName": {
                    "type": "string"
                },
                "symbol": {
                    "type": "string"
                },
                "underlyingSymbol": {
                    "type": "string"
                },
                "ytdReturn": {
                    "type": "number"
                },
                "trailingThreeMonthReturns": {
                    "type": "number"
                },
                "trailingThreeMonthNavReturns": {
                    "type": "number"
                },
                "ipoExpectedDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "newListingDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "nameChangeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "prevName": {
                    "type": "string"
                },
                "averageAnalystRating": {
                    "type": "string"
                },
                "pageViewGrowthWeekly": {
                    "type": "number"
                },
                "openInterest": {
                    "type": "number"
                },
                "beta": {
                    "type": "number"
                },
                "companyLogoUrl": {
                    "type": "string"
                },
                "logoUrl": {
                    "type": "string"
                }
            },
            "required": [
                "esgPopulated",
                "exchange",
                "exchangeDataDelayedBy",
                "exchangeTimezoneName",
                "exchangeTimezoneShortName",
                "fullExchangeName",
                "gmtOffSetMilliseconds",
                "language",
                "market",
                "marketState",
                "quoteType",
                "region",
                "sourceInterval",
                "symbol",
                "tradeable",
                "triggerable"
            ]
        },
        "QuoteMutualfund": {
            "type": "object",
            "properties": {
                "language": {
                    "type": "string"
                },
                "region": {
                    "type": "string"
                },
                "quoteType": {
                    "type": "string",
                    "const": "MUTUALFUND"
                },
                "typeDisp": {
                    "type": "string"
                },
                "quoteSourceName": {
                    "type": "string"
                },
                "triggerable": {
                    "type": "boolean"
                },
                "currency": {
                    "type": "string"
                },
                "customPriceAlertConfidence": {
                    "type": "string"
                },
                "marketState": {
                    "type": "string",
                    "enum": [
                        "REGULAR",
                        "CLOSED",
                        "PRE",
                        "PREPRE",
                        "POST",
                        "POSTPOST"
                    ]
                },
                "tradeable": {
                    "type": "boolean"
                },
                "cryptoTradeable": {
                    "type": "boolean"
                },
                "corporateActions": {
                    "type": "array",
                    "items": {}
                },
                "exchange": {
                    "type": "string"
                },
                "shortName": {
                    "type": "string"
                },
                "longName": {
                    "type": "string"
                },
                "messageBoardId": {
                    "type": "string"
                },
                "exchangeTimezoneName": {
                    "type": "string"
                },
                "exchangeTimezoneShortName": {
                    "type": "string"
                },
                "gmtOffSetMilliseconds": {
                    "type": "number"
                },
                "market": {
                    "type": "string"
                },
                "esgPopulated": {
                    "type": "boolean"
                },
                "fiftyTwoWeekLowChange": {
                    "type": "number"
                },
                "fiftyTwoWeekLowChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "fiftyTwoWeekHighChange": {
                    "type": "number"
                },
                "fiftyTwoWeekHighChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekLow": {
                    "type": "number"
                },
                "fiftyTwoWeekHigh": {
                    "type": "number"
                },
                "fiftyTwoWeekChangePercent": {
                    "type": "number"
                },
                "dividendDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestamp": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "isEarningsDateEstimate": {
                    "type": "boolean"
                },
                "trailingAnnualDividendRate": {
                    "type": "number"
                },
                "trailingPE": {
                    "type": "number"
                },
                "trailingAnnualDividendYield": {
                    "type": "number"
                },
                "epsTrailingTwelveMonths": {
                    "type": "number"
                },
                "epsForward": {
                    "type": "number"
                },
                "epsCurrentYear": {
                    "type": "number"
                },
                "priceEpsCurrentYear": {
                    "type": "number"
                },
                "sharesOutstanding": {
                    "type": "number"
                },
                "bookValue": {
                    "type": "number"
                },
                "fiftyDayAverage": {
                    "type": "number"
                },
                "fiftyDayAverageChange": {
                    "type": "number"
                },
                "fiftyDayAverageChangePercent": {
                    "type": "number"
                },
                "twoHundredDayAverage": {
                    "type": "number"
                },
                "twoHundredDayAverageChange": {
                    "type": "number"
                },
                "twoHundredDayAverageChangePercent": {
                    "type": "number"
                },
                "marketCap": {
                    "type": "number"
                },
                "forwardPE": {
                    "type": "number"
                },
                "priceToBook": {
                    "type": "number"
                },
                "sourceInterval": {
                    "type": "number"
                },
                "exchangeDataDelayedBy": {
                    "type": "number"
                },
                "firstTradeDateMilliseconds": {
                    "$ref": "#/definitions/DateInMs"
                },
                "priceHint": {
                    "type": "number"
                },
                "postMarketChangePercent": {
                    "type": "number"
                },
                "postMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "postMarketPrice": {
                    "type": "number"
                },
                "postMarketChange": {
                    "type": "number"
                },
                "hasPrePostMarketData": {
                    "type": "boolean"
                },
                "extendedMarketChange": {
                    "type": "number"
                },
                "extendedMarketChangePercent": {
                    "type": "number"
                },
                "extendedMarketPrice": {
                    "type": "number"
                },
                "extendedMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketChange": {
                    "type": "number"
                },
                "regularMarketChangePercent": {
                    "type": "number"
                },
                "regularMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketPrice": {
                    "type": "number"
                },
                "regularMarketDayHigh": {
                    "type": "number"
                },
                "regularMarketDayRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "regularMarketDayLow": {
                    "type": "number"
                },
                "regularMarketVolume": {
                    "type": "number"
                },
                "dayHigh": {
                    "type": "number"
                },
                "dayLow": {
                    "type": "number"
                },
                "volume": {
                    "type": "number"
                },
                "regularMarketPreviousClose": {
                    "type": "number"
                },
                "preMarketChange": {
                    "type": "number"
                },
                "preMarketChangePercent": {
                    "type": "number"
                },
                "preMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "preMarketPrice": {
                    "type": "number"
                },
                "bid": {
                    "type": "number"
                },
                "ask": {
                    "type": "number"
                },
                "bidSize": {
                    "type": "number"
                },
                "askSize": {
                    "type": "number"
                },
                "fullExchangeName": {
                    "type": "string"
                },
                "financialCurrency": {
                    "type": "string"
                },
                "regularMarketOpen": {
                    "type": "number"
                },
                "averageDailyVolume3Month": {
                    "type": "number"
                },
                "averageDailyVolume10Day": {
                    "type": "number"
                },
                "displayName": {
                    "type": "string"
                },
                "symbol": {
                    "type": "string"
                },
                "underlyingSymbol": {
                    "type": "string"
                },
                "ytdReturn": {
                    "type": "number"
                },
                "trailingThreeMonthReturns": {
                    "type": "number"
                },
                "trailingThreeMonthNavReturns": {
                    "type": "number"
                },
                "ipoExpectedDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "newListingDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "nameChangeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "prevName": {
                    "type": "string"
                },
                "averageAnalystRating": {
                    "type": "string"
                },
                "pageViewGrowthWeekly": {
                    "type": "number"
                },
                "openInterest": {
                    "type": "number"
                },
                "beta": {
                    "type": "number"
                },
                "companyLogoUrl": {
                    "type": "string"
                },
                "logoUrl": {
                    "type": "string"
                },
                "dividendRate": {
                    "type": "number"
                },
                "dividendYield": {
                    "type": "number"
                }
            },
            "required": [
                "esgPopulated",
                "exchange",
                "exchangeDataDelayedBy",
                "exchangeTimezoneName",
                "exchangeTimezoneShortName",
                "fullExchangeName",
                "gmtOffSetMilliseconds",
                "language",
                "market",
                "marketState",
                "quoteType",
                "region",
                "sourceInterval",
                "symbol",
                "tradeable",
                "triggerable"
            ]
        },
        "QuoteOption": {
            "type": "object",
            "properties": {
                "language": {
                    "type": "string"
                },
                "region": {
                    "type": "string"
                },
                "quoteType": {
                    "type": "string",
                    "const": "OPTION"
                },
                "typeDisp": {
                    "type": "string"
                },
                "quoteSourceName": {
                    "type": "string"
                },
                "triggerable": {
                    "type": "boolean"
                },
                "currency": {
                    "type": "string"
                },
                "customPriceAlertConfidence": {
                    "type": "string"
                },
                "marketState": {
                    "type": "string",
                    "enum": [
                        "REGULAR",
                        "CLOSED",
                        "PRE",
                        "PREPRE",
                        "POST",
                        "POSTPOST"
                    ]
                },
                "tradeable": {
                    "type": "boolean"
                },
                "cryptoTradeable": {
                    "type": "boolean"
                },
                "corporateActions": {
                    "type": "array",
                    "items": {}
                },
                "exchange": {
                    "type": "string"
                },
                "shortName": {
                    "type": "string"
                },
                "longName": {
                    "type": "string"
                },
                "messageBoardId": {
                    "type": "string"
                },
                "exchangeTimezoneName": {
                    "type": "string"
                },
                "exchangeTimezoneShortName": {
                    "type": "string"
                },
                "gmtOffSetMilliseconds": {
                    "type": "number"
                },
                "market": {
                    "type": "string"
                },
                "esgPopulated": {
                    "type": "boolean"
                },
                "fiftyTwoWeekLowChange": {
                    "type": "number"
                },
                "fiftyTwoWeekLowChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "fiftyTwoWeekHighChange": {
                    "type": "number"
                },
                "fiftyTwoWeekHighChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekLow": {
                    "type": "number"
                },
                "fiftyTwoWeekHigh": {
                    "type": "number"
                },
                "fiftyTwoWeekChangePercent": {
                    "type": "number"
                },
                "dividendDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestamp": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "isEarningsDateEstimate": {
                    "type": "boolean"
                },
                "trailingAnnualDividendRate": {
                    "type": "number"
                },
                "trailingPE": {
                    "type": "number"
                },
                "trailingAnnualDividendYield": {
                    "type": "number"
                },
                "epsTrailingTwelveMonths": {
                    "type": "number"
                },
                "epsForward": {
                    "type": "number"
                },
                "epsCurrentYear": {
                    "type": "number"
                },
                "priceEpsCurrentYear": {
                    "type": "number"
                },
                "sharesOutstanding": {
                    "type": "number"
                },
                "bookValue": {
                    "type": "number"
                },
                "fiftyDayAverage": {
                    "type": "number"
                },
                "fiftyDayAverageChange": {
                    "type": "number"
                },
                "fiftyDayAverageChangePercent": {
                    "type": "number"
                },
                "twoHundredDayAverage": {
                    "type": "number"
                },
                "twoHundredDayAverageChange": {
                    "type": "number"
                },
                "twoHundredDayAverageChangePercent": {
                    "type": "number"
                },
                "marketCap": {
                    "type": "number"
                },
                "forwardPE": {
                    "type": "number"
                },
                "priceToBook": {
                    "type": "number"
                },
                "sourceInterval": {
                    "type": "number"
                },
                "exchangeDataDelayedBy": {
                    "type": "number"
                },
                "firstTradeDateMilliseconds": {
                    "$ref": "#/definitions/DateInMs"
                },
                "priceHint": {
                    "type": "number"
                },
                "postMarketChangePercent": {
                    "type": "number"
                },
                "postMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "postMarketPrice": {
                    "type": "number"
                },
                "postMarketChange": {
                    "type": "number"
                },
                "hasPrePostMarketData": {
                    "type": "boolean"
                },
                "extendedMarketChange": {
                    "type": "number"
                },
                "extendedMarketChangePercent": {
                    "type": "number"
                },
                "extendedMarketPrice": {
                    "type": "number"
                },
                "extendedMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketChange": {
                    "type": "number"
                },
                "regularMarketChangePercent": {
                    "type": "number"
                },
                "regularMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketPrice": {
                    "type": "number"
                },
                "regularMarketDayHigh": {
                    "type": "number"
                },
                "regularMarketDayRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "regularMarketDayLow": {
                    "type": "number"
                },
                "regularMarketVolume": {
                    "type": "number"
                },
                "dayHigh": {
                    "type": "number"
                },
                "dayLow": {
                    "type": "number"
                },
                "volume": {
                    "type": "number"
                },
                "regularMarketPreviousClose": {
                    "type": "number"
                },
                "preMarketChange": {
                    "type": "number"
                },
                "preMarketChangePercent": {
                    "type": "number"
                },
                "preMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "preMarketPrice": {
                    "type": "number"
                },
                "bid": {
                    "type": "number"
                },
                "ask": {
                    "type": "number"
                },
                "bidSize": {
                    "type": "number"
                },
                "askSize": {
                    "type": "number"
                },
                "fullExchangeName": {
                    "type": "string"
                },
                "financialCurrency": {
                    "type": "string"
                },
                "regularMarketOpen": {
                    "type": "number"
                },
                "averageDailyVolume3Month": {
                    "type": "number"
                },
                "averageDailyVolume10Day": {
                    "type": "number"
                },
                "displayName": {
                    "type": "string"
                },
                "symbol": {
                    "type": "string"
                },
                "underlyingSymbol": {
                    "type": "string"
                },
                "ytdReturn": {
                    "type": "number"
                },
                "trailingThreeMonthReturns": {
                    "type": "number"
                },
                "trailingThreeMonthNavReturns": {
                    "type": "number"
                },
                "ipoExpectedDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "newListingDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "nameChangeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "prevName": {
                    "type": "string"
                },
                "averageAnalystRating": {
                    "type": "string"
                },
                "pageViewGrowthWeekly": {
                    "type": "number"
                },
                "openInterest": {
                    "type": "number"
                },
                "beta": {
                    "type": "number"
                },
                "companyLogoUrl": {
                    "type": "string"
                },
                "logoUrl": {
                    "type": "string"
                },
                "strike": {
                    "type": "number"
                },
                "expireDate": {
                    "type": "number"
                },
                "expireIsoDate": {
                    "type": "string",
                    "format": "date-time"
                }
            },
            "required": [
                "esgPopulated",
                "exchange",
                "exchangeDataDelayedBy",
                "exchangeTimezoneName",
                "exchangeTimezoneShortName",
                "expireDate",
                "expireIsoDate",
                "fullExchangeName",
                "gmtOffSetMilliseconds",
                "language",
                "market",
                "marketState",
                "openInterest",
                "quoteType",
                "region",
                "sourceInterval",
                "strike",
                "symbol",
                "tradeable",
                "triggerable",
                "underlyingSymbol"
            ]
        },
        "QuoteMoneyMarket": {
            "type": "object",
            "properties": {
                "language": {
                    "type": "string"
                },
                "region": {
                    "type": "string"
                },
                "quoteType": {
                    "type": "string",
                    "const": "MONEYMARKET"
                },
                "typeDisp": {
                    "type": "string",
                    "const": "MoneyMarket"
                },
                "quoteSourceName": {
                    "type": "string"
                },
                "triggerable": {
                    "type": "boolean"
                },
                "currency": {
                    "type": "string"
                },
                "customPriceAlertConfidence": {
                    "type": "string"
                },
                "marketState": {
                    "type": "string",
                    "enum": [
                        "REGULAR",
                        "CLOSED",
                        "PRE",
                        "PREPRE",
                        "POST",
                        "POSTPOST"
                    ]
                },
                "tradeable": {
                    "type": "boolean"
                },
                "cryptoTradeable": {
                    "type": "boolean"
                },
                "corporateActions": {
                    "type": "array",
                    "items": {}
                },
                "exchange": {
                    "type": "string"
                },
                "shortName": {
                    "type": "string"
                },
                "longName": {
                    "type": "string"
                },
                "messageBoardId": {
                    "type": "string"
                },
                "exchangeTimezoneName": {
                    "type": "string"
                },
                "exchangeTimezoneShortName": {
                    "type": "string"
                },
                "gmtOffSetMilliseconds": {
                    "type": "number"
                },
                "market": {
                    "type": "string"
                },
                "esgPopulated": {
                    "type": "boolean"
                },
                "fiftyTwoWeekLowChange": {
                    "type": "number"
                },
                "fiftyTwoWeekLowChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "fiftyTwoWeekHighChange": {
                    "type": "number"
                },
                "fiftyTwoWeekHighChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekLow": {
                    "type": "number"
                },
                "fiftyTwoWeekHigh": {
                    "type": "number"
                },
                "fiftyTwoWeekChangePercent": {
                    "type": "number"
                },
                "dividendDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestamp": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "isEarningsDateEstimate": {
                    "type": "boolean"
                },
                "trailingAnnualDividendRate": {
                    "type": "number"
                },
                "trailingPE": {
                    "type": "number"
                },
                "trailingAnnualDividendYield": {
                    "type": "number"
                },
                "epsTrailingTwelveMonths": {
                    "type": "number"
                },
                "epsForward": {
                    "type": "number"
                },
                "epsCurrentYear": {
                    "type": "number"
                },
                "priceEpsCurrentYear": {
                    "type": "number"
                },
                "sharesOutstanding": {
                    "type": "number"
                },
                "bookValue": {
                    "type": "number"
                },
                "fiftyDayAverage": {
                    "type": "number"
                },
                "fiftyDayAverageChange": {
                    "type": "number"
                },
                "fiftyDayAverageChangePercent": {
                    "type": "number"
                },
                "twoHundredDayAverage": {
                    "type": "number"
                },
                "twoHundredDayAverageChange": {
                    "type": "number"
                },
                "twoHundredDayAverageChangePercent": {
                    "type": "number"
                },
                "marketCap": {
                    "type": "number"
                },
                "forwardPE": {
                    "type": "number"
                },
                "priceToBook": {
                    "type": "number"
                },
                "sourceInterval": {
                    "type": "number"
                },
                "exchangeDataDelayedBy": {
                    "type": "number"
                },
                "firstTradeDateMilliseconds": {
                    "$ref": "#/definitions/DateInMs"
                },
                "priceHint": {
                    "type": "number"
                },
                "postMarketChangePercent": {
                    "type": "number"
                },
                "postMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "postMarketPrice": {
                    "type": "number"
                },
                "postMarketChange": {
                    "type": "number"
                },
                "hasPrePostMarketData": {
                    "type": "boolean"
                },
                "extendedMarketChange": {
                    "type": "number"
                },
                "extendedMarketChangePercent": {
                    "type": "number"
                },
                "extendedMarketPrice": {
                    "type": "number"
                },
                "extendedMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketChange": {
                    "type": "number"
                },
                "regularMarketChangePercent": {
                    "type": "number"
                },
                "regularMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketPrice": {
                    "type": "number"
                },
                "regularMarketDayHigh": {
                    "type": "number"
                },
                "regularMarketDayRange": {
                    "$ref": "#/definitions/TwoNumberRange"
                },
                "regularMarketDayLow": {
                    "type": "number"
                },
                "regularMarketVolume": {
                    "type": "number"
                },
                "dayHigh": {
                    "type": "number"
                },
                "dayLow": {
                    "type": "number"
                },
                "volume": {
                    "type": "number"
                },
                "regularMarketPreviousClose": {
                    "type": "number"
                },
                "preMarketChange": {
                    "type": "number"
                },
                "preMarketChangePercent": {
                    "type": "number"
                },
                "preMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "preMarketPrice": {
                    "type": "number"
                },
                "bid": {
                    "type": "number"
                },
                "ask": {
                    "type": "number"
                },
                "bidSize": {
                    "type": "number"
                },
                "askSize": {
                    "type": "number"
                },
                "fullExchangeName": {
                    "type": "string"
                },
                "financialCurrency": {
                    "type": "string"
                },
                "regularMarketOpen": {
                    "type": "number"
                },
                "averageDailyVolume3Month": {
                    "type": "number"
                },
                "averageDailyVolume10Day": {
                    "type": "number"
                },
                "displayName": {
                    "type": "string"
                },
                "symbol": {
                    "type": "string"
                },
                "underlyingSymbol": {
                    "type": "string"
                },
                "ytdReturn": {
                    "type": "number"
                },
                "trailingThreeMonthReturns": {
                    "type": "number"
                },
                "trailingThreeMonthNavReturns": {
                    "type": "number"
                },
                "ipoExpectedDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "newListingDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "nameChangeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "prevName": {
                    "type": "string"
                },
                "averageAnalystRating": {
                    "type": "string"
                },
                "pageViewGrowthWeekly": {
                    "type": "number"
                },
                "openInterest": {
                    "type": "number"
                },
                "beta": {
                    "type": "number"
                },
                "companyLogoUrl": {
                    "type": "string"
                },
                "logoUrl": {
                    "type": "string"
                },
                "netAssets": {
                    "type": "number"
                }
            },
            "required": [
                "esgPopulated",
                "exchange",
                "exchangeDataDelayedBy",
                "exchangeTimezoneName",
                "exchangeTimezoneShortName",
                "fullExchangeName",
                "gmtOffSetMilliseconds",
                "language",
                "market",
                "marketState",
                "quoteType",
                "region",
                "sourceInterval",
                "symbol",
                "tradeable",
                "triggerable",
                "typeDisp"
            ]
        },
        "Option": {
            "type": "object",
            "properties": {
                "expirationDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "hasMiniOptions": {
                    "type": "boolean"
                },
                "calls": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/CallOrPut"
                    }
                },
                "puts": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/CallOrPut"
                    }
                }
            },
            "required": [
                "expirationDate",
                "hasMiniOptions",
                "calls",
                "puts"
            ],
            "additionalProperties": {}
        },
        "CallOrPut": {
            "type": "object",
            "properties": {
                "contractSymbol": {
                    "type": "string"
                },
                "strike": {
                    "type": "number"
                },
                "currency": {
                    "type": "string"
                },
                "lastPrice": {
                    "type": "number"
                },
                "change": {
                    "type": "number"
                },
                "percentChange": {
                    "type": "number"
                },
                "volume": {
                    "type": "number"
                },
                "openInterest": {
                    "type": "number"
                },
                "bid": {
                    "type": "number"
                },
                "ask": {
                    "type": "number"
                },
                "contractSize": {
                    "type": "string",
                    "const": "REGULAR"
                },
                "expiration": {
                    "type": "string",
                    "format": "date-time"
                },
                "lastTradeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "impliedVolatility": {
                    "type": "number"
                },
                "inTheMoney": {
                    "type": "boolean"
                }
            },
            "required": [
                "contractSymbol",
                "strike",
                "lastPrice",
                "change",
                "contractSize",
                "expiration",
                "lastTradeDate",
                "impliedVolatility",
                "inTheMoney"
            ],
            "additionalProperties": {}
        },
        "OptionsOptions": {
            "type": "object",
            "properties": {
                "formatted": {
                    "type": "boolean"
                },
                "lang": {
                    "type": "string"
                },
                "region": {
                    "type": "string"
                },
                "date": {
                    "anyOf": [
                        {
                            "type": "string",
                            "format": "date-time"
                        },
                        {
                            "type": "number"
                        },
                        {
                            "type": "string"
                        }
                    ]
                }
            },
            "additionalProperties": false
        },
        "options": {}
    }
};
