"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = {
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$comment": "DO NOT EDIT THIS FILE.  It is generated automatically from typescript interfaces in the project.  To update, run `deno task schema` (with optional `--watch`).  In VSCode, this is run automatically for you on folder open.",
    "definitions": {
        "InsightsResult": {
            "type": "object",
            "properties": {
                "symbol": {
                    "type": "string"
                },
                "instrumentInfo": {
                    "$ref": "#/definitions/InsightsInstrumentInfo"
                },
                "companySnapshot": {
                    "$ref": "#/definitions/InsightsCompanySnapshot"
                },
                "recommendation": {
                    "type": "object",
                    "properties": {
                        "targetPrice": {
                            "type": "number"
                        },
                        "provider": {
                            "type": "string"
                        },
                        "rating": {
                            "type": "string",
                            "enum": [
                                "BUY",
                                "SELL",
                                "HOLD"
                            ]
                        }
                    },
                    "required": [
                        "provider",
                        "rating"
                    ],
                    "additionalProperties": false
                },
                "events": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/InsightsEvent"
                    }
                },
                "reports": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/InsightsReport"
                    }
                },
                "sigDevs": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/InsightsSigDev"
                    }
                },
                "upsell": {
                    "$ref": "#/definitions/InsightsUpsell"
                },
                "upsellSearchDD": {
                    "type": "object",
                    "properties": {
                        "researchReports": {
                            "$ref": "#/definitions/InsightsResearchReport"
                        }
                    },
                    "required": [
                        "researchReports"
                    ],
                    "additionalProperties": false
                },
                "secReports": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/InsightsSecReport"
                    }
                }
            },
            "required": [
                "symbol",
                "sigDevs"
            ],
            "additionalProperties": {}
        },
        "InsightsInstrumentInfo": {
            "type": "object",
            "properties": {
                "keyTechnicals": {
                    "type": "object",
                    "properties": {
                        "provider": {
                            "type": "string"
                        },
                        "support": {
                            "type": "number"
                        },
                        "resistance": {
                            "type": "number"
                        },
                        "stopLoss": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "provider"
                    ],
                    "additionalProperties": {}
                },
                "technicalEvents": {
                    "type": "object",
                    "properties": {
                        "provider": {
                            "type": "string"
                        },
                        "sector": {
                            "type": "string"
                        },
                        "shortTermOutlook": {
                            "$ref": "#/definitions/InsightsOutlook"
                        },
                        "intermediateTermOutlook": {
                            "$ref": "#/definitions/InsightsOutlook"
                        },
                        "longTermOutlook": {
                            "$ref": "#/definitions/InsightsOutlook"
                        }
                    },
                    "required": [
                        "provider",
                        "shortTermOutlook",
                        "intermediateTermOutlook",
                        "longTermOutlook"
                    ],
                    "additionalProperties": {}
                },
                "valuation": {
                    "type": "object",
                    "properties": {
                        "color": {
                            "type": "number"
                        },
                        "description": {
                            "type": "string"
                        },
                        "discount": {
                            "type": "string"
                        },
                        "provider": {
                            "type": "string"
                        },
                        "relativeValue": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "provider"
                    ],
                    "additionalProperties": {}
                }
            },
            "required": [
                "keyTechnicals",
                "technicalEvents",
                "valuation"
            ],
            "additionalProperties": {}
        },
        "InsightsOutlook": {
            "type": "object",
            "properties": {
                "stateDescription": {
                    "type": "string"
                },
                "direction": {
                    "$ref": "#/definitions/InsightsDirection"
                },
                "score": {
                    "type": "number"
                },
                "scoreDescription": {
                    "type": "string"
                },
                "sectorDirection": {
                    "$ref": "#/definitions/InsightsDirection"
                },
                "sectorScore": {
                    "type": "number"
                },
                "sectorScoreDescription": {
                    "type": "string"
                },
                "indexDirection": {
                    "$ref": "#/definitions/InsightsDirection"
                },
                "indexScore": {
                    "type": "number"
                },
                "indexScoreDescription": {
                    "type": "string"
                }
            },
            "required": [
                "stateDescription",
                "direction",
                "score",
                "scoreDescription",
                "indexDirection",
                "indexScore",
                "indexScoreDescription"
            ],
            "additionalProperties": {}
        },
        "InsightsDirection": {
            "type": "string",
            "enum": [
                "Bearish",
                "Bullish",
                "Neutral"
            ]
        },
        "InsightsCompanySnapshot": {
            "type": "object",
            "properties": {
                "sectorInfo": {
                    "type": "string"
                },
                "company": {
                    "type": "object",
                    "properties": {
                        "innovativeness": {
                            "type": "number"
                        },
                        "hiring": {
                            "type": "number"
                        },
                        "sustainability": {
                            "type": "number"
                        },
                        "insiderSentiments": {
                            "type": "number"
                        },
                        "earningsReports": {
                            "type": "number"
                        },
                        "dividends": {
                            "type": "number"
                        }
                    },
                    "additionalProperties": {}
                },
                "sector": {
                    "type": "object",
                    "properties": {
                        "innovativeness": {
                            "type": "number"
                        },
                        "hiring": {
                            "type": "number"
                        },
                        "sustainability": {
                            "type": "number"
                        },
                        "insiderSentiments": {
                            "type": "number"
                        },
                        "earningsReports": {
                            "type": "number"
                        },
                        "dividends": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "innovativeness",
                        "hiring",
                        "insiderSentiments",
                        "dividends"
                    ],
                    "additionalProperties": {}
                }
            },
            "required": [
                "company",
                "sector"
            ],
            "additionalProperties": {}
        },
        "InsightsEvent": {
            "type": "object",
            "properties": {
                "eventType": {
                    "type": "string"
                },
                "pricePeriod": {
                    "type": "string"
                },
                "tradingHorizon": {
                    "type": "string"
                },
                "tradeType": {
                    "type": "string"
                },
                "imageUrl": {
                    "type": "string"
                },
                "startDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "endDate": {
                    "type": "string",
                    "format": "date-time"
                }
            },
            "required": [
                "eventType",
                "pricePeriod",
                "tradingHorizon",
                "tradeType",
                "imageUrl",
                "startDate",
                "endDate"
            ],
            "additionalProperties": {}
        },
        "InsightsReport": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                },
                "headHtml": {
                    "type": "string"
                },
                "provider": {
                    "type": "string"
                },
                "reportDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "reportTitle": {
                    "type": "string"
                },
                "reportType": {
                    "type": "string"
                },
                "targetPrice": {
                    "type": "number"
                },
                "targetPriceStatus": {
                    "type": "string",
                    "enum": [
                        "Increased",
                        "Maintained",
                        "Decreased",
                        "-"
                    ]
                },
                "investmentRating": {
                    "type": "string",
                    "enum": [
                        "Bullish",
                        "Neutral",
                        "Bearish"
                    ]
                },
                "tickers": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            },
            "required": [
                "id",
                "headHtml",
                "provider",
                "reportDate",
                "reportTitle",
                "reportType"
            ],
            "additionalProperties": {}
        },
        "InsightsSigDev": {
            "type": "object",
            "properties": {
                "headline": {
                    "type": "string"
                },
                "date": {
                    "type": "string",
                    "format": "date-time"
                }
            },
            "required": [
                "headline",
                "date"
            ],
            "additionalProperties": {}
        },
        "InsightsUpsell": {
            "type": "object",
            "properties": {
                "msBullishSummary": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "msBearishSummary": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "msBullishBearishSummariesPublishDate": {
                    "$ref": "#/definitions/DateInMs"
                },
                "companyName": {
                    "type": "string"
                },
                "upsellReportType": {
                    "type": "string"
                }
            },
            "additionalProperties": {}
        },
        "DateInMs": {
            "type": "string",
            "format": "date-time"
        },
        "InsightsResearchReport": {
            "type": "object",
            "properties": {
                "reportId": {
                    "type": "string"
                },
                "provider": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                },
                "reportDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "summary": {
                    "type": "string"
                },
                "investmentRating": {
                    "type": "string",
                    "enum": [
                        "Bullish",
                        "Neutral",
                        "Bearish"
                    ]
                }
            },
            "required": [
                "reportId",
                "provider",
                "title",
                "reportDate",
                "summary"
            ],
            "additionalProperties": false
        },
        "InsightsSecReport": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "filingDate": {
                    "$ref": "#/definitions/DateInMs"
                },
                "snapshotUrl": {
                    "type": "string"
                },
                "formType": {
                    "type": "string"
                }
            },
            "required": [
                "id",
                "type",
                "title",
                "description",
                "filingDate",
                "snapshotUrl",
                "formType"
            ],
            "additionalProperties": false
        },
        "InsightsOptions": {
            "type": "object",
            "properties": {
                "lang": {
                    "type": "string"
                },
                "region": {
                    "type": "string"
                },
                "reportsCount": {
                    "type": "number"
                }
            },
            "additionalProperties": false
        },
        "insights": {}
    }
};
