"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = {
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$comment": "DO NOT EDIT THIS FILE.  It is generated automatically from typescript interfaces in the project.  To update, run `deno task schema` (with optional `--watch`).  In VSCode, this is run automatically for you on folder open.",
    "definitions": {
        "ChartResultObject": {
            "type": "object",
            "properties": {
                "meta": {
                    "$ref": "#/definitions/ChartMeta"
                },
                "timestamp": {
                    "type": "array",
                    "items": {
                        "type": "number"
                    }
                },
                "events": {
                    "$ref": "#/definitions/ChartEventsObject"
                },
                "indicators": {
                    "$ref": "#/definitions/ChartIndicatorsObject"
                }
            },
            "required": [
                "meta",
                "indicators"
            ],
            "additionalProperties": {}
        },
        "ChartMeta": {
            "type": "object",
            "properties": {
                "currency": {
                    "type": "string"
                },
                "symbol": {
                    "type": "string"
                },
                "exchangeName": {
                    "type": "string"
                },
                "instrumentType": {
                    "type": "string"
                },
                "fiftyTwoWeekHigh": {
                    "type": "number"
                },
                "fiftyTwoWeekLow": {
                    "type": "number"
                },
                "firstTradeDate": {
                    "anyOf": [
                        {
                            "type": "string",
                            "format": "date-time"
                        },
                        {
                            "type": "null"
                        }
                    ]
                },
                "fullExchangeName": {
                    "type": "string"
                },
                "regularMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "gmtoffset": {
                    "type": "number"
                },
                "hasPrePostMarketData": {
                    "type": "boolean"
                },
                "timezone": {
                    "type": "string"
                },
                "exchangeTimezoneName": {
                    "type": "string"
                },
                "regularMarketPrice": {
                    "type": "number"
                },
                "chartPreviousClose": {
                    "type": "number"
                },
                "previousClose": {
                    "type": "number"
                },
                "regularMarketDayHigh": {
                    "type": "number"
                },
                "regularMarketDayLow": {
                    "type": "number"
                },
                "regularMarketVolume": {
                    "type": "number"
                },
                "longName": {
                    "type": "string"
                },
                "shortName": {
                    "type": "string"
                },
                "scale": {
                    "type": "number"
                },
                "priceHint": {
                    "type": "number"
                },
                "currentTradingPeriod": {
                    "type": "object",
                    "properties": {
                        "pre": {
                            "$ref": "#/definitions/ChartMetaTradingPeriod"
                        },
                        "regular": {
                            "$ref": "#/definitions/ChartMetaTradingPeriod"
                        },
                        "post": {
                            "$ref": "#/definitions/ChartMetaTradingPeriod"
                        }
                    },
                    "required": [
                        "pre",
                        "regular",
                        "post"
                    ],
                    "additionalProperties": {}
                },
                "tradingPeriods": {
                    "anyOf": [
                        {
                            "$ref": "#/definitions/ChartMetaTradingPeriods"
                        },
                        {
                            "type": "array",
                            "items": {
                                "type": "array",
                                "items": {
                                    "$ref": "#/definitions/ChartMetaTradingPeriod"
                                }
                            }
                        }
                    ]
                },
                "dataGranularity": {
                    "type": "string"
                },
                "range": {
                    "type": "string"
                },
                "validRanges": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            },
            "required": [
                "currency",
                "symbol",
                "exchangeName",
                "instrumentType",
                "firstTradeDate",
                "regularMarketTime",
                "gmtoffset",
                "timezone",
                "exchangeTimezoneName",
                "regularMarketPrice",
                "priceHint",
                "currentTradingPeriod",
                "dataGranularity",
                "range",
                "validRanges"
            ],
            "additionalProperties": {}
        },
        "ChartMetaTradingPeriod": {
            "type": "object",
            "properties": {
                "timezone": {
                    "type": "string"
                },
                "start": {
                    "type": "string",
                    "format": "date-time"
                },
                "end": {
                    "type": "string",
                    "format": "date-time"
                },
                "gmtoffset": {
                    "type": "number"
                }
            },
            "required": [
                "timezone",
                "start",
                "end",
                "gmtoffset"
            ],
            "additionalProperties": {}
        },
        "ChartMetaTradingPeriods": {
            "type": "object",
            "properties": {
                "pre": {
                    "type": "array",
                    "items": {
                        "type": "array",
                        "items": {
                            "$ref": "#/definitions/ChartMetaTradingPeriod"
                        }
                    }
                },
                "post": {
                    "type": "array",
                    "items": {
                        "type": "array",
                        "items": {
                            "$ref": "#/definitions/ChartMetaTradingPeriod"
                        }
                    }
                },
                "regular": {
                    "type": "array",
                    "items": {
                        "type": "array",
                        "items": {
                            "$ref": "#/definitions/ChartMetaTradingPeriod"
                        }
                    }
                }
            },
            "additionalProperties": {}
        },
        "ChartEventsObject": {
            "type": "object",
            "properties": {
                "dividends": {
                    "$ref": "#/definitions/ChartEventDividends"
                },
                "splits": {
                    "$ref": "#/definitions/ChartEventSplits"
                }
            },
            "additionalProperties": {}
        },
        "ChartEventDividends": {
            "type": "object",
            "additionalProperties": {
                "$ref": "#/definitions/ChartEventDividend"
            }
        },
        "ChartEventDividend": {
            "type": "object",
            "properties": {
                "amount": {
                    "type": "number"
                },
                "date": {
                    "type": "string",
                    "format": "date-time"
                }
            },
            "required": [
                "amount",
                "date"
            ],
            "additionalProperties": {}
        },
        "ChartEventSplits": {
            "type": "object",
            "additionalProperties": {
                "$ref": "#/definitions/ChartEventSplit"
            }
        },
        "ChartEventSplit": {
            "type": "object",
            "properties": {
                "date": {
                    "type": "string",
                    "format": "date-time"
                },
                "numerator": {
                    "type": "number"
                },
                "denominator": {
                    "type": "number"
                },
                "splitRatio": {
                    "type": "string"
                }
            },
            "required": [
                "date",
                "numerator",
                "denominator",
                "splitRatio"
            ],
            "additionalProperties": {}
        },
        "ChartIndicatorsObject": {
            "type": "object",
            "properties": {
                "quote": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/ChartIndicatorQuote"
                    }
                },
                "adjclose": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/ChartIndicatorAdjclose"
                    }
                }
            },
            "required": [
                "quote"
            ],
            "additionalProperties": {}
        },
        "ChartIndicatorQuote": {
            "type": "object",
            "properties": {
                "high": {
                    "type": "array",
                    "items": {
                        "type": [
                            "number",
                            "null"
                        ]
                    }
                },
                "low": {
                    "type": "array",
                    "items": {
                        "type": [
                            "number",
                            "null"
                        ]
                    }
                },
                "open": {
                    "type": "array",
                    "items": {
                        "type": [
                            "number",
                            "null"
                        ]
                    }
                },
                "close": {
                    "type": "array",
                    "items": {
                        "type": [
                            "number",
                            "null"
                        ]
                    }
                },
                "volume": {
                    "type": "array",
                    "items": {
                        "type": [
                            "number",
                            "null"
                        ]
                    }
                }
            },
            "required": [
                "high",
                "low",
                "open",
                "close",
                "volume"
            ],
            "additionalProperties": {}
        },
        "ChartIndicatorAdjclose": {
            "type": "object",
            "properties": {
                "adjclose": {
                    "type": "array",
                    "items": {
                        "type": [
                            "number",
                            "null"
                        ]
                    }
                }
            },
            "additionalProperties": {}
        },
        "ChartResultArray": {
            "type": "object",
            "properties": {
                "meta": {
                    "$ref": "#/definitions/ChartMeta"
                },
                "events": {
                    "$ref": "#/definitions/ChartEventsArray"
                },
                "quotes": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/ChartResultArrayQuote"
                    }
                }
            },
            "required": [
                "meta",
                "quotes"
            ],
            "additionalProperties": false
        },
        "ChartEventsArray": {
            "type": "object",
            "properties": {
                "dividends": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/ChartEventDividend"
                    }
                },
                "splits": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/ChartEventSplit"
                    }
                }
            },
            "additionalProperties": {}
        },
        "ChartResultArrayQuote": {
            "type": "object",
            "properties": {
                "date": {
                    "type": "string",
                    "format": "date-time"
                },
                "high": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "low": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "open": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "close": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "volume": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "adjclose": {
                    "type": [
                        "number",
                        "null"
                    ]
                }
            },
            "required": [
                "date",
                "high",
                "low",
                "open",
                "close",
                "volume"
            ],
            "additionalProperties": {}
        },
        "ChartOptions": {
            "type": "object",
            "properties": {
                "period1": {
                    "anyOf": [
                        {
                            "type": "string",
                            "format": "date-time"
                        },
                        {
                            "type": "string"
                        },
                        {
                            "type": "number"
                        }
                    ]
                },
                "period2": {
                    "anyOf": [
                        {
                            "type": "string",
                            "format": "date-time"
                        },
                        {
                            "type": "string"
                        },
                        {
                            "type": "number"
                        }
                    ]
                },
                "useYfid": {
                    "type": "boolean"
                },
                "interval": {
                    "type": "string",
                    "enum": [
                        "1m",
                        "2m",
                        "5m",
                        "15m",
                        "30m",
                        "60m",
                        "90m",
                        "1h",
                        "1d",
                        "5d",
                        "1wk",
                        "1mo",
                        "3mo"
                    ]
                },
                "includePrePost": {
                    "type": "boolean"
                },
                "events": {
                    "type": "string"
                },
                "lang": {
                    "type": "string"
                },
                "return": {
                    "type": "string",
                    "enum": [
                        "array",
                        "object"
                    ]
                }
            },
            "required": [
                "period1"
            ],
            "additionalProperties": false
        },
        "ChartOptionsWithReturnArray": {
            "type": "object",
            "properties": {
                "period1": {
                    "anyOf": [
                        {
                            "type": "string",
                            "format": "date-time"
                        },
                        {
                            "type": "string"
                        },
                        {
                            "type": "number"
                        }
                    ]
                },
                "period2": {
                    "anyOf": [
                        {
                            "type": "string",
                            "format": "date-time"
                        },
                        {
                            "type": "string"
                        },
                        {
                            "type": "number"
                        }
                    ]
                },
                "useYfid": {
                    "type": "boolean"
                },
                "interval": {
                    "type": "string",
                    "enum": [
                        "1m",
                        "2m",
                        "5m",
                        "15m",
                        "30m",
                        "60m",
                        "90m",
                        "1h",
                        "1d",
                        "5d",
                        "1wk",
                        "1mo",
                        "3mo"
                    ]
                },
                "includePrePost": {
                    "type": "boolean"
                },
                "events": {
                    "type": "string"
                },
                "lang": {
                    "type": "string"
                },
                "return": {
                    "type": "string",
                    "const": "array"
                }
            },
            "additionalProperties": false,
            "required": [
                "period1"
            ]
        },
        "ChartOptionsWithReturnObject": {
            "type": "object",
            "properties": {
                "period1": {
                    "anyOf": [
                        {
                            "type": "string",
                            "format": "date-time"
                        },
                        {
                            "type": "string"
                        },
                        {
                            "type": "number"
                        }
                    ]
                },
                "period2": {
                    "anyOf": [
                        {
                            "type": "string",
                            "format": "date-time"
                        },
                        {
                            "type": "string"
                        },
                        {
                            "type": "number"
                        }
                    ]
                },
                "useYfid": {
                    "type": "boolean"
                },
                "interval": {
                    "type": "string",
                    "enum": [
                        "1m",
                        "2m",
                        "5m",
                        "15m",
                        "30m",
                        "60m",
                        "90m",
                        "1h",
                        "1d",
                        "5d",
                        "1wk",
                        "1mo",
                        "3mo"
                    ]
                },
                "includePrePost": {
                    "type": "boolean"
                },
                "events": {
                    "type": "string"
                },
                "lang": {
                    "type": "string"
                },
                "return": {
                    "type": "string",
                    "const": "object"
                }
            },
            "required": [
                "period1",
                "return"
            ],
            "additionalProperties": false
        },
        "chart": {}
    }
};
