import type { YahooFinanceOptions } from "./options/options.js";
import type { QueueOptions } from "./queue.js";
import type Notices from "./notices.js";
type Fetch = typeof fetch;
interface YahooFinanceFetchThisEnv {
    [key: string]: any;
    fetch: Fetch | null;
    fetchDevel?: () => (input: Parameters<typeof fetch>[0], init?: Parameters<typeof fetch>[1]) => ReturnType<typeof fetch>;
}
interface YahooFinanceFetchThis {
    [key: string]: any;
    _env: YahooFinanceFetchThisEnv;
    _opts: YahooFinanceOptions;
    _notices: Notices;
}
export interface YahooFinanceFetchModuleOptions {
    /** Controls for http cache
     *  {
     *    id: string;           // cache key
     *    t: Deno.TestContext;  // test context
     *    onFinish: (cb: (error?: unknown) => void) => void;
     *  }
     *  See `tests/common.ts` for how these are used for conditional caching.
     */
    devel?: {
        id: string;
        t: unknown;
        onFinish: (cb: (error?: unknown) => void) => void;
    };
    /** An alternative fetch function to use just for this call */
    fetch?: Fetch;
    /** Any options to pass to fetch() just for this request. */
    fetchOptions?: RequestInit;
    /**
     * Permanently update the instance's queue options.  Affects this and all
     * future requests.
     */
    queue?: QueueOptions;
}
declare function substituteVariables(this: YahooFinanceFetchThis, urlBase: string): string;
declare function yahooFinanceFetch(this: YahooFinanceFetchThis, urlBase: string, params?: Record<string, string>, moduleOpts?: YahooFinanceFetchModuleOptions, func?: string, needsCrumb?: boolean): Promise<unknown>;
export { substituteVariables };
export default yahooFinanceFetch;
//# sourceMappingURL=yahooFinanceFetch.d.ts.map