import type { JSONSchema } from "./validate/index.js";
import type { Logger } from "./options/logger.js";
export declare function resolvePath(obj: Record<string, unknown>, instancePath: string): Record<string, unknown>;
export interface ValidationOptions {
    logErrors?: boolean;
    logOptionsErrors?: boolean;
    allowAdditionalProps?: boolean;
}
export interface ValidateParams {
    source: string;
    type: "options" | "result";
    object: object;
    definitions: JSONSchema["definitions"];
    schemaOrSchemaKey: JSONSchema | string;
    options: ValidationOptions;
    logger: Logger;
    logObj: (obj: unknown, opts?: {
        depth?: number;
    }) => void;
    versionCheck: boolean;
}
declare function disallowAdditionalProps(definitions: Record<string, unknown>, show?: boolean): void;
declare function validate({ source, type, object, schemaOrSchemaKey, definitions, options, logger, logObj, versionCheck, }: ValidateParams): void;
export { disallowAdditionalProps };
export default validate;
//# sourceMappingURL=validateAndCoerceTypes.d.ts.map