"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.object = void 0;
const index_js_1 = __importStar(require("../index.js"));
const object = function object(input, schema, ctx, errors, instancePath, dataCtx, schemaPath, refs) {
    // TwoNumberRange
    if (refs && refs[refs.length - 1] === "TwoNumberRange") {
        /*
      const props = schema.properties;
      if (
        props &&
        //
        props.low && typeof props.low === "object" &&
        props.low.type === "number" &&
        props.high && typeof props.high === "object" &&
        props.high.type === "number" &&
        //
        schema.required &&
        schema.required.length === 2 && schema.required.includes("low") &&
        schema.required.includes("high") &&
        //
        schema.additionalProperties === false
      ) {
      */
        if (typeof input === "object" &&
            input !== null &&
            "low" in input &&
            typeof input.low === "number" &&
            "high" in input &&
            typeof input.high === "number") {
            return true;
        }
        if (typeof input === "string") {
            const parts = input.split("-").map(parseFloat);
            if (Number.isNaN(parts[0]) || Number.isNaN(parts[1])) {
                errors.push({
                    // keyword: "yahooFinanceType",
                    instancePath,
                    schemaPath,
                    message: "yahooFinanceType: Number.parseFloat returned NaN: [" +
                        parts.join(",") +
                        "]",
                    // params: { schema, data },
                    schema,
                    data: input,
                });
                return false;
            }
            (0, index_js_1.set)(dataCtx, { low: parts[0], high: parts[1] }, instancePath);
            return true;
        }
        errors.push({
            // keyword: "yahooFinanceType",
            instancePath,
            schemaPath,
            message: "TwoNumberRange: Unexpected format",
            // params: { schema, data },
            schema,
            data: input,
        });
        return false;
    }
    // end TwoNumberRange.
    if (typeof input !== "object") {
        console.log({ schemaPath, schema });
        errors.push({
            instancePath,
            schemaPath,
            message: "Expected an object",
            data: input,
        });
        return false;
    }
    const _input = input;
    const _dataCtx = { parentData: _input, parentDataProperty: "" };
    if (schema.required) {
        for (const key of schema.required) {
            if (!(key in _input)) {
                errors.push({
                    instancePath,
                    schemaPath: schemaPath + "/required",
                    message: "Missing required property",
                    data: key,
                });
            }
        }
    }
    for (const [key, value] of Object.entries(_input)) {
        const propSchema = schema.properties?.[key];
        _dataCtx.parentDataProperty = key;
        if (propSchema) {
            (0, index_js_1.default)(value, propSchema, ctx, errors, instancePath + "/" + key, _dataCtx, schemaPath);
        }
        else {
            if (schema.additionalProperties === false) {
                errors.push({
                    instancePath,
                    schemaPath: schemaPath + "/additionalProperties",
                    message: "should NOT have additional properties",
                    params: {
                        additionalProperty: key,
                    },
                    data: _input,
                });
            }
            else if (schema.additionalProperties) {
                (0, index_js_1.default)(value, schema.additionalProperties, ctx, errors, instancePath + "/" + key, _dataCtx, schemaPath + "/additionalProperties");
            }
        }
    }
    return true;
};
exports.object = object;
