import type { JSONSchema7 } from "json-schema";
export type JSONSchema = JSONSchema7;
export declare const getTypedDefinitions: (schema: unknown) => any;
export type ValidationError = {
    keyword?: string;
    instancePath?: string;
    schemaPath?: string;
    data?: unknown;
    schema?: unknown;
    message: string;
    params?: {
        [key: string]: unknown;
    };
    subErrors?: ValidationError[];
};
export type ValidationCtx = {
    definitions: JSONSchema["definitions"];
    logger: unknown;
    logObj: (obj: unknown, opts?: {
        depth?: number;
    }) => void;
};
export type Validator = (input: unknown, schema: JSONSchema, ctx: ValidationCtx, errors: ValidationError[], instancePath: string, dataCtx: DataCtx | undefined, schemaPath: string) => boolean;
export declare function set(dataCtx: DataCtx | undefined, value: unknown, instancePath: string): void;
export interface DataCtx {
    parentData: unknown;
    parentDataProperty: number | string;
}
export default function validateAndCoerce(input: unknown, schemaOrSchemaKey: JSONSchema | string, ctx: ValidationCtx, errors?: ValidationError[], instancePath?: string, dataCtx?: DataCtx, schemaPath?: string | null): ValidationError[];
//# sourceMappingURL=index.d.ts.map