type RuntimeName = "node" | "deno" | "bun" | "cloudflare" | "unknown";
export interface RuntimeInfo {
    runtime: RuntimeName;
    version: string | null;
    details: Record<string, unknown>;
}
export interface SupportPolicy {
    node?: string;
    deno?: string;
    bun?: string;
    cloudflare?: {
        requireFeatures?: string[];
    };
}
export interface SupportCheckResult {
    ok: boolean;
    info: RuntimeInfo;
    reason?: string;
}
/** Detect the current JS runtime and version (if available). */
export declare function detectRuntime(): RuntimeInfo;
/** Check current >= minimum (major.minor.patch). */
export declare function isVersionAtLeast(current: string | null | undefined, minimum: string): boolean;
/**
 * Check support against your policy.
 */
export declare function checkSupport(policy?: SupportPolicy): SupportCheckResult;
/** Throw an Error if current runtime/version is unsupported. */
export declare function assertSupported(policy: SupportPolicy): void;
export {};
//# sourceMappingURL=runtime-detect.d.ts.map