"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = {
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$comment": "DO NOT EDIT THIS FILE.  It is generated automatically from typescript interfaces in the project.  To update, run `deno task schema` (with optional `--watch`).  In VSCode, this is run automatically for you on folder open.",
    "definitions": {
        "YahooFinanceOptions": {
            "type": "object",
            "properties": {
                "YF_QUERY_HOST": {
                    "type": "string"
                },
                "queue": {
                    "$ref": "#/definitions/QueueOptions"
                },
                "validation": {
                    "$ref": "#/definitions/ValidationOptions"
                },
                "suppressNotices": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/NOTICE_IDS"
                    }
                },
                "quoteCombine": {
                    "$ref": "#/definitions/QuoteCombineOptions"
                },
                "versionCheck": {
                    "type": "boolean"
                },
                "cookieJar": {
                    "$ref": "#/definitions/ExtendedCookieJar"
                },
                "logger": {
                    "$ref": "#/definitions/Logger"
                },
                "fetch": {},
                "fetchOptions": {
                    "type": "object",
                    "properties": {
                        "body": {
                            "anyOf": [
                                {
                                    "type": "object",
                                    "properties": {
                                        "locked": {
                                            "type": "boolean"
                                        }
                                    },
                                    "required": [
                                        "locked"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "size": {
                                            "type": "number"
                                        },
                                        "type": {
                                            "type": "string"
                                        }
                                    },
                                    "required": [
                                        "size",
                                        "type"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "buffer": {
                                            "type": "object",
                                            "properties": {
                                                "byteLength": {
                                                    "type": "number"
                                                }
                                            },
                                            "required": [
                                                "byteLength"
                                            ],
                                            "additionalProperties": false
                                        },
                                        "byteLength": {
                                            "type": "number"
                                        },
                                        "byteOffset": {
                                            "type": "number"
                                        }
                                    },
                                    "required": [
                                        "buffer",
                                        "byteLength",
                                        "byteOffset"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "byteLength": {
                                            "type": "number"
                                        }
                                    },
                                    "required": [
                                        "byteLength"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "size": {
                                            "type": "number"
                                        }
                                    },
                                    "required": [
                                        "size"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "string"
                                },
                                {
                                    "type": "null"
                                }
                            ]
                        },
                        "cache": {
                            "type": "string",
                            "enum": [
                                "default",
                                "force-cache",
                                "no-cache",
                                "no-store",
                                "only-if-cached",
                                "reload"
                            ]
                        },
                        "credentials": {
                            "type": "string",
                            "enum": [
                                "include",
                                "omit",
                                "same-origin"
                            ]
                        },
                        "headers": {
                            "anyOf": [
                                {
                                    "type": "array",
                                    "items": {
                                        "type": "array",
                                        "items": {
                                            "type": "string"
                                        },
                                        "minItems": 2,
                                        "maxItems": 2
                                    }
                                },
                                {
                                    "type": "object",
                                    "additionalProperties": {
                                        "type": "string"
                                    }
                                },
                                {
                                    "type": "object",
                                    "additionalProperties": false
                                }
                            ]
                        },
                        "integrity": {
                            "type": "string"
                        },
                        "keepalive": {
                            "type": "boolean"
                        },
                        "method": {
                            "type": "string"
                        },
                        "mode": {
                            "type": "string",
                            "enum": [
                                "cors",
                                "navigate",
                                "no-cors",
                                "same-origin"
                            ]
                        },
                        "priority": {
                            "type": "string",
                            "enum": [
                                "auto",
                                "high",
                                "low"
                            ]
                        },
                        "redirect": {
                            "type": "string",
                            "enum": [
                                "error",
                                "follow",
                                "manual"
                            ]
                        },
                        "referrer": {
                            "type": "string"
                        },
                        "referrerPolicy": {
                            "type": "string",
                            "enum": [
                                "",
                                "no-referrer",
                                "no-referrer-when-downgrade",
                                "origin",
                                "origin-when-cross-origin",
                                "same-origin",
                                "strict-origin",
                                "strict-origin-when-cross-origin",
                                "unsafe-url"
                            ]
                        },
                        "signal": {
                            "anyOf": [
                                {
                                    "type": "object",
                                    "properties": {
                                        "aborted": {
                                            "type": "boolean"
                                        },
                                        "onabort": {
                                            "anyOf": [
                                                {},
                                                {
                                                    "type": "null"
                                                }
                                            ]
                                        },
                                        "reason": {}
                                    },
                                    "required": [
                                        "aborted",
                                        "onabort",
                                        "reason"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "null"
                                }
                            ]
                        },
                        "window": {
                            "type": "null"
                        }
                    },
                    "additionalProperties": false
                }
            },
            "additionalProperties": false
        },
        "QueueOptions": {
            "type": "object",
            "properties": {
                "_queue": {
                    "$ref": "#/definitions/Queue"
                },
                "concurrency": {
                    "type": "number"
                }
            },
            "additionalProperties": false
        },
        "Queue": {
            "type": "object",
            "properties": {
                "concurrency": {
                    "type": "number"
                },
                "_running": {
                    "type": "number"
                },
                "_queue": {
                    "type": "array",
                    "items": {
                        "type": "object",
                        "properties": {
                            "func": {},
                            "resolve": {},
                            "reject": {}
                        },
                        "required": [
                            "func",
                            "resolve",
                            "reject"
                        ],
                        "additionalProperties": false
                    }
                }
            },
            "required": [
                "concurrency",
                "_running",
                "_queue"
            ],
            "additionalProperties": false
        },
        "ValidationOptions": {
            "type": "object",
            "properties": {
                "logErrors": {
                    "type": "boolean"
                },
                "logOptionsErrors": {
                    "type": "boolean"
                },
                "allowAdditionalProps": {
                    "type": "boolean"
                }
            },
            "additionalProperties": false
        },
        "NOTICE_IDS": {
            "type": "string",
            "enum": [
                "yahooSurvey",
                "ripHistorical"
            ]
        },
        "QuoteCombineOptions": {
            "type": "object",
            "properties": {
                "maxSymbolsPerRequest": {
                    "type": "number"
                },
                "debounceTime": {
                    "type": "number"
                }
            },
            "additionalProperties": false
        },
        "ExtendedCookieJar": {
            "type": "object",
            "additionalProperties": false,
            "properties": {
                "store": {
                    "$ref": "#/definitions/Store"
                },
                "prefixSecurity": {
                    "type": "string"
                }
            },
            "required": [
                "prefixSecurity",
                "store"
            ]
        },
        "CookieJar": {
            "type": "object",
            "properties": {
                "store": {
                    "$ref": "#/definitions/Store"
                },
                "prefixSecurity": {
                    "type": "string"
                }
            },
            "required": [
                "store",
                "prefixSecurity"
            ],
            "additionalProperties": false
        },
        "Store": {
            "type": "object",
            "properties": {
                "synchronous": {
                    "type": "boolean"
                }
            },
            "required": [
                "synchronous"
            ],
            "additionalProperties": false
        },
        "Logger": {
            "type": "object",
            "properties": {
                "info": {},
                "warn": {},
                "error": {},
                "debug": {},
                "dir": {}
            },
            "required": [
                "info",
                "warn",
                "error",
                "debug",
                "dir"
            ],
            "additionalProperties": false
        },
        "mergeObjects": {},
        "validateOptions": {},
        "setOptions": {},
        "YahooFinanceFetchModuleOptions": {
            "type": "object",
            "properties": {
                "devel": {
                    "type": "object",
                    "properties": {
                        "id": {
                            "type": "string"
                        },
                        "t": {},
                        "onFinish": {}
                    },
                    "required": [
                        "id",
                        "t",
                        "onFinish"
                    ],
                    "additionalProperties": false
                },
                "fetch": {},
                "fetchOptions": {
                    "type": "object",
                    "properties": {
                        "body": {
                            "anyOf": [
                                {
                                    "type": "object",
                                    "properties": {
                                        "locked": {
                                            "type": "boolean"
                                        }
                                    },
                                    "required": [
                                        "locked"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "size": {
                                            "type": "number"
                                        },
                                        "type": {
                                            "type": "string"
                                        }
                                    },
                                    "required": [
                                        "size",
                                        "type"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "buffer": {
                                            "type": "object",
                                            "properties": {
                                                "byteLength": {
                                                    "type": "number"
                                                }
                                            },
                                            "required": [
                                                "byteLength"
                                            ],
                                            "additionalProperties": false
                                        },
                                        "byteLength": {
                                            "type": "number"
                                        },
                                        "byteOffset": {
                                            "type": "number"
                                        }
                                    },
                                    "required": [
                                        "buffer",
                                        "byteLength",
                                        "byteOffset"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "byteLength": {
                                            "type": "number"
                                        }
                                    },
                                    "required": [
                                        "byteLength"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "size": {
                                            "type": "number"
                                        }
                                    },
                                    "required": [
                                        "size"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "string"
                                },
                                {
                                    "type": "null"
                                }
                            ]
                        },
                        "cache": {
                            "type": "string",
                            "enum": [
                                "default",
                                "force-cache",
                                "no-cache",
                                "no-store",
                                "only-if-cached",
                                "reload"
                            ]
                        },
                        "credentials": {
                            "type": "string",
                            "enum": [
                                "include",
                                "omit",
                                "same-origin"
                            ]
                        },
                        "headers": {
                            "anyOf": [
                                {
                                    "type": "array",
                                    "items": {
                                        "type": "array",
                                        "items": {
                                            "type": "string"
                                        },
                                        "minItems": 2,
                                        "maxItems": 2
                                    }
                                },
                                {
                                    "type": "object",
                                    "additionalProperties": {
                                        "type": "string"
                                    }
                                },
                                {
                                    "type": "object",
                                    "additionalProperties": false
                                }
                            ]
                        },
                        "integrity": {
                            "type": "string"
                        },
                        "keepalive": {
                            "type": "boolean"
                        },
                        "method": {
                            "type": "string"
                        },
                        "mode": {
                            "type": "string",
                            "enum": [
                                "cors",
                                "navigate",
                                "no-cors",
                                "same-origin"
                            ]
                        },
                        "priority": {
                            "type": "string",
                            "enum": [
                                "auto",
                                "high",
                                "low"
                            ]
                        },
                        "redirect": {
                            "type": "string",
                            "enum": [
                                "error",
                                "follow",
                                "manual"
                            ]
                        },
                        "referrer": {
                            "type": "string"
                        },
                        "referrerPolicy": {
                            "type": "string",
                            "enum": [
                                "",
                                "no-referrer",
                                "no-referrer-when-downgrade",
                                "origin",
                                "origin-when-cross-origin",
                                "same-origin",
                                "strict-origin",
                                "strict-origin-when-cross-origin",
                                "unsafe-url"
                            ]
                        },
                        "signal": {
                            "anyOf": [
                                {
                                    "type": "object",
                                    "properties": {
                                        "aborted": {
                                            "type": "boolean"
                                        },
                                        "onabort": {
                                            "anyOf": [
                                                {},
                                                {
                                                    "type": "null"
                                                }
                                            ]
                                        },
                                        "reason": {}
                                    },
                                    "required": [
                                        "aborted",
                                        "onabort",
                                        "reason"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "null"
                                }
                            ]
                        },
                        "window": {
                            "type": "null"
                        }
                    },
                    "additionalProperties": false
                },
                "queue": {
                    "$ref": "#/definitions/QueueOptions"
                }
            },
            "additionalProperties": false
        },
        "ModuleOptions": {
            "type": "object",
            "properties": {
                "devel": {
                    "type": "object",
                    "properties": {
                        "id": {
                            "type": "string"
                        },
                        "t": {},
                        "onFinish": {}
                    },
                    "required": [
                        "id",
                        "t",
                        "onFinish"
                    ],
                    "additionalProperties": false
                },
                "fetch": {},
                "fetchOptions": {
                    "type": "object",
                    "properties": {
                        "body": {
                            "anyOf": [
                                {
                                    "type": "object",
                                    "properties": {
                                        "locked": {
                                            "type": "boolean"
                                        }
                                    },
                                    "required": [
                                        "locked"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "size": {
                                            "type": "number"
                                        },
                                        "type": {
                                            "type": "string"
                                        }
                                    },
                                    "required": [
                                        "size",
                                        "type"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "buffer": {
                                            "type": "object",
                                            "properties": {
                                                "byteLength": {
                                                    "type": "number"
                                                }
                                            },
                                            "required": [
                                                "byteLength"
                                            ],
                                            "additionalProperties": false
                                        },
                                        "byteLength": {
                                            "type": "number"
                                        },
                                        "byteOffset": {
                                            "type": "number"
                                        }
                                    },
                                    "required": [
                                        "buffer",
                                        "byteLength",
                                        "byteOffset"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "byteLength": {
                                            "type": "number"
                                        }
                                    },
                                    "required": [
                                        "byteLength"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "size": {
                                            "type": "number"
                                        }
                                    },
                                    "required": [
                                        "size"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "string"
                                },
                                {
                                    "type": "null"
                                }
                            ]
                        },
                        "cache": {
                            "type": "string",
                            "enum": [
                                "default",
                                "force-cache",
                                "no-cache",
                                "no-store",
                                "only-if-cached",
                                "reload"
                            ]
                        },
                        "credentials": {
                            "type": "string",
                            "enum": [
                                "include",
                                "omit",
                                "same-origin"
                            ]
                        },
                        "headers": {
                            "anyOf": [
                                {
                                    "type": "array",
                                    "items": {
                                        "type": "array",
                                        "items": {
                                            "type": "string"
                                        },
                                        "minItems": 2,
                                        "maxItems": 2
                                    }
                                },
                                {
                                    "type": "object",
                                    "additionalProperties": {
                                        "type": "string"
                                    }
                                },
                                {
                                    "type": "object",
                                    "additionalProperties": false
                                }
                            ]
                        },
                        "integrity": {
                            "type": "string"
                        },
                        "keepalive": {
                            "type": "boolean"
                        },
                        "method": {
                            "type": "string"
                        },
                        "mode": {
                            "type": "string",
                            "enum": [
                                "cors",
                                "navigate",
                                "no-cors",
                                "same-origin"
                            ]
                        },
                        "priority": {
                            "type": "string",
                            "enum": [
                                "auto",
                                "high",
                                "low"
                            ]
                        },
                        "redirect": {
                            "type": "string",
                            "enum": [
                                "error",
                                "follow",
                                "manual"
                            ]
                        },
                        "referrer": {
                            "type": "string"
                        },
                        "referrerPolicy": {
                            "type": "string",
                            "enum": [
                                "",
                                "no-referrer",
                                "no-referrer-when-downgrade",
                                "origin",
                                "origin-when-cross-origin",
                                "same-origin",
                                "strict-origin",
                                "strict-origin-when-cross-origin",
                                "unsafe-url"
                            ]
                        },
                        "signal": {
                            "anyOf": [
                                {
                                    "type": "object",
                                    "properties": {
                                        "aborted": {
                                            "type": "boolean"
                                        },
                                        "onabort": {
                                            "anyOf": [
                                                {},
                                                {
                                                    "type": "null"
                                                }
                                            ]
                                        },
                                        "reason": {}
                                    },
                                    "required": [
                                        "aborted",
                                        "onabort",
                                        "reason"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "null"
                                }
                            ]
                        },
                        "window": {
                            "type": "null"
                        }
                    },
                    "additionalProperties": false
                },
                "queue": {
                    "$ref": "#/definitions/QueueOptions"
                },
                "validateOptions": {
                    "type": "boolean"
                },
                "validateResult": {
                    "type": "boolean"
                }
            },
            "additionalProperties": false
        },
        "ModuleOptionsWithValidateFalse": {
            "type": "object",
            "properties": {
                "devel": {
                    "type": "object",
                    "properties": {
                        "id": {
                            "type": "string"
                        },
                        "t": {},
                        "onFinish": {}
                    },
                    "required": [
                        "id",
                        "t",
                        "onFinish"
                    ],
                    "additionalProperties": false
                },
                "fetch": {},
                "fetchOptions": {
                    "type": "object",
                    "properties": {
                        "body": {
                            "anyOf": [
                                {
                                    "type": "object",
                                    "properties": {
                                        "locked": {
                                            "type": "boolean"
                                        }
                                    },
                                    "required": [
                                        "locked"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "size": {
                                            "type": "number"
                                        },
                                        "type": {
                                            "type": "string"
                                        }
                                    },
                                    "required": [
                                        "size",
                                        "type"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "buffer": {
                                            "type": "object",
                                            "properties": {
                                                "byteLength": {
                                                    "type": "number"
                                                }
                                            },
                                            "required": [
                                                "byteLength"
                                            ],
                                            "additionalProperties": false
                                        },
                                        "byteLength": {
                                            "type": "number"
                                        },
                                        "byteOffset": {
                                            "type": "number"
                                        }
                                    },
                                    "required": [
                                        "buffer",
                                        "byteLength",
                                        "byteOffset"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "byteLength": {
                                            "type": "number"
                                        }
                                    },
                                    "required": [
                                        "byteLength"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "size": {
                                            "type": "number"
                                        }
                                    },
                                    "required": [
                                        "size"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "string"
                                },
                                {
                                    "type": "null"
                                }
                            ]
                        },
                        "cache": {
                            "type": "string",
                            "enum": [
                                "default",
                                "force-cache",
                                "no-cache",
                                "no-store",
                                "only-if-cached",
                                "reload"
                            ]
                        },
                        "credentials": {
                            "type": "string",
                            "enum": [
                                "include",
                                "omit",
                                "same-origin"
                            ]
                        },
                        "headers": {
                            "anyOf": [
                                {
                                    "type": "array",
                                    "items": {
                                        "type": "array",
                                        "items": {
                                            "type": "string"
                                        },
                                        "minItems": 2,
                                        "maxItems": 2
                                    }
                                },
                                {
                                    "type": "object",
                                    "additionalProperties": {
                                        "type": "string"
                                    }
                                },
                                {
                                    "type": "object",
                                    "additionalProperties": false
                                }
                            ]
                        },
                        "integrity": {
                            "type": "string"
                        },
                        "keepalive": {
                            "type": "boolean"
                        },
                        "method": {
                            "type": "string"
                        },
                        "mode": {
                            "type": "string",
                            "enum": [
                                "cors",
                                "navigate",
                                "no-cors",
                                "same-origin"
                            ]
                        },
                        "priority": {
                            "type": "string",
                            "enum": [
                                "auto",
                                "high",
                                "low"
                            ]
                        },
                        "redirect": {
                            "type": "string",
                            "enum": [
                                "error",
                                "follow",
                                "manual"
                            ]
                        },
                        "referrer": {
                            "type": "string"
                        },
                        "referrerPolicy": {
                            "type": "string",
                            "enum": [
                                "",
                                "no-referrer",
                                "no-referrer-when-downgrade",
                                "origin",
                                "origin-when-cross-origin",
                                "same-origin",
                                "strict-origin",
                                "strict-origin-when-cross-origin",
                                "unsafe-url"
                            ]
                        },
                        "signal": {
                            "anyOf": [
                                {
                                    "type": "object",
                                    "properties": {
                                        "aborted": {
                                            "type": "boolean"
                                        },
                                        "onabort": {
                                            "anyOf": [
                                                {},
                                                {
                                                    "type": "null"
                                                }
                                            ]
                                        },
                                        "reason": {}
                                    },
                                    "required": [
                                        "aborted",
                                        "onabort",
                                        "reason"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "null"
                                }
                            ]
                        },
                        "window": {
                            "type": "null"
                        }
                    },
                    "additionalProperties": false
                },
                "queue": {
                    "$ref": "#/definitions/QueueOptions"
                },
                "validateOptions": {
                    "type": "boolean"
                },
                "validateResult": {
                    "type": "boolean",
                    "const": false
                }
            },
            "required": [
                "validateResult"
            ],
            "additionalProperties": false
        },
        "ModuleOptionsWithValidateTrue": {
            "type": "object",
            "properties": {
                "devel": {
                    "type": "object",
                    "properties": {
                        "id": {
                            "type": "string"
                        },
                        "t": {},
                        "onFinish": {}
                    },
                    "required": [
                        "id",
                        "t",
                        "onFinish"
                    ],
                    "additionalProperties": false
                },
                "fetch": {},
                "fetchOptions": {
                    "type": "object",
                    "properties": {
                        "body": {
                            "anyOf": [
                                {
                                    "type": "object",
                                    "properties": {
                                        "locked": {
                                            "type": "boolean"
                                        }
                                    },
                                    "required": [
                                        "locked"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "size": {
                                            "type": "number"
                                        },
                                        "type": {
                                            "type": "string"
                                        }
                                    },
                                    "required": [
                                        "size",
                                        "type"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "buffer": {
                                            "type": "object",
                                            "properties": {
                                                "byteLength": {
                                                    "type": "number"
                                                }
                                            },
                                            "required": [
                                                "byteLength"
                                            ],
                                            "additionalProperties": false
                                        },
                                        "byteLength": {
                                            "type": "number"
                                        },
                                        "byteOffset": {
                                            "type": "number"
                                        }
                                    },
                                    "required": [
                                        "buffer",
                                        "byteLength",
                                        "byteOffset"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "byteLength": {
                                            "type": "number"
                                        }
                                    },
                                    "required": [
                                        "byteLength"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "additionalProperties": false
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "size": {
                                            "type": "number"
                                        }
                                    },
                                    "required": [
                                        "size"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "string"
                                },
                                {
                                    "type": "null"
                                }
                            ]
                        },
                        "cache": {
                            "type": "string",
                            "enum": [
                                "default",
                                "force-cache",
                                "no-cache",
                                "no-store",
                                "only-if-cached",
                                "reload"
                            ]
                        },
                        "credentials": {
                            "type": "string",
                            "enum": [
                                "include",
                                "omit",
                                "same-origin"
                            ]
                        },
                        "headers": {
                            "anyOf": [
                                {
                                    "type": "array",
                                    "items": {
                                        "type": "array",
                                        "items": {
                                            "type": "string"
                                        },
                                        "minItems": 2,
                                        "maxItems": 2
                                    }
                                },
                                {
                                    "type": "object",
                                    "additionalProperties": {
                                        "type": "string"
                                    }
                                },
                                {
                                    "type": "object",
                                    "additionalProperties": false
                                }
                            ]
                        },
                        "integrity": {
                            "type": "string"
                        },
                        "keepalive": {
                            "type": "boolean"
                        },
                        "method": {
                            "type": "string"
                        },
                        "mode": {
                            "type": "string",
                            "enum": [
                                "cors",
                                "navigate",
                                "no-cors",
                                "same-origin"
                            ]
                        },
                        "priority": {
                            "type": "string",
                            "enum": [
                                "auto",
                                "high",
                                "low"
                            ]
                        },
                        "redirect": {
                            "type": "string",
                            "enum": [
                                "error",
                                "follow",
                                "manual"
                            ]
                        },
                        "referrer": {
                            "type": "string"
                        },
                        "referrerPolicy": {
                            "type": "string",
                            "enum": [
                                "",
                                "no-referrer",
                                "no-referrer-when-downgrade",
                                "origin",
                                "origin-when-cross-origin",
                                "same-origin",
                                "strict-origin",
                                "strict-origin-when-cross-origin",
                                "unsafe-url"
                            ]
                        },
                        "signal": {
                            "anyOf": [
                                {
                                    "type": "object",
                                    "properties": {
                                        "aborted": {
                                            "type": "boolean"
                                        },
                                        "onabort": {
                                            "anyOf": [
                                                {},
                                                {
                                                    "type": "null"
                                                }
                                            ]
                                        },
                                        "reason": {}
                                    },
                                    "required": [
                                        "aborted",
                                        "onabort",
                                        "reason"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "type": "null"
                                }
                            ]
                        },
                        "window": {
                            "type": "null"
                        }
                    },
                    "additionalProperties": false
                },
                "queue": {
                    "$ref": "#/definitions/QueueOptions"
                },
                "validateOptions": {
                    "type": "boolean"
                },
                "validateResult": {
                    "type": "boolean",
                    "const": true
                }
            },
            "additionalProperties": false
        },
        "ModuleThis": {
            "type": "object",
            "properties": {
                "_moduleExec": {}
            },
            "required": [
                "_moduleExec"
            ]
        },
        "ModuleError": {
            "type": "object",
            "properties": {
                "name": {
                    "type": "string"
                },
                "message": {
                    "type": "string"
                },
                "stack": {
                    "type": "string"
                }
            },
            "required": [
                "name",
                "message"
            ],
            "additionalProperties": false
        }
    }
};
