"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeObjects = mergeObjects;
exports.validateOptions = validateOptions;
exports.setOptions = setOptions;
const cookieJar_js_1 = require("../cookieJar.js");
const logger_js_1 = require("./logger.js");
const options_schema_js_1 = __importDefault(require("./options.schema.js"));
const validateAndCoerceTypes_js_1 = __importDefault(require("../validateAndCoerceTypes.js"));
const index_js_1 = require("../validate/index.js");
const definitions = (0, index_js_1.getTypedDefinitions)(options_schema_js_1.default);
function mergeObjects(original, objToMerge) {
    const ownKeys = Reflect.ownKeys(objToMerge);
    for (const key of ownKeys) {
        if (typeof objToMerge[key] === "object") {
            mergeObjects(original[key], objToMerge[key]);
        }
        else {
            original[key] = objToMerge[key];
        }
    }
}
function validateOptions(options, source = "_setOpts") {
    // Exclude complex types that won't validate properly with json-schema
    // and check later.
    const { cookieJar, logger, fetch, ...simpleOptions } = options;
    // Validation of simple JSON types
    (0, validateAndCoerceTypes_js_1.default)({
        object: simpleOptions,
        source,
        type: "options",
        // options: this._opts.validation!,
        options: {
            logErrors: false,
            logOptionsErrors: true,
            allowAdditionalProps: false,
        },
        schemaOrSchemaKey: "#/definitions/YahooFinanceOptions",
        definitions,
        logger: this._opts.logger,
        logObj: this._logObj,
        // versionCheck: this._opts.versionCheck!,
        versionCheck: false,
    });
    // Complex type checks
    if (cookieJar && !(cookieJar instanceof cookieJar_js_1.ExtendedCookieJar)) {
        throw new Error("cookieJar must be an instance of ExtendedCookieJar");
    }
    logger && (0, logger_js_1.validateOptions)(logger);
    if (fetch && typeof fetch !== "function") {
        throw new Error("fetch must be a function");
    }
}
function setOptions(options) {
    validateOptions.call(this, options);
    mergeObjects(this._opts, options);
}
