/**
 * Logger options for {@linkcode YahooFinance}.
 *
 * By default, we use the built-in `console` for logging, but you can override it
 * with anything you like. You can use this to control logging output or send
 * your logs to a logging service.
 *
 * @example
 * ```ts
 * const yahooFinance = new YahooFinance({
 *   logger: {
 *      info: (...args: any[]) => console.log(...args),
 *      warn: (...args: any[]) => console.error(...args),
 *     error: (...args: any[]) => console.error(...args),
 *     debug: (...args: any[]) => console.log(...args),
 *   },
 * });
 */
export interface Logger {
    info: (...args: any[]) => void;
    warn: (...args: any[]) => void;
    error: (...args: any[]) => void;
    debug: (...args: any[]) => void;
    dir: (...args: any[]) => void;
}
export declare const defaultOptions: Logger;
export declare function validateOptions(logger: unknown): void;
//# sourceMappingURL=logger.d.ts.map