"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const cookieJar_js_1 = require("../cookieJar.js");
const logger_js_1 = require("./logger.js");
const quoteCombine_js_1 = require("../../other/quoteCombine.js");
const deno_js_1 = __importDefault(require("../../../deno.js"));
// import { repository } from "../consts.ts";
// Big thanks to @nocodehummel who figured out a User-Agent that both
// works but still allows us to identify ourselves honestly.
const userAgent = `Mozilla/5.0 (compatible; yahoo-finance2/${deno_js_1.default.version})`;
// const userAgent = `${pkg.name}/${pkg.version} (+${repository})`;
const options = {
    YF_QUERY_HOST: "query2.finance.yahoo.com",
    cookieJar: new cookieJar_js_1.ExtendedCookieJar(),
    queue: {
        concurrency: 4, // Min: 1, Max: Infinity
        // timeout: 60,
    },
    validation: {
        logErrors: true,
        logOptionsErrors: true,
        allowAdditionalProps: true,
    },
    logger: logger_js_1.defaultOptions,
    quoteCombine: quoteCombine_js_1.defaultOptions,
    versionCheck: true,
    fetchOptions: {
        headers: {
            "User-Agent": userAgent,
        },
    },
};
exports.default = options;
