/** Primitives we never merge */
type Primitive = string | number | boolean | bigint | symbol | null | undefined;
/** A safe callable type (instead of `Function`) */
type AnyFn = (...args: readonly unknown[]) => unknown;
/**
 * Things we do NOT deep-merge (we overwrite instead).
 * Add more here if your domain needs them (URL, Buffer, TypedArrays, etc.)
 */
type NonMergeable = Primitive | AnyFn | Date | RegExp | Map<unknown, unknown> | Set<unknown> | WeakMap<object, unknown> | WeakSet<object> | Promise<unknown> | readonly unknown[];
type IsPlainObject<T> = T extends object ? T extends NonMergeable ? false : true : false;
type Simplify<T> = {
    [K in keyof T]: T[K];
} & Record<PropertyKey, never>;
/** Merge two object types; last wins for non-plain objects */
type MergeTwoTypes<A, B> = IsPlainObject<A> extends true ? IsPlainObject<B> extends true ? Simplify<{
    [K in keyof A | keyof B]: K extends keyof B ? K extends keyof A ? MergeValue<A[K], B[K]> : B[K] : K extends keyof A ? A[K] : never;
}> : B : B;
type MergeValue<AV, BV> = IsPlainObject<AV> extends true ? IsPlainObject<BV> extends true ? MergeTwoTypes<AV, BV> : BV : BV;
/** Fold a tuple of objects left-to-right */
type DeepMergeTuple<T extends readonly unknown[]> = T extends readonly [infer A, ...infer R] ? R extends readonly unknown[] ? MergeTwoTypes<A, DeepMergeTuple<R>> : A : Record<PropertyKey, never>;
export type DeepMergeResult<T extends readonly unknown[]> = Simplify<DeepMergeTuple<T>>;
/**
 * Deep merge any number of objects.
 * - Deep merges *plain objects* only.
 * - Overwrites arrays and class instances.
 * - Later args win.
 */
export declare function deepMerge<const T extends readonly object[]>(...objects: T): DeepMergeResult<T>;
export {};
//# sourceMappingURL=deepmerge.d.ts.map