"use strict";
// Copyright 2018-2025 the Deno authors. MIT license.
// This module is browser compatible.
Object.defineProperty(exports, "__esModule", { value: true });
exports._format = _format;
exports.assertArg = assertArg;
function _format(sep, pathObject) {
    const dir = pathObject.dir || pathObject.root;
    const base = pathObject.base ||
        (pathObject.name ?? "") + (pathObject.ext ?? "");
    if (!dir)
        return base;
    if (base === sep)
        return dir;
    if (dir === pathObject.root)
        return dir + base;
    return dir + sep + base;
}
function assertArg(pathObject) {
    if (pathObject === null || typeof pathObject !== "object") {
        throw new TypeError(`The "pathObject" argument must be of type Object, received type "${typeof pathObject}"`);
    }
}
