"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = {
    "name": "@gadicc/yahoo-finance2",
    "version": "3.13.0",
    "tasks": {
        "cli": "deno run -A bin/yahoo-finance.ts",
        "docs:gen": "deno doc --output=jsdocs --html $(jq -r '.exports | to_entries[] | .value' deno.json)",
        "docs:lint": "deno doc --output=jsdocs --lint --html $(jq -r '.exports | to_entries[] | .value' deno.json)",
        "docs:open": "xdg-open file://$(pwd)/jsdocs/index.html",
        "docs:watch": "deno eval 'const run=async()=>{const p=new Deno.Command(\"deno\",{args:[\"task\",\"docs:gen\"],stdout:\"inherit\",stderr:\"inherit\"}).spawn(); const {code}=await p.status; if(code) console.error(\"[docs:gen] exited\", code);}; let t; const kick=()=>{clearTimeout(t); t=setTimeout(run,120)}; await run(); for await(const _ of Deno.watchFs([\"src\",\"docs\",\"scripts\",\"README.md\"])) kick();'",
        "install-cli": "deno install -A --global -n yahoo-finance npm:yahoo-finance/bin/yahoo-finance.ts",
        "schema_": "TODO below... separate watch mode, vscode scripts, mtime check, etc",
        "schema": "deno run -A scripts/schema-gen.ts",
        "test": "deno test -A --parallel",
        "build:npm": "deno run -A scripts/build_npm.ts",
        "devTODO": "deno run --watch main.ts"
    },
    "exports": {
        "./src/index.ts": "./src/index.ts",
        ".": "./src/index.ts",
        "./createYahooFinance": "./src/createYahooFinance.ts",
        "./modules": "./src/modules/index.ts",
        "./modules/autoc": "./src/modules/autoc.ts",
        "./modules/chart": "./src/modules/chart.ts",
        "./modules/dailyGainers": "./src/modules/dailyGainers.ts",
        "./modules/dailyLosers": "./src/modules/dailyLosers.ts",
        "./modules/fundamentalsTimeSeries": "./src/modules/fundamentalsTimeSeries.ts",
        "./modules/historical": "./src/modules/historical.ts",
        "./modules/insights": "./src/modules/insights.ts",
        "./modules/options": "./src/modules/options.ts",
        "./modules/quoteSummary-iface": "./src/modules/quoteSummary-iface.ts",
        "./modules/quoteSummary": "./src/modules/quoteSummary.ts",
        "./modules/quote": "./src/modules/quote.ts",
        "./modules/recommendationsBySymbol": "./src/modules/recommendationsBySymbol.ts",
        "./modules/screener": "./src/modules/screener.ts",
        "./modules/search": "./src/modules/search.ts",
        "./modules/trendingSymbols": "./src/modules/trendingSymbols.ts",
        "./other": "./src/other/index.ts",
        "./other/quoteCombine": "./src/other/quoteCombine.ts",
        "./lib/moduleCommon": "./src/lib/moduleCommon.ts",
        "./lib/cookieJar": "./src/lib/cookieJar.ts",
        "./lib/getCrumb": "./src/lib/getCrumb.ts",
        "./lib/options": "./src/lib/options/options.ts"
    },
    "imports": {
        "@deno/dnt": "jsr:@deno/dnt@^0.42.3",
        "@gadicc/fetch-mock-cache": "jsr:@gadicc/fetch-mock-cache@^2.2.0",
        "@jest/types": "npm:@jest/types@^29.6.3",
        "@std/async": "jsr:@std/async@^1.0.11",
        "@std/cli": "jsr:@std/cli@^1.0.14",
        "@std/expect": "jsr:@std/expect@^1.0.13",
        "@std/fmt": "jsr:@std/fmt@^1.0.5",
        "@std/fs": "jsr:@std/fs@^1.0.13",
        "@std/path": "jsr:@std/path@^1.1.2",
        "@std/testing": "jsr:@std/testing@^1.0.9",
        "@types/json-schema": "npm:@types/json-schema@^7.0.15",
        "conventional-changelog-conventionalcommits": "npm:conventional-changelog-conventionalcommits@^8.0.0",
        "fetch-mock-cache": "npm:fetch-mock-cache@^2.1.3",
        "jest-get-type": "npm:jest-get-type@^29.6.3",
        "json-schema": "npm:json-schema@^0.4.0",
        "oas-schema-walker": "npm:oas-schema-walker@^1.1.5",
        "semantic-release": "npm:semantic-release@^24.2.3",
        "tough-cookie": "npm:tough-cookie@^5.1.1",
        "tough-cookie-file-store": "npm:tough-cookie-file-store@^2.0.3",
        "ts-json-schema-generator": "npm:ts-json-schema-generator@^2.4.0"
    },
    "fmt": {
        "exclude": ["tests/fixtures", "tests/http", "**/*.schema.json"]
    },
    "publish": {
        "exclude": [
            "./.circleci",
            "./.editorconfig",
            "./.github",
            "./.vscode",
            "./docs",
            "./scripts",
            "./tests"
        ]
    },
    "compilerOptions": {
        "lib": [
            "dom",
            "dom.iterable",
            "dom.asynciterable",
            "deno.ns"
        ]
    }
};
