export default {
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$comment": "DO NOT EDIT THIS FILE.  It is generated automatically from typescript interfaces in the project.  To update, run `deno task schema` (with optional `--watch`).  In VSCode, this is run automatically for you on folder open.",
    "definitions": {
        "SearchQuoteYahoo": {
            "type": "object",
            "properties": {
                "symbol": {
                    "type": "string"
                },
                "isYahooFinance": {
                    "type": "boolean",
                    "const": true
                },
                "exchange": {
                    "type": "string"
                },
                "exchDisp": {
                    "type": "string"
                },
                "shortname": {
                    "type": "string"
                },
                "longname": {
                    "type": "string"
                },
                "index": {
                    "type": "string",
                    "const": "quotes"
                },
                "score": {
                    "type": "number"
                },
                "newListingDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "prevName": {
                    "type": "string"
                },
                "nameChangeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "sector": {
                    "type": "string"
                },
                "industry": {
                    "type": "string"
                },
                "dispSecIndFlag": {
                    "type": "boolean"
                }
            },
            "required": [
                "symbol",
                "isYahooFinance",
                "exchange",
                "index",
                "score"
            ],
            "additionalProperties": {}
        },
        "SearchQuoteYahooEquity": {
            "type": "object",
            "properties": {
                "symbol": {
                    "type": "string"
                },
                "isYahooFinance": {
                    "type": "boolean",
                    "const": true
                },
                "exchange": {
                    "type": "string"
                },
                "exchDisp": {
                    "type": "string"
                },
                "shortname": {
                    "type": "string"
                },
                "longname": {
                    "type": "string"
                },
                "index": {
                    "type": "string",
                    "const": "quotes"
                },
                "score": {
                    "type": "number"
                },
                "newListingDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "prevName": {
                    "type": "string"
                },
                "nameChangeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "sector": {
                    "type": "string"
                },
                "industry": {
                    "type": "string"
                },
                "dispSecIndFlag": {
                    "type": "boolean"
                },
                "quoteType": {
                    "type": "string",
                    "const": "EQUITY"
                },
                "typeDisp": {
                    "type": "string",
                    "const": "Equity"
                },
                "sectorDisp": {
                    "type": "string"
                },
                "industryDisp": {
                    "type": "string"
                }
            },
            "required": [
                "exchange",
                "index",
                "isYahooFinance",
                "quoteType",
                "score",
                "symbol",
                "typeDisp"
            ]
        },
        "SearchQuoteYahooOption": {
            "type": "object",
            "properties": {
                "symbol": {
                    "type": "string"
                },
                "isYahooFinance": {
                    "type": "boolean",
                    "const": true
                },
                "exchange": {
                    "type": "string"
                },
                "exchDisp": {
                    "type": "string"
                },
                "shortname": {
                    "type": "string"
                },
                "longname": {
                    "type": "string"
                },
                "index": {
                    "type": "string",
                    "const": "quotes"
                },
                "score": {
                    "type": "number"
                },
                "newListingDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "prevName": {
                    "type": "string"
                },
                "nameChangeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "sector": {
                    "type": "string"
                },
                "industry": {
                    "type": "string"
                },
                "dispSecIndFlag": {
                    "type": "boolean"
                },
                "quoteType": {
                    "type": "string",
                    "const": "OPTION"
                },
                "typeDisp": {
                    "type": "string",
                    "const": "Option"
                }
            },
            "required": [
                "exchange",
                "index",
                "isYahooFinance",
                "quoteType",
                "score",
                "symbol",
                "typeDisp"
            ]
        },
        "SearchQuoteYahooETF": {
            "type": "object",
            "properties": {
                "symbol": {
                    "type": "string"
                },
                "isYahooFinance": {
                    "type": "boolean",
                    "const": true
                },
                "exchange": {
                    "type": "string"
                },
                "exchDisp": {
                    "type": "string"
                },
                "shortname": {
                    "type": "string"
                },
                "longname": {
                    "type": "string"
                },
                "index": {
                    "type": "string",
                    "const": "quotes"
                },
                "score": {
                    "type": "number"
                },
                "newListingDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "prevName": {
                    "type": "string"
                },
                "nameChangeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "sector": {
                    "type": "string"
                },
                "industry": {
                    "type": "string"
                },
                "dispSecIndFlag": {
                    "type": "boolean"
                },
                "quoteType": {
                    "type": "string",
                    "const": "ETF"
                },
                "typeDisp": {
                    "type": "string",
                    "const": "ETF"
                }
            },
            "required": [
                "exchange",
                "index",
                "isYahooFinance",
                "quoteType",
                "score",
                "symbol",
                "typeDisp"
            ]
        },
        "SearchQuoteYahooFund": {
            "type": "object",
            "properties": {
                "symbol": {
                    "type": "string"
                },
                "isYahooFinance": {
                    "type": "boolean",
                    "const": true
                },
                "exchange": {
                    "type": "string"
                },
                "exchDisp": {
                    "type": "string"
                },
                "shortname": {
                    "type": "string"
                },
                "longname": {
                    "type": "string"
                },
                "index": {
                    "type": "string",
                    "const": "quotes"
                },
                "score": {
                    "type": "number"
                },
                "newListingDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "prevName": {
                    "type": "string"
                },
                "nameChangeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "sector": {
                    "type": "string"
                },
                "industry": {
                    "type": "string"
                },
                "dispSecIndFlag": {
                    "type": "boolean"
                },
                "quoteType": {
                    "type": "string",
                    "const": "MUTUALFUND"
                },
                "typeDisp": {
                    "type": "string",
                    "const": "Fund"
                }
            },
            "required": [
                "exchange",
                "index",
                "isYahooFinance",
                "quoteType",
                "score",
                "symbol",
                "typeDisp"
            ]
        },
        "SearchQuoteYahooIndex": {
            "type": "object",
            "properties": {
                "symbol": {
                    "type": "string"
                },
                "isYahooFinance": {
                    "type": "boolean",
                    "const": true
                },
                "exchange": {
                    "type": "string"
                },
                "exchDisp": {
                    "type": "string"
                },
                "shortname": {
                    "type": "string"
                },
                "longname": {
                    "type": "string"
                },
                "index": {
                    "type": "string",
                    "const": "quotes"
                },
                "score": {
                    "type": "number"
                },
                "newListingDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "prevName": {
                    "type": "string"
                },
                "nameChangeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "sector": {
                    "type": "string"
                },
                "industry": {
                    "type": "string"
                },
                "dispSecIndFlag": {
                    "type": "boolean"
                },
                "quoteType": {
                    "type": "string",
                    "const": "INDEX"
                },
                "typeDisp": {
                    "type": "string",
                    "const": "Index"
                }
            },
            "required": [
                "exchange",
                "index",
                "isYahooFinance",
                "quoteType",
                "score",
                "symbol",
                "typeDisp"
            ]
        },
        "SearchQuoteYahooCurrency": {
            "type": "object",
            "properties": {
                "symbol": {
                    "type": "string"
                },
                "isYahooFinance": {
                    "type": "boolean",
                    "const": true
                },
                "exchange": {
                    "type": "string"
                },
                "exchDisp": {
                    "type": "string"
                },
                "shortname": {
                    "type": "string"
                },
                "longname": {
                    "type": "string"
                },
                "index": {
                    "type": "string",
                    "const": "quotes"
                },
                "score": {
                    "type": "number"
                },
                "newListingDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "prevName": {
                    "type": "string"
                },
                "nameChangeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "sector": {
                    "type": "string"
                },
                "industry": {
                    "type": "string"
                },
                "dispSecIndFlag": {
                    "type": "boolean"
                },
                "quoteType": {
                    "type": "string",
                    "const": "CURRENCY"
                },
                "typeDisp": {
                    "type": "string",
                    "const": "Currency"
                }
            },
            "required": [
                "exchange",
                "index",
                "isYahooFinance",
                "quoteType",
                "score",
                "symbol",
                "typeDisp"
            ]
        },
        "SearchQuoteYahooCryptocurrency": {
            "type": "object",
            "properties": {
                "symbol": {
                    "type": "string"
                },
                "isYahooFinance": {
                    "type": "boolean",
                    "const": true
                },
                "exchange": {
                    "type": "string"
                },
                "exchDisp": {
                    "type": "string"
                },
                "shortname": {
                    "type": "string"
                },
                "longname": {
                    "type": "string"
                },
                "index": {
                    "type": "string",
                    "const": "quotes"
                },
                "score": {
                    "type": "number"
                },
                "newListingDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "prevName": {
                    "type": "string"
                },
                "nameChangeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "sector": {
                    "type": "string"
                },
                "industry": {
                    "type": "string"
                },
                "dispSecIndFlag": {
                    "type": "boolean"
                },
                "quoteType": {
                    "type": "string",
                    "const": "CRYPTOCURRENCY"
                },
                "typeDisp": {
                    "type": "string",
                    "const": "Cryptocurrency"
                }
            },
            "required": [
                "exchange",
                "index",
                "isYahooFinance",
                "quoteType",
                "score",
                "symbol",
                "typeDisp"
            ]
        },
        "SearchQuoteYahooFuture": {
            "type": "object",
            "properties": {
                "symbol": {
                    "type": "string"
                },
                "isYahooFinance": {
                    "type": "boolean",
                    "const": true
                },
                "exchange": {
                    "type": "string"
                },
                "exchDisp": {
                    "type": "string"
                },
                "shortname": {
                    "type": "string"
                },
                "longname": {
                    "type": "string"
                },
                "index": {
                    "type": "string",
                    "const": "quotes"
                },
                "score": {
                    "type": "number"
                },
                "newListingDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "prevName": {
                    "type": "string"
                },
                "nameChangeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "sector": {
                    "type": "string"
                },
                "industry": {
                    "type": "string"
                },
                "dispSecIndFlag": {
                    "type": "boolean"
                },
                "quoteType": {
                    "type": "string",
                    "const": "FUTURE"
                },
                "typeDisp": {
                    "type": "string",
                    "enum": [
                        "Future",
                        "Futures"
                    ]
                }
            },
            "required": [
                "exchange",
                "index",
                "isYahooFinance",
                "quoteType",
                "score",
                "symbol",
                "typeDisp"
            ]
        },
        "SearchQuoteYahooMoneyMarket": {
            "type": "object",
            "properties": {
                "symbol": {
                    "type": "string"
                },
                "isYahooFinance": {
                    "type": "boolean",
                    "const": true
                },
                "exchange": {
                    "type": "string"
                },
                "exchDisp": {
                    "type": "string"
                },
                "shortname": {
                    "type": "string"
                },
                "longname": {
                    "type": "string"
                },
                "index": {
                    "type": "string",
                    "const": "quotes"
                },
                "score": {
                    "type": "number"
                },
                "newListingDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "prevName": {
                    "type": "string"
                },
                "nameChangeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "sector": {
                    "type": "string"
                },
                "industry": {
                    "type": "string"
                },
                "dispSecIndFlag": {
                    "type": "boolean"
                },
                "quoteType": {
                    "type": "string",
                    "const": "MONEY_MARKET"
                },
                "typeDisp": {
                    "type": "string",
                    "const": "MoneyMarket"
                }
            },
            "required": [
                "exchange",
                "index",
                "isYahooFinance",
                "quoteType",
                "score",
                "symbol",
                "typeDisp"
            ]
        },
        "SearchQuoteNonYahoo": {
            "type": "object",
            "properties": {
                "index": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "permalink": {
                    "type": "string"
                },
                "isYahooFinance": {
                    "type": "boolean",
                    "const": false
                }
            },
            "required": [
                "index",
                "name",
                "permalink",
                "isYahooFinance"
            ],
            "additionalProperties": {}
        },
        "SearchNews": {
            "type": "object",
            "properties": {
                "uuid": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                },
                "publisher": {
                    "type": "string"
                },
                "link": {
                    "type": "string"
                },
                "providerPublishTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "type": {
                    "type": "string"
                },
                "thumbnail": {
                    "type": "object",
                    "properties": {
                        "resolutions": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/SearchNewsThumbnailResolution"
                            }
                        }
                    },
                    "required": [
                        "resolutions"
                    ],
                    "additionalProperties": false
                },
                "relatedTickers": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            },
            "required": [
                "uuid",
                "title",
                "publisher",
                "link",
                "providerPublishTime",
                "type"
            ],
            "additionalProperties": {}
        },
        "SearchNewsThumbnailResolution": {
            "type": "object",
            "properties": {
                "url": {
                    "type": "string"
                },
                "width": {
                    "type": "number"
                },
                "height": {
                    "type": "number"
                },
                "tag": {
                    "type": "string"
                }
            },
            "required": [
                "url",
                "width",
                "height",
                "tag"
            ],
            "additionalProperties": false
        },
        "SearchResult": {
            "type": "object",
            "properties": {
                "explains": {
                    "type": "array",
                    "items": {}
                },
                "count": {
                    "type": "number"
                },
                "quotes": {
                    "type": "array",
                    "items": {
                        "anyOf": [
                            {
                                "$ref": "#/definitions/SearchQuoteYahooEquity"
                            },
                            {
                                "$ref": "#/definitions/SearchQuoteYahooOption"
                            },
                            {
                                "$ref": "#/definitions/SearchQuoteYahooETF"
                            },
                            {
                                "$ref": "#/definitions/SearchQuoteYahooFund"
                            },
                            {
                                "$ref": "#/definitions/SearchQuoteYahooIndex"
                            },
                            {
                                "$ref": "#/definitions/SearchQuoteYahooCurrency"
                            },
                            {
                                "$ref": "#/definitions/SearchQuoteYahooCryptocurrency"
                            },
                            {
                                "$ref": "#/definitions/SearchQuoteNonYahoo"
                            },
                            {
                                "$ref": "#/definitions/SearchQuoteYahooFuture"
                            },
                            {
                                "$ref": "#/definitions/SearchQuoteYahooMoneyMarket"
                            }
                        ]
                    }
                },
                "news": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/SearchNews"
                    }
                },
                "nav": {
                    "type": "array",
                    "items": {}
                },
                "lists": {
                    "type": "array",
                    "items": {}
                },
                "researchReports": {
                    "type": "array",
                    "items": {}
                },
                "totalTime": {
                    "type": "number"
                },
                "screenerFieldResults": {
                    "type": "array",
                    "items": {}
                },
                "culturalAssets": {
                    "type": "array",
                    "items": {}
                },
                "timeTakenForQuotes": {
                    "type": "number"
                },
                "timeTakenForNews": {
                    "type": "number"
                },
                "timeTakenForAlgowatchlist": {
                    "type": "number"
                },
                "timeTakenForPredefinedScreener": {
                    "type": "number"
                },
                "timeTakenForCrunchbase": {
                    "type": "number"
                },
                "timeTakenForNav": {
                    "type": "number"
                },
                "timeTakenForResearchReports": {
                    "type": "number"
                },
                "timeTakenForScreenerField": {
                    "type": "number"
                },
                "timeTakenForCulturalAssets": {
                    "type": "number"
                },
                "timeTakenForSearchLists": {
                    "type": "number"
                }
            },
            "required": [
                "explains",
                "count",
                "quotes",
                "news",
                "nav",
                "lists",
                "researchReports",
                "totalTime",
                "timeTakenForQuotes",
                "timeTakenForNews",
                "timeTakenForAlgowatchlist",
                "timeTakenForPredefinedScreener",
                "timeTakenForCrunchbase",
                "timeTakenForNav",
                "timeTakenForResearchReports",
                "timeTakenForScreenerField",
                "timeTakenForCulturalAssets",
                "timeTakenForSearchLists"
            ],
            "additionalProperties": {}
        },
        "SearchOptions": {
            "type": "object",
            "properties": {
                "lang": {
                    "type": "string"
                },
                "region": {
                    "type": "string"
                },
                "quotesCount": {
                    "type": "number"
                },
                "newsCount": {
                    "type": "number"
                },
                "enableFuzzyQuery": {
                    "type": "boolean"
                },
                "quotesQueryId": {
                    "type": "string"
                },
                "multiQuoteQueryId": {
                    "type": "string"
                },
                "newsQueryId": {
                    "type": "string"
                },
                "enableCb": {
                    "type": "boolean"
                },
                "enableNavLinks": {
                    "type": "boolean"
                },
                "enableEnhancedTrivialQuery": {
                    "type": "boolean"
                }
            },
            "additionalProperties": false
        },
        "search": {}
    }
};
