export default {
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$comment": "DO NOT EDIT THIS FILE.  It is generated automatically from typescript interfaces in the project.  To update, run `deno task schema` (with optional `--watch`).  In VSCode, this is run automatically for you on folder open.",
    "definitions": {
        "ScreenerResultBase": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "canonicalName": {
                    "type": "string"
                },
                "criteriaMeta": {
                    "$ref": "#/definitions/ScreenerCriteriaMeta"
                },
                "rawCriteria": {
                    "type": "string"
                },
                "start": {
                    "type": "number"
                },
                "count": {
                    "type": "number"
                },
                "total": {
                    "type": "number"
                },
                "quotes": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/ScreenerQuote"
                    }
                },
                "useRecords": {
                    "type": "boolean"
                },
                "predefinedScr": {
                    "type": "boolean"
                },
                "versionId": {
                    "type": "number"
                },
                "creationDate": {
                    "type": "number"
                },
                "lastUpdated": {
                    "type": "number"
                },
                "isPremium": {
                    "type": "boolean"
                },
                "iconUrl": {
                    "type": "string"
                }
            },
            "required": [
                "id",
                "title",
                "description",
                "canonicalName",
                "criteriaMeta",
                "rawCriteria",
                "start",
                "count",
                "total",
                "quotes",
                "useRecords",
                "predefinedScr",
                "versionId",
                "creationDate",
                "lastUpdated",
                "isPremium",
                "iconUrl"
            ],
            "additionalProperties": false
        },
        "ScreenerCriteriaMeta": {
            "type": "object",
            "properties": {
                "size": {
                    "type": "number"
                },
                "offset": {
                    "type": "number"
                },
                "sortField": {
                    "type": "string"
                },
                "sortType": {
                    "type": "string"
                },
                "quoteType": {
                    "type": "string"
                },
                "criteria": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/ScreenerCriterum"
                    }
                },
                "topOperator": {
                    "type": "string"
                }
            },
            "required": [
                "size",
                "offset",
                "sortField",
                "sortType",
                "quoteType",
                "criteria",
                "topOperator"
            ],
            "additionalProperties": false
        },
        "ScreenerCriterum": {
            "type": "object",
            "properties": {
                "field": {
                    "type": "string"
                },
                "operators": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "values": {
                    "type": "array",
                    "items": {
                        "type": [
                            "string",
                            "number"
                        ]
                    }
                },
                "labelsSelected": {
                    "type": "array",
                    "items": {
                        "type": "number"
                    }
                },
                "dependentValues": {
                    "type": "array",
                    "items": {}
                },
                "subField": {
                    "type": "null"
                }
            },
            "required": [
                "field",
                "operators",
                "values",
                "labelsSelected",
                "dependentValues"
            ],
            "additionalProperties": false
        },
        "ScreenerQuote": {
            "type": "object",
            "properties": {
                "language": {
                    "type": "string"
                },
                "region": {
                    "type": "string"
                },
                "quoteType": {
                    "type": "string"
                },
                "typeDisp": {
                    "type": "string"
                },
                "quoteSourceName": {
                    "type": "string"
                },
                "triggerable": {
                    "type": "boolean"
                },
                "customPriceAlertConfidence": {
                    "type": "string"
                },
                "lastCloseTevEbitLtm": {
                    "type": "number"
                },
                "lastClosePriceToNNWCPerShare": {
                    "type": "number"
                },
                "firstTradeDateMilliseconds": {
                    "type": "number"
                },
                "priceHint": {
                    "type": "number"
                },
                "postMarketChangePercent": {
                    "type": "number"
                },
                "postMarketTime": {
                    "type": "number"
                },
                "postMarketPrice": {
                    "type": "number"
                },
                "postMarketChange": {
                    "type": "number"
                },
                "regularMarketChange": {
                    "type": "number"
                },
                "regularMarketTime": {
                    "type": "number"
                },
                "regularMarketPrice": {
                    "type": "number"
                },
                "regularMarketDayHigh": {
                    "type": "number"
                },
                "regularMarketDayRange": {
                    "type": "string"
                },
                "currency": {
                    "type": "string"
                },
                "regularMarketDayLow": {
                    "type": "number"
                },
                "regularMarketVolume": {
                    "type": "number"
                },
                "regularMarketPreviousClose": {
                    "type": "number"
                },
                "bid": {
                    "type": "number"
                },
                "ask": {
                    "type": "number"
                },
                "bidSize": {
                    "type": "number"
                },
                "askSize": {
                    "type": "number"
                },
                "market": {
                    "type": "string"
                },
                "messageBoardId": {
                    "type": "string"
                },
                "fullExchangeName": {
                    "type": "string"
                },
                "longName": {
                    "type": "string"
                },
                "financialCurrency": {
                    "type": "string"
                },
                "regularMarketOpen": {
                    "type": "number"
                },
                "averageDailyVolume3Month": {
                    "type": "number"
                },
                "averageDailyVolume10Day": {
                    "type": "number"
                },
                "fiftyTwoWeekLowChange": {
                    "type": "number"
                },
                "fiftyTwoWeekLowChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekRange": {
                    "type": "string"
                },
                "fiftyTwoWeekHighChange": {
                    "type": "number"
                },
                "fiftyTwoWeekHighChangePercent": {
                    "type": "number"
                },
                "fiftyTwoWeekChangePercent": {
                    "type": "number"
                },
                "earningsTimestamp": {
                    "type": "number"
                },
                "earningsTimestampStart": {
                    "type": "number"
                },
                "earningsTimestampEnd": {
                    "type": "number"
                },
                "trailingAnnualDividendRate": {
                    "type": "number"
                },
                "trailingAnnualDividendYield": {
                    "type": "number"
                },
                "marketState": {
                    "type": "string"
                },
                "epsTrailingTwelveMonths": {
                    "type": "number"
                },
                "epsForward": {
                    "type": "number"
                },
                "epsCurrentYear": {
                    "type": "number"
                },
                "priceEpsCurrentYear": {
                    "type": "number"
                },
                "sharesOutstanding": {
                    "type": "number"
                },
                "bookValue": {
                    "type": "number"
                },
                "fiftyDayAverage": {
                    "type": "number"
                },
                "fiftyDayAverageChange": {
                    "type": "number"
                },
                "fiftyDayAverageChangePercent": {
                    "type": "number"
                },
                "twoHundredDayAverage": {
                    "type": "number"
                },
                "twoHundredDayAverageChange": {
                    "type": "number"
                },
                "twoHundredDayAverageChangePercent": {
                    "type": "number"
                },
                "marketCap": {
                    "type": "number"
                },
                "forwardPE": {
                    "type": "number"
                },
                "priceToBook": {
                    "type": "number"
                },
                "sourceInterval": {
                    "type": "number"
                },
                "exchangeDataDelayedBy": {
                    "type": "number"
                },
                "exchangeTimezoneName": {
                    "type": "string"
                },
                "exchangeTimezoneShortName": {
                    "type": "string"
                },
                "gmtOffSetMilliseconds": {
                    "type": "number"
                },
                "esgPopulated": {
                    "type": "boolean"
                },
                "tradeable": {
                    "type": "boolean"
                },
                "cryptoTradeable": {
                    "type": "boolean"
                },
                "exchange": {
                    "type": "string"
                },
                "fiftyTwoWeekLow": {
                    "type": "number"
                },
                "fiftyTwoWeekHigh": {
                    "type": "number"
                },
                "shortName": {
                    "type": "string"
                },
                "averageAnalystRating": {
                    "type": "string"
                },
                "regularMarketChangePercent": {
                    "type": "number"
                },
                "symbol": {
                    "type": "string"
                },
                "dividendDate": {
                    "type": "number"
                },
                "displayName": {
                    "type": "string"
                },
                "trailingPE": {
                    "type": "number"
                },
                "prevName": {
                    "type": "string"
                },
                "nameChangeDate": {
                    "type": "number"
                },
                "ipoExpectedDate": {
                    "type": "number"
                },
                "dividendYield": {
                    "type": "number"
                },
                "dividendRate": {
                    "type": "number"
                },
                "yieldTTM": {
                    "type": "number"
                },
                "peTTM": {
                    "type": "number"
                },
                "annualReturnNavY3": {
                    "type": "number"
                },
                "annualReturnNavY5": {
                    "type": "number"
                },
                "ytdReturn": {
                    "type": "number"
                },
                "trailingThreeMonthReturns": {
                    "type": "number"
                },
                "netAssets": {
                    "type": "number"
                },
                "netExpenseRatio": {
                    "type": "number"
                },
                "hasPrePostMarketData": {
                    "type": "boolean"
                },
                "corporateActions": {
                    "type": "array",
                    "items": {}
                },
                "earningsCallTimestampStart": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsCallTimestampEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "isEarningsDateEstimate": {
                    "type": "boolean"
                },
                "preMarketChange": {
                    "type": "number"
                },
                "preMarketChangePercent": {
                    "type": "number"
                },
                "preMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "preMarketPrice": {
                    "type": "number"
                }
            },
            "required": [
                "language",
                "region",
                "quoteType",
                "typeDisp",
                "triggerable",
                "customPriceAlertConfidence",
                "firstTradeDateMilliseconds",
                "priceHint",
                "regularMarketChange",
                "regularMarketTime",
                "regularMarketPrice",
                "currency",
                "regularMarketPreviousClose",
                "market",
                "messageBoardId",
                "fullExchangeName",
                "fiftyTwoWeekLowChange",
                "fiftyTwoWeekRange",
                "fiftyTwoWeekHighChange",
                "fiftyTwoWeekHighChangePercent",
                "fiftyTwoWeekChangePercent",
                "marketState",
                "fiftyDayAverage",
                "fiftyDayAverageChange",
                "fiftyDayAverageChangePercent",
                "twoHundredDayAverage",
                "twoHundredDayAverageChange",
                "twoHundredDayAverageChangePercent",
                "sourceInterval",
                "exchangeDataDelayedBy",
                "exchangeTimezoneName",
                "exchangeTimezoneShortName",
                "gmtOffSetMilliseconds",
                "esgPopulated",
                "tradeable",
                "cryptoTradeable",
                "exchange",
                "fiftyTwoWeekLow",
                "fiftyTwoWeekHigh",
                "shortName",
                "regularMarketChangePercent",
                "symbol"
            ],
            "additionalProperties": false
        },
        "ScreenerResultAggressiveSmallCaps": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "canonicalName": {
                    "type": "string",
                    "const": "AGGRESSIVE_SMALL_CAPS"
                },
                "criteriaMeta": {
                    "type": "object",
                    "additionalProperties": false,
                    "properties": {
                        "includeFields": {
                            "type": "array",
                            "items": {
                                "type": "string",
                                "enum": [
                                    "change_in_number_of_institutional_holders",
                                    "trading_central_last_close_price_to_fair_value",
                                    "intradaypricechange",
                                    "estimated_revenue_growth",
                                    "intradaymarketcap",
                                    "morningstar_previous_rating",
                                    "fiftytwowkhigh",
                                    "fiftytwowkpercentchange",
                                    "pctheldinst",
                                    "morningstar_last_close_price_to_fair_value",
                                    "shares_bought_by_funds",
                                    "ror_percent",
                                    "morningstar_rating",
                                    "sector",
                                    "peratio.lasttwelvemonths",
                                    "bullish_proportion",
                                    "percent_change_in_number_of_institutional_holders",
                                    "number_of_institutional_sellers",
                                    "morningstar_stewardship",
                                    "lastclosetevebit.lasttwelvemonths",
                                    "percentchange",
                                    "morningstar_economic_moat",
                                    "percent_of_shares_outstanding_bought_by_institutions",
                                    "day_open_price",
                                    "morningstar_rating_change",
                                    "number_of_institutional_holders",
                                    "percent_in_funds_holding",
                                    "exchange",
                                    "percent_of_shares_outstanding_sold_by_institutions",
                                    "dayvolume",
                                    "bearish_proportion",
                                    "morningstar_fair_value",
                                    "sold_proportion",
                                    "industry",
                                    "morningstar_uncertainty",
                                    "shares_sold_by_funds",
                                    "fair_value",
                                    "bought_proportion",
                                    "percent_in_top_ten_holdings",
                                    "avgdailyvol3m",
                                    "last_close_price_to_nnwc_per_share",
                                    "estimated_earnings_growth",
                                    "ticker",
                                    "longname_us_en-us",
                                    "percent_change_in_shares_held_by_funds",
                                    "number_of_institutional_buyers",
                                    "companyshortname",
                                    "intradayprice",
                                    "change_in_shares_held_by_funds",
                                    "indices",
                                    "neutral_proportion",
                                    "latest_holdings_report_date",
                                    "fiftytwowklow",
                                    "value_description",
                                    "average_analyst_rating",
                                    "region",
                                    "epsgrowth.lasttwelvemonths",
                                    "quarterlyrevenuegrowth.quarterly",
                                    "pegratio_5y"
                                ]
                            }
                        },
                        "size": {
                            "type": "number"
                        },
                        "offset": {
                            "type": "number"
                        },
                        "sortField": {
                            "type": "string"
                        },
                        "sortType": {
                            "type": "string"
                        },
                        "quoteType": {
                            "type": "string"
                        },
                        "criteria": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/ScreenerCriterum"
                            }
                        },
                        "topOperator": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "criteria",
                        "includeFields",
                        "offset",
                        "quoteType",
                        "size",
                        "sortField",
                        "sortType",
                        "topOperator"
                    ]
                },
                "rawCriteria": {
                    "type": "string"
                },
                "start": {
                    "type": "number"
                },
                "count": {
                    "type": "number"
                },
                "total": {
                    "type": "number"
                },
                "quotes": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/ScreenerQuote"
                    }
                },
                "useRecords": {
                    "type": "boolean"
                },
                "predefinedScr": {
                    "type": "boolean"
                },
                "versionId": {
                    "type": "number"
                },
                "creationDate": {
                    "type": "number"
                },
                "lastUpdated": {
                    "type": "number"
                },
                "isPremium": {
                    "type": "boolean"
                },
                "iconUrl": {
                    "type": "string"
                }
            },
            "required": [
                "canonicalName",
                "count",
                "creationDate",
                "criteriaMeta",
                "description",
                "iconUrl",
                "id",
                "isPremium",
                "lastUpdated",
                "predefinedScr",
                "quotes",
                "rawCriteria",
                "start",
                "title",
                "total",
                "useRecords",
                "versionId"
            ],
            "additionalProperties": false
        },
        "ScreenerCriteriaFieldsFund": {
            "type": "string",
            "enum": [
                "fundnetassets",
                "sold_proportion",
                "annualreportnetexpenseratio",
                "performanceratingoverall",
                "intradaypricechange",
                "bought_proportion",
                "fiftytwowkhigh",
                "fiftydaymovingavg",
                "ticker",
                "longname_us_en-us",
                "percentchange",
                "companyshortname",
                "intradayprice",
                "annualreturnnavy5",
                "day_open_price",
                "annualreturnnavy3",
                "annualreturnnavy1",
                "annualreportgrossexpenseratio",
                "twohundreddaymovingavg",
                "pe_ttm",
                "yield_ttm",
                "exchange",
                "fiftytwowklow",
                "riskratingoverall",
                "trailing_ytd_return",
                "trailing_3m_return",
                "annualreturnnavy1categoryrank",
                "categoryname",
                "initialinvestment"
            ]
        },
        "ScreenerResultConservativeForeignFunds": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "canonicalName": {
                    "type": "string",
                    "const": "CONSERVATIVE_FOREIGN_FUNDS"
                },
                "criteriaMeta": {
                    "type": "object",
                    "additionalProperties": false,
                    "properties": {
                        "includeFields": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/ScreenerCriteriaFieldsFund"
                            }
                        },
                        "size": {
                            "type": "number"
                        },
                        "offset": {
                            "type": "number"
                        },
                        "sortField": {
                            "type": "string"
                        },
                        "sortType": {
                            "type": "string"
                        },
                        "quoteType": {
                            "type": "string"
                        },
                        "criteria": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/ScreenerCriterum"
                            }
                        },
                        "topOperator": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "criteria",
                        "includeFields",
                        "offset",
                        "quoteType",
                        "size",
                        "sortField",
                        "sortType",
                        "topOperator"
                    ]
                },
                "rawCriteria": {
                    "type": "string"
                },
                "start": {
                    "type": "number"
                },
                "count": {
                    "type": "number"
                },
                "total": {
                    "type": "number"
                },
                "quotes": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/ScreenerQuote"
                    }
                },
                "useRecords": {
                    "type": "boolean"
                },
                "predefinedScr": {
                    "type": "boolean"
                },
                "versionId": {
                    "type": "number"
                },
                "creationDate": {
                    "type": "number"
                },
                "lastUpdated": {
                    "type": "number"
                },
                "isPremium": {
                    "type": "boolean"
                },
                "iconUrl": {
                    "type": "string"
                }
            },
            "required": [
                "canonicalName",
                "count",
                "creationDate",
                "criteriaMeta",
                "description",
                "iconUrl",
                "id",
                "isPremium",
                "lastUpdated",
                "predefinedScr",
                "quotes",
                "rawCriteria",
                "start",
                "title",
                "total",
                "useRecords",
                "versionId"
            ],
            "additionalProperties": false
        },
        "ScreenerResultDayGainers": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "canonicalName": {
                    "type": "string",
                    "const": "DAY_GAINERS"
                },
                "criteriaMeta": {
                    "type": "object",
                    "additionalProperties": false,
                    "properties": {
                        "includeFields": {
                            "type": "array",
                            "items": {
                                "type": "string",
                                "enum": [
                                    "change_in_number_of_institutional_holders",
                                    "trading_central_last_close_price_to_fair_value",
                                    "intradaypricechange",
                                    "estimated_revenue_growth",
                                    "intradaymarketcap",
                                    "morningstar_previous_rating",
                                    "fiftytwowkhigh",
                                    "fiftytwowkpercentchange",
                                    "pctheldinst",
                                    "morningstar_last_close_price_to_fair_value",
                                    "shares_bought_by_funds",
                                    "ror_percent",
                                    "morningstar_rating",
                                    "sector",
                                    "peratio.lasttwelvemonths",
                                    "bullish_proportion",
                                    "percent_change_in_number_of_institutional_holders",
                                    "number_of_institutional_sellers",
                                    "morningstar_stewardship",
                                    "lastclosetevebit.lasttwelvemonths",
                                    "percentchange",
                                    "morningstar_economic_moat",
                                    "percent_of_shares_outstanding_bought_by_institutions",
                                    "day_open_price",
                                    "morningstar_rating_change",
                                    "number_of_institutional_holders",
                                    "percent_in_funds_holding",
                                    "exchange",
                                    "percent_of_shares_outstanding_sold_by_institutions",
                                    "dayvolume",
                                    "bearish_proportion",
                                    "morningstar_fair_value",
                                    "sold_proportion",
                                    "industry",
                                    "morningstar_uncertainty",
                                    "shares_sold_by_funds",
                                    "fair_value",
                                    "bought_proportion",
                                    "percent_in_top_ten_holdings",
                                    "avgdailyvol3m",
                                    "last_close_price_to_nnwc_per_share",
                                    "estimated_earnings_growth",
                                    "ticker",
                                    "longname_us_en-us",
                                    "percent_change_in_shares_held_by_funds",
                                    "number_of_institutional_buyers",
                                    "companyshortname",
                                    "intradayprice",
                                    "change_in_shares_held_by_funds",
                                    "indices",
                                    "neutral_proportion",
                                    "latest_holdings_report_date",
                                    "fiftytwowklow",
                                    "value_description",
                                    "average_analyst_rating",
                                    "region",
                                    "epsgrowth.lasttwelvemonths",
                                    "quarterlyrevenuegrowth.quarterly",
                                    "pegratio_5y"
                                ]
                            }
                        },
                        "size": {
                            "type": "number"
                        },
                        "offset": {
                            "type": "number"
                        },
                        "sortField": {
                            "type": "string"
                        },
                        "sortType": {
                            "type": "string"
                        },
                        "quoteType": {
                            "type": "string"
                        },
                        "criteria": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/ScreenerCriterum"
                            }
                        },
                        "topOperator": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "criteria",
                        "includeFields",
                        "offset",
                        "quoteType",
                        "size",
                        "sortField",
                        "sortType",
                        "topOperator"
                    ]
                },
                "rawCriteria": {
                    "type": "string"
                },
                "start": {
                    "type": "number"
                },
                "count": {
                    "type": "number"
                },
                "total": {
                    "type": "number"
                },
                "quotes": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/ScreenerQuote"
                    }
                },
                "useRecords": {
                    "type": "boolean"
                },
                "predefinedScr": {
                    "type": "boolean"
                },
                "versionId": {
                    "type": "number"
                },
                "creationDate": {
                    "type": "number"
                },
                "lastUpdated": {
                    "type": "number"
                },
                "isPremium": {
                    "type": "boolean"
                },
                "iconUrl": {
                    "type": "string"
                }
            },
            "required": [
                "canonicalName",
                "count",
                "creationDate",
                "criteriaMeta",
                "description",
                "iconUrl",
                "id",
                "isPremium",
                "lastUpdated",
                "predefinedScr",
                "quotes",
                "rawCriteria",
                "start",
                "title",
                "total",
                "useRecords",
                "versionId"
            ],
            "additionalProperties": false
        },
        "ScreenerResultDayLosers": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "canonicalName": {
                    "type": "string",
                    "const": "DAY_LOSERS"
                },
                "criteriaMeta": {
                    "type": "object",
                    "additionalProperties": false,
                    "properties": {
                        "includeFields": {
                            "type": "array",
                            "items": {
                                "type": "string",
                                "enum": [
                                    "change_in_number_of_institutional_holders",
                                    "trading_central_last_close_price_to_fair_value",
                                    "intradaypricechange",
                                    "estimated_revenue_growth",
                                    "intradaymarketcap",
                                    "morningstar_previous_rating",
                                    "fiftytwowkhigh",
                                    "fiftytwowkpercentchange",
                                    "pctheldinst",
                                    "morningstar_last_close_price_to_fair_value",
                                    "shares_bought_by_funds",
                                    "ror_percent",
                                    "morningstar_rating",
                                    "sector",
                                    "peratio.lasttwelvemonths",
                                    "bullish_proportion",
                                    "percent_change_in_number_of_institutional_holders",
                                    "number_of_institutional_sellers",
                                    "morningstar_stewardship",
                                    "lastclosetevebit.lasttwelvemonths",
                                    "percentchange",
                                    "morningstar_economic_moat",
                                    "percent_of_shares_outstanding_bought_by_institutions",
                                    "day_open_price",
                                    "morningstar_rating_change",
                                    "number_of_institutional_holders",
                                    "percent_in_funds_holding",
                                    "exchange",
                                    "percent_of_shares_outstanding_sold_by_institutions",
                                    "dayvolume",
                                    "bearish_proportion",
                                    "morningstar_fair_value",
                                    "sold_proportion",
                                    "industry",
                                    "morningstar_uncertainty",
                                    "shares_sold_by_funds",
                                    "fair_value",
                                    "bought_proportion",
                                    "percent_in_top_ten_holdings",
                                    "avgdailyvol3m",
                                    "last_close_price_to_nnwc_per_share",
                                    "estimated_earnings_growth",
                                    "ticker",
                                    "longname_us_en-us",
                                    "percent_change_in_shares_held_by_funds",
                                    "number_of_institutional_buyers",
                                    "companyshortname",
                                    "intradayprice",
                                    "change_in_shares_held_by_funds",
                                    "indices",
                                    "neutral_proportion",
                                    "latest_holdings_report_date",
                                    "fiftytwowklow",
                                    "value_description",
                                    "average_analyst_rating",
                                    "region",
                                    "epsgrowth.lasttwelvemonths",
                                    "quarterlyrevenuegrowth.quarterly",
                                    "pegratio_5y"
                                ]
                            }
                        },
                        "size": {
                            "type": "number"
                        },
                        "offset": {
                            "type": "number"
                        },
                        "sortField": {
                            "type": "string"
                        },
                        "sortType": {
                            "type": "string"
                        },
                        "quoteType": {
                            "type": "string"
                        },
                        "criteria": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/ScreenerCriterum"
                            }
                        },
                        "topOperator": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "criteria",
                        "includeFields",
                        "offset",
                        "quoteType",
                        "size",
                        "sortField",
                        "sortType",
                        "topOperator"
                    ]
                },
                "rawCriteria": {
                    "type": "string"
                },
                "start": {
                    "type": "number"
                },
                "count": {
                    "type": "number"
                },
                "total": {
                    "type": "number"
                },
                "quotes": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/ScreenerQuote"
                    }
                },
                "useRecords": {
                    "type": "boolean"
                },
                "predefinedScr": {
                    "type": "boolean"
                },
                "versionId": {
                    "type": "number"
                },
                "creationDate": {
                    "type": "number"
                },
                "lastUpdated": {
                    "type": "number"
                },
                "isPremium": {
                    "type": "boolean"
                },
                "iconUrl": {
                    "type": "string"
                }
            },
            "required": [
                "canonicalName",
                "count",
                "creationDate",
                "criteriaMeta",
                "description",
                "iconUrl",
                "id",
                "isPremium",
                "lastUpdated",
                "predefinedScr",
                "quotes",
                "rawCriteria",
                "start",
                "title",
                "total",
                "useRecords",
                "versionId"
            ],
            "additionalProperties": false
        },
        "ScreenerResultGrowthTechnologyStocks": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "canonicalName": {
                    "type": "string",
                    "const": "GROWTH_TECHNOLOGY_STOCKS"
                },
                "criteriaMeta": {
                    "type": "object",
                    "additionalProperties": false,
                    "properties": {
                        "includeFields": {
                            "type": "array",
                            "items": {
                                "type": "string",
                                "enum": [
                                    "change_in_number_of_institutional_holders",
                                    "trading_central_last_close_price_to_fair_value",
                                    "intradaypricechange",
                                    "estimated_revenue_growth",
                                    "intradaymarketcap",
                                    "morningstar_previous_rating",
                                    "fiftytwowkhigh",
                                    "fiftytwowkpercentchange",
                                    "pctheldinst",
                                    "morningstar_last_close_price_to_fair_value",
                                    "shares_bought_by_funds",
                                    "ror_percent",
                                    "morningstar_rating",
                                    "sector",
                                    "peratio.lasttwelvemonths",
                                    "bullish_proportion",
                                    "percent_change_in_number_of_institutional_holders",
                                    "number_of_institutional_sellers",
                                    "morningstar_stewardship",
                                    "lastclosetevebit.lasttwelvemonths",
                                    "percentchange",
                                    "morningstar_economic_moat",
                                    "percent_of_shares_outstanding_bought_by_institutions",
                                    "day_open_price",
                                    "morningstar_rating_change",
                                    "number_of_institutional_holders",
                                    "percent_in_funds_holding",
                                    "exchange",
                                    "percent_of_shares_outstanding_sold_by_institutions",
                                    "dayvolume",
                                    "bearish_proportion",
                                    "morningstar_fair_value",
                                    "sold_proportion",
                                    "industry",
                                    "morningstar_uncertainty",
                                    "shares_sold_by_funds",
                                    "fair_value",
                                    "bought_proportion",
                                    "percent_in_top_ten_holdings",
                                    "avgdailyvol3m",
                                    "last_close_price_to_nnwc_per_share",
                                    "estimated_earnings_growth",
                                    "ticker",
                                    "longname_us_en-us",
                                    "percent_change_in_shares_held_by_funds",
                                    "number_of_institutional_buyers",
                                    "companyshortname",
                                    "intradayprice",
                                    "change_in_shares_held_by_funds",
                                    "indices",
                                    "neutral_proportion",
                                    "latest_holdings_report_date",
                                    "fiftytwowklow",
                                    "value_description",
                                    "average_analyst_rating",
                                    "region",
                                    "epsgrowth.lasttwelvemonths",
                                    "quarterlyrevenuegrowth.quarterly",
                                    "pegratio_5y"
                                ]
                            }
                        },
                        "size": {
                            "type": "number"
                        },
                        "offset": {
                            "type": "number"
                        },
                        "sortField": {
                            "type": "string"
                        },
                        "sortType": {
                            "type": "string"
                        },
                        "quoteType": {
                            "type": "string"
                        },
                        "criteria": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/ScreenerCriterum"
                            }
                        },
                        "topOperator": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "criteria",
                        "includeFields",
                        "offset",
                        "quoteType",
                        "size",
                        "sortField",
                        "sortType",
                        "topOperator"
                    ]
                },
                "rawCriteria": {
                    "type": "string"
                },
                "start": {
                    "type": "number"
                },
                "count": {
                    "type": "number"
                },
                "total": {
                    "type": "number"
                },
                "quotes": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/ScreenerQuote"
                    }
                },
                "useRecords": {
                    "type": "boolean"
                },
                "predefinedScr": {
                    "type": "boolean"
                },
                "versionId": {
                    "type": "number"
                },
                "creationDate": {
                    "type": "number"
                },
                "lastUpdated": {
                    "type": "number"
                },
                "isPremium": {
                    "type": "boolean"
                },
                "iconUrl": {
                    "type": "string"
                }
            },
            "required": [
                "canonicalName",
                "count",
                "creationDate",
                "criteriaMeta",
                "description",
                "iconUrl",
                "id",
                "isPremium",
                "lastUpdated",
                "predefinedScr",
                "quotes",
                "rawCriteria",
                "start",
                "title",
                "total",
                "useRecords",
                "versionId"
            ],
            "additionalProperties": false
        },
        "ScreenerResultMostActives": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "canonicalName": {
                    "type": "string",
                    "const": "MOST_ACTIVES"
                },
                "criteriaMeta": {
                    "type": "object",
                    "additionalProperties": false,
                    "properties": {
                        "includeFields": {
                            "type": "array",
                            "items": {
                                "type": "string",
                                "enum": [
                                    "change_in_number_of_institutional_holders",
                                    "trading_central_last_close_price_to_fair_value",
                                    "intradaypricechange",
                                    "estimated_revenue_growth",
                                    "intradaymarketcap",
                                    "morningstar_previous_rating",
                                    "fiftytwowkhigh",
                                    "fiftytwowkpercentchange",
                                    "pctheldinst",
                                    "morningstar_last_close_price_to_fair_value",
                                    "shares_bought_by_funds",
                                    "ror_percent",
                                    "morningstar_rating",
                                    "sector",
                                    "peratio.lasttwelvemonths",
                                    "bullish_proportion",
                                    "percent_change_in_number_of_institutional_holders",
                                    "number_of_institutional_sellers",
                                    "morningstar_stewardship",
                                    "lastclosetevebit.lasttwelvemonths",
                                    "percentchange",
                                    "morningstar_economic_moat",
                                    "percent_of_shares_outstanding_bought_by_institutions",
                                    "day_open_price",
                                    "morningstar_rating_change",
                                    "number_of_institutional_holders",
                                    "percent_in_funds_holding",
                                    "exchange",
                                    "percent_of_shares_outstanding_sold_by_institutions",
                                    "dayvolume",
                                    "bearish_proportion",
                                    "morningstar_fair_value",
                                    "sold_proportion",
                                    "industry",
                                    "morningstar_uncertainty",
                                    "shares_sold_by_funds",
                                    "fair_value",
                                    "bought_proportion",
                                    "percent_in_top_ten_holdings",
                                    "avgdailyvol3m",
                                    "last_close_price_to_nnwc_per_share",
                                    "estimated_earnings_growth",
                                    "ticker",
                                    "longname_us_en-us",
                                    "percent_change_in_shares_held_by_funds",
                                    "number_of_institutional_buyers",
                                    "companyshortname",
                                    "intradayprice",
                                    "change_in_shares_held_by_funds",
                                    "indices",
                                    "neutral_proportion",
                                    "latest_holdings_report_date",
                                    "fiftytwowklow",
                                    "value_description",
                                    "average_analyst_rating",
                                    "region",
                                    "epsgrowth.lasttwelvemonths",
                                    "quarterlyrevenuegrowth.quarterly",
                                    "pegratio_5y"
                                ]
                            }
                        },
                        "size": {
                            "type": "number"
                        },
                        "offset": {
                            "type": "number"
                        },
                        "sortField": {
                            "type": "string"
                        },
                        "sortType": {
                            "type": "string"
                        },
                        "quoteType": {
                            "type": "string"
                        },
                        "criteria": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/ScreenerCriterum"
                            }
                        },
                        "topOperator": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "criteria",
                        "includeFields",
                        "offset",
                        "quoteType",
                        "size",
                        "sortField",
                        "sortType",
                        "topOperator"
                    ]
                },
                "rawCriteria": {
                    "type": "string"
                },
                "start": {
                    "type": "number"
                },
                "count": {
                    "type": "number"
                },
                "total": {
                    "type": "number"
                },
                "quotes": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/ScreenerQuote"
                    }
                },
                "useRecords": {
                    "type": "boolean"
                },
                "predefinedScr": {
                    "type": "boolean"
                },
                "versionId": {
                    "type": "number"
                },
                "creationDate": {
                    "type": "number"
                },
                "lastUpdated": {
                    "type": "number"
                },
                "isPremium": {
                    "type": "boolean"
                },
                "iconUrl": {
                    "type": "string"
                }
            },
            "required": [
                "canonicalName",
                "count",
                "creationDate",
                "criteriaMeta",
                "description",
                "iconUrl",
                "id",
                "isPremium",
                "lastUpdated",
                "predefinedScr",
                "quotes",
                "rawCriteria",
                "start",
                "title",
                "total",
                "useRecords",
                "versionId"
            ],
            "additionalProperties": false
        },
        "ScreenerResultHighYieldBond": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "canonicalName": {
                    "type": "string",
                    "const": "HIGH_YIELD_BOND"
                },
                "criteriaMeta": {
                    "type": "object",
                    "additionalProperties": false,
                    "properties": {
                        "includeFields": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/ScreenerCriteriaFieldsFund"
                            }
                        },
                        "size": {
                            "type": "number"
                        },
                        "offset": {
                            "type": "number"
                        },
                        "sortField": {
                            "type": "string"
                        },
                        "sortType": {
                            "type": "string"
                        },
                        "quoteType": {
                            "type": "string"
                        },
                        "criteria": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/ScreenerCriterum"
                            }
                        },
                        "topOperator": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "criteria",
                        "includeFields",
                        "offset",
                        "quoteType",
                        "size",
                        "sortField",
                        "sortType",
                        "topOperator"
                    ]
                },
                "rawCriteria": {
                    "type": "string"
                },
                "start": {
                    "type": "number"
                },
                "count": {
                    "type": "number"
                },
                "total": {
                    "type": "number"
                },
                "quotes": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/ScreenerQuote"
                    }
                },
                "useRecords": {
                    "type": "boolean"
                },
                "predefinedScr": {
                    "type": "boolean"
                },
                "versionId": {
                    "type": "number"
                },
                "creationDate": {
                    "type": "number"
                },
                "lastUpdated": {
                    "type": "number"
                },
                "isPremium": {
                    "type": "boolean"
                },
                "iconUrl": {
                    "type": "string"
                }
            },
            "required": [
                "canonicalName",
                "count",
                "creationDate",
                "criteriaMeta",
                "description",
                "iconUrl",
                "id",
                "isPremium",
                "lastUpdated",
                "predefinedScr",
                "quotes",
                "rawCriteria",
                "start",
                "title",
                "total",
                "useRecords",
                "versionId"
            ],
            "additionalProperties": false
        },
        "ScreenerResultMostShortedStocks": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "canonicalName": {
                    "type": "string",
                    "const": "MOST_SHORTED_STOCKS"
                },
                "criteriaMeta": {
                    "type": "object",
                    "additionalProperties": false,
                    "properties": {
                        "includeFields": {
                            "type": "array",
                            "items": {
                                "type": "string",
                                "enum": [
                                    "change_in_number_of_institutional_holders",
                                    "trading_central_last_close_price_to_fair_value",
                                    "intradaypricechange",
                                    "estimated_revenue_growth",
                                    "intradaymarketcap",
                                    "morningstar_previous_rating",
                                    "fiftytwowkhigh",
                                    "fiftytwowkpercentchange",
                                    "pctheldinst",
                                    "morningstar_last_close_price_to_fair_value",
                                    "shares_bought_by_funds",
                                    "ror_percent",
                                    "morningstar_rating",
                                    "sector",
                                    "peratio.lasttwelvemonths",
                                    "bullish_proportion",
                                    "percent_change_in_number_of_institutional_holders",
                                    "number_of_institutional_sellers",
                                    "morningstar_stewardship",
                                    "lastclosetevebit.lasttwelvemonths",
                                    "percentchange",
                                    "morningstar_economic_moat",
                                    "percent_of_shares_outstanding_bought_by_institutions",
                                    "day_open_price",
                                    "morningstar_rating_change",
                                    "number_of_institutional_holders",
                                    "percent_in_funds_holding",
                                    "exchange",
                                    "percent_of_shares_outstanding_sold_by_institutions",
                                    "dayvolume",
                                    "bearish_proportion",
                                    "morningstar_fair_value",
                                    "sold_proportion",
                                    "industry",
                                    "morningstar_uncertainty",
                                    "shares_sold_by_funds",
                                    "fair_value",
                                    "bought_proportion",
                                    "percent_in_top_ten_holdings",
                                    "avgdailyvol3m",
                                    "last_close_price_to_nnwc_per_share",
                                    "estimated_earnings_growth",
                                    "ticker",
                                    "longname_us_en-us",
                                    "percent_change_in_shares_held_by_funds",
                                    "number_of_institutional_buyers",
                                    "companyshortname",
                                    "intradayprice",
                                    "change_in_shares_held_by_funds",
                                    "indices",
                                    "neutral_proportion",
                                    "latest_holdings_report_date",
                                    "fiftytwowklow",
                                    "value_description",
                                    "average_analyst_rating",
                                    "region",
                                    "epsgrowth.lasttwelvemonths",
                                    "quarterlyrevenuegrowth.quarterly",
                                    "pegratio_5y"
                                ]
                            }
                        },
                        "size": {
                            "type": "number"
                        },
                        "offset": {
                            "type": "number"
                        },
                        "sortField": {
                            "type": "string"
                        },
                        "sortType": {
                            "type": "string"
                        },
                        "quoteType": {
                            "type": "string"
                        },
                        "criteria": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/ScreenerCriterum"
                            }
                        },
                        "topOperator": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "criteria",
                        "includeFields",
                        "offset",
                        "quoteType",
                        "size",
                        "sortField",
                        "sortType",
                        "topOperator"
                    ]
                },
                "rawCriteria": {
                    "type": "string"
                },
                "start": {
                    "type": "number"
                },
                "count": {
                    "type": "number"
                },
                "total": {
                    "type": "number"
                },
                "quotes": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/ScreenerQuote"
                    }
                },
                "useRecords": {
                    "type": "boolean"
                },
                "predefinedScr": {
                    "type": "boolean"
                },
                "versionId": {
                    "type": "number"
                },
                "creationDate": {
                    "type": "number"
                },
                "lastUpdated": {
                    "type": "number"
                },
                "isPremium": {
                    "type": "boolean"
                },
                "iconUrl": {
                    "type": "string"
                }
            },
            "required": [
                "canonicalName",
                "count",
                "creationDate",
                "criteriaMeta",
                "description",
                "iconUrl",
                "id",
                "isPremium",
                "lastUpdated",
                "predefinedScr",
                "quotes",
                "rawCriteria",
                "start",
                "title",
                "total",
                "useRecords",
                "versionId"
            ],
            "additionalProperties": false
        },
        "ScreenerResultPortfolioAnchors": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "canonicalName": {
                    "type": "string",
                    "const": "PORTFOLIO_ANCHORS"
                },
                "criteriaMeta": {
                    "type": "object",
                    "additionalProperties": false,
                    "properties": {
                        "includeFields": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/ScreenerCriteriaFieldsFund"
                            }
                        },
                        "size": {
                            "type": "number"
                        },
                        "offset": {
                            "type": "number"
                        },
                        "sortField": {
                            "type": "string"
                        },
                        "sortType": {
                            "type": "string"
                        },
                        "quoteType": {
                            "type": "string"
                        },
                        "criteria": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/ScreenerCriterum"
                            }
                        },
                        "topOperator": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "criteria",
                        "includeFields",
                        "offset",
                        "quoteType",
                        "size",
                        "sortField",
                        "sortType",
                        "topOperator"
                    ]
                },
                "rawCriteria": {
                    "type": "string"
                },
                "start": {
                    "type": "number"
                },
                "count": {
                    "type": "number"
                },
                "total": {
                    "type": "number"
                },
                "quotes": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/ScreenerQuote"
                    }
                },
                "useRecords": {
                    "type": "boolean"
                },
                "predefinedScr": {
                    "type": "boolean"
                },
                "versionId": {
                    "type": "number"
                },
                "creationDate": {
                    "type": "number"
                },
                "lastUpdated": {
                    "type": "number"
                },
                "isPremium": {
                    "type": "boolean"
                },
                "iconUrl": {
                    "type": "string"
                }
            },
            "required": [
                "canonicalName",
                "count",
                "creationDate",
                "criteriaMeta",
                "description",
                "iconUrl",
                "id",
                "isPremium",
                "lastUpdated",
                "predefinedScr",
                "quotes",
                "rawCriteria",
                "start",
                "title",
                "total",
                "useRecords",
                "versionId"
            ],
            "additionalProperties": false
        },
        "ScreenerResultSmallCapGainers": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "canonicalName": {
                    "type": "string",
                    "const": "SMALL_CAP_GAINERS"
                },
                "criteriaMeta": {
                    "type": "object",
                    "additionalProperties": false,
                    "properties": {
                        "includeFields": {
                            "type": "array",
                            "items": {
                                "type": "string",
                                "enum": [
                                    "change_in_number_of_institutional_holders",
                                    "trading_central_last_close_price_to_fair_value",
                                    "intradaypricechange",
                                    "estimated_revenue_growth",
                                    "intradaymarketcap",
                                    "morningstar_previous_rating",
                                    "fiftytwowkhigh",
                                    "fiftytwowkpercentchange",
                                    "pctheldinst",
                                    "morningstar_last_close_price_to_fair_value",
                                    "shares_bought_by_funds",
                                    "ror_percent",
                                    "morningstar_rating",
                                    "sector",
                                    "peratio.lasttwelvemonths",
                                    "bullish_proportion",
                                    "percent_change_in_number_of_institutional_holders",
                                    "number_of_institutional_sellers",
                                    "morningstar_stewardship",
                                    "lastclosetevebit.lasttwelvemonths",
                                    "percentchange",
                                    "morningstar_economic_moat",
                                    "percent_of_shares_outstanding_bought_by_institutions",
                                    "day_open_price",
                                    "morningstar_rating_change",
                                    "number_of_institutional_holders",
                                    "percent_in_funds_holding",
                                    "exchange",
                                    "percent_of_shares_outstanding_sold_by_institutions",
                                    "dayvolume",
                                    "bearish_proportion",
                                    "morningstar_fair_value",
                                    "sold_proportion",
                                    "industry",
                                    "morningstar_uncertainty",
                                    "shares_sold_by_funds",
                                    "fair_value",
                                    "bought_proportion",
                                    "percent_in_top_ten_holdings",
                                    "avgdailyvol3m",
                                    "last_close_price_to_nnwc_per_share",
                                    "estimated_earnings_growth",
                                    "ticker",
                                    "longname_us_en-us",
                                    "percent_change_in_shares_held_by_funds",
                                    "number_of_institutional_buyers",
                                    "companyshortname",
                                    "intradayprice",
                                    "change_in_shares_held_by_funds",
                                    "indices",
                                    "neutral_proportion",
                                    "latest_holdings_report_date",
                                    "fiftytwowklow",
                                    "value_description",
                                    "average_analyst_rating",
                                    "region",
                                    "epsgrowth.lasttwelvemonths",
                                    "quarterlyrevenuegrowth.quarterly",
                                    "pegratio_5y"
                                ]
                            }
                        },
                        "size": {
                            "type": "number"
                        },
                        "offset": {
                            "type": "number"
                        },
                        "sortField": {
                            "type": "string"
                        },
                        "sortType": {
                            "type": "string"
                        },
                        "quoteType": {
                            "type": "string"
                        },
                        "criteria": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/ScreenerCriterum"
                            }
                        },
                        "topOperator": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "criteria",
                        "includeFields",
                        "offset",
                        "quoteType",
                        "size",
                        "sortField",
                        "sortType",
                        "topOperator"
                    ]
                },
                "rawCriteria": {
                    "type": "string"
                },
                "start": {
                    "type": "number"
                },
                "count": {
                    "type": "number"
                },
                "total": {
                    "type": "number"
                },
                "quotes": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/ScreenerQuote"
                    }
                },
                "useRecords": {
                    "type": "boolean"
                },
                "predefinedScr": {
                    "type": "boolean"
                },
                "versionId": {
                    "type": "number"
                },
                "creationDate": {
                    "type": "number"
                },
                "lastUpdated": {
                    "type": "number"
                },
                "isPremium": {
                    "type": "boolean"
                },
                "iconUrl": {
                    "type": "string"
                }
            },
            "required": [
                "canonicalName",
                "count",
                "creationDate",
                "criteriaMeta",
                "description",
                "iconUrl",
                "id",
                "isPremium",
                "lastUpdated",
                "predefinedScr",
                "quotes",
                "rawCriteria",
                "start",
                "title",
                "total",
                "useRecords",
                "versionId"
            ],
            "additionalProperties": false
        },
        "ScreenerResultSolidLargeGrowthFunds": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "canonicalName": {
                    "type": "string",
                    "const": "SOLID_LARGE_GROWTH_FUNDS"
                },
                "criteriaMeta": {
                    "type": "object",
                    "additionalProperties": false,
                    "properties": {
                        "includeFields": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/ScreenerCriteriaFieldsFund"
                            }
                        },
                        "size": {
                            "type": "number"
                        },
                        "offset": {
                            "type": "number"
                        },
                        "sortField": {
                            "type": "string"
                        },
                        "sortType": {
                            "type": "string"
                        },
                        "quoteType": {
                            "type": "string"
                        },
                        "criteria": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/ScreenerCriterum"
                            }
                        },
                        "topOperator": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "criteria",
                        "includeFields",
                        "offset",
                        "quoteType",
                        "size",
                        "sortField",
                        "sortType",
                        "topOperator"
                    ]
                },
                "rawCriteria": {
                    "type": "string"
                },
                "start": {
                    "type": "number"
                },
                "count": {
                    "type": "number"
                },
                "total": {
                    "type": "number"
                },
                "quotes": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/ScreenerQuote"
                    }
                },
                "useRecords": {
                    "type": "boolean"
                },
                "predefinedScr": {
                    "type": "boolean"
                },
                "versionId": {
                    "type": "number"
                },
                "creationDate": {
                    "type": "number"
                },
                "lastUpdated": {
                    "type": "number"
                },
                "isPremium": {
                    "type": "boolean"
                },
                "iconUrl": {
                    "type": "string"
                }
            },
            "required": [
                "canonicalName",
                "count",
                "creationDate",
                "criteriaMeta",
                "description",
                "iconUrl",
                "id",
                "isPremium",
                "lastUpdated",
                "predefinedScr",
                "quotes",
                "rawCriteria",
                "start",
                "title",
                "total",
                "useRecords",
                "versionId"
            ],
            "additionalProperties": false
        },
        "ScreenerResultSolidMidcapGrowthFunds": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "canonicalName": {
                    "type": "string",
                    "const": "SOLID_MIDCAP_GROWTH_FUNDS"
                },
                "criteriaMeta": {
                    "type": "object",
                    "additionalProperties": false,
                    "properties": {
                        "includeFields": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/ScreenerCriteriaFieldsFund"
                            }
                        },
                        "size": {
                            "type": "number"
                        },
                        "offset": {
                            "type": "number"
                        },
                        "sortField": {
                            "type": "string"
                        },
                        "sortType": {
                            "type": "string"
                        },
                        "quoteType": {
                            "type": "string"
                        },
                        "criteria": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/ScreenerCriterum"
                            }
                        },
                        "topOperator": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "criteria",
                        "includeFields",
                        "offset",
                        "quoteType",
                        "size",
                        "sortField",
                        "sortType",
                        "topOperator"
                    ]
                },
                "rawCriteria": {
                    "type": "string"
                },
                "start": {
                    "type": "number"
                },
                "count": {
                    "type": "number"
                },
                "total": {
                    "type": "number"
                },
                "quotes": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/ScreenerQuote"
                    }
                },
                "useRecords": {
                    "type": "boolean"
                },
                "predefinedScr": {
                    "type": "boolean"
                },
                "versionId": {
                    "type": "number"
                },
                "creationDate": {
                    "type": "number"
                },
                "lastUpdated": {
                    "type": "number"
                },
                "isPremium": {
                    "type": "boolean"
                },
                "iconUrl": {
                    "type": "string"
                }
            },
            "required": [
                "canonicalName",
                "count",
                "creationDate",
                "criteriaMeta",
                "description",
                "iconUrl",
                "id",
                "isPremium",
                "lastUpdated",
                "predefinedScr",
                "quotes",
                "rawCriteria",
                "start",
                "title",
                "total",
                "useRecords",
                "versionId"
            ],
            "additionalProperties": false
        },
        "ScreenerResultTopMutualFunds": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "canonicalName": {
                    "type": "string",
                    "const": "TOP_MUTUAL_FUNDS"
                },
                "criteriaMeta": {
                    "type": "object",
                    "additionalProperties": false,
                    "properties": {
                        "includeFields": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/ScreenerCriteriaFieldsFund"
                            }
                        },
                        "size": {
                            "type": "number"
                        },
                        "offset": {
                            "type": "number"
                        },
                        "sortField": {
                            "type": "string"
                        },
                        "sortType": {
                            "type": "string"
                        },
                        "quoteType": {
                            "type": "string"
                        },
                        "criteria": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/ScreenerCriterum"
                            }
                        },
                        "topOperator": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "criteria",
                        "includeFields",
                        "offset",
                        "quoteType",
                        "size",
                        "sortField",
                        "sortType",
                        "topOperator"
                    ]
                },
                "rawCriteria": {
                    "type": "string"
                },
                "start": {
                    "type": "number"
                },
                "count": {
                    "type": "number"
                },
                "total": {
                    "type": "number"
                },
                "quotes": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/ScreenerQuote"
                    }
                },
                "useRecords": {
                    "type": "boolean"
                },
                "predefinedScr": {
                    "type": "boolean"
                },
                "versionId": {
                    "type": "number"
                },
                "creationDate": {
                    "type": "number"
                },
                "lastUpdated": {
                    "type": "number"
                },
                "isPremium": {
                    "type": "boolean"
                },
                "iconUrl": {
                    "type": "string"
                }
            },
            "required": [
                "canonicalName",
                "count",
                "creationDate",
                "criteriaMeta",
                "description",
                "iconUrl",
                "id",
                "isPremium",
                "lastUpdated",
                "predefinedScr",
                "quotes",
                "rawCriteria",
                "start",
                "title",
                "total",
                "useRecords",
                "versionId"
            ],
            "additionalProperties": false
        },
        "ScreenerResultUndervaluedGrowthStocks": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "canonicalName": {
                    "type": "string",
                    "const": "UNDERVALUED_GROWTH_STOCKS"
                },
                "criteriaMeta": {
                    "type": "object",
                    "additionalProperties": false,
                    "properties": {
                        "includeFields": {
                            "type": "array",
                            "items": {
                                "type": "string",
                                "enum": [
                                    "change_in_number_of_institutional_holders",
                                    "trading_central_last_close_price_to_fair_value",
                                    "intradaypricechange",
                                    "estimated_revenue_growth",
                                    "intradaymarketcap",
                                    "morningstar_previous_rating",
                                    "fiftytwowkhigh",
                                    "fiftytwowkpercentchange",
                                    "pctheldinst",
                                    "morningstar_last_close_price_to_fair_value",
                                    "shares_bought_by_funds",
                                    "ror_percent",
                                    "morningstar_rating",
                                    "sector",
                                    "peratio.lasttwelvemonths",
                                    "bullish_proportion",
                                    "percent_change_in_number_of_institutional_holders",
                                    "number_of_institutional_sellers",
                                    "morningstar_stewardship",
                                    "lastclosetevebit.lasttwelvemonths",
                                    "percentchange",
                                    "morningstar_economic_moat",
                                    "percent_of_shares_outstanding_bought_by_institutions",
                                    "day_open_price",
                                    "morningstar_rating_change",
                                    "number_of_institutional_holders",
                                    "percent_in_funds_holding",
                                    "exchange",
                                    "percent_of_shares_outstanding_sold_by_institutions",
                                    "dayvolume",
                                    "bearish_proportion",
                                    "morningstar_fair_value",
                                    "sold_proportion",
                                    "industry",
                                    "morningstar_uncertainty",
                                    "shares_sold_by_funds",
                                    "fair_value",
                                    "bought_proportion",
                                    "percent_in_top_ten_holdings",
                                    "avgdailyvol3m",
                                    "last_close_price_to_nnwc_per_share",
                                    "estimated_earnings_growth",
                                    "ticker",
                                    "longname_us_en-us",
                                    "percent_change_in_shares_held_by_funds",
                                    "number_of_institutional_buyers",
                                    "companyshortname",
                                    "intradayprice",
                                    "change_in_shares_held_by_funds",
                                    "indices",
                                    "neutral_proportion",
                                    "latest_holdings_report_date",
                                    "fiftytwowklow",
                                    "value_description",
                                    "average_analyst_rating",
                                    "region",
                                    "epsgrowth.lasttwelvemonths",
                                    "quarterlyrevenuegrowth.quarterly",
                                    "pegratio_5y"
                                ]
                            }
                        },
                        "size": {
                            "type": "number"
                        },
                        "offset": {
                            "type": "number"
                        },
                        "sortField": {
                            "type": "string"
                        },
                        "sortType": {
                            "type": "string"
                        },
                        "quoteType": {
                            "type": "string"
                        },
                        "criteria": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/ScreenerCriterum"
                            }
                        },
                        "topOperator": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "criteria",
                        "includeFields",
                        "offset",
                        "quoteType",
                        "size",
                        "sortField",
                        "sortType",
                        "topOperator"
                    ]
                },
                "rawCriteria": {
                    "type": "string"
                },
                "start": {
                    "type": "number"
                },
                "count": {
                    "type": "number"
                },
                "total": {
                    "type": "number"
                },
                "quotes": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/ScreenerQuote"
                    }
                },
                "useRecords": {
                    "type": "boolean"
                },
                "predefinedScr": {
                    "type": "boolean"
                },
                "versionId": {
                    "type": "number"
                },
                "creationDate": {
                    "type": "number"
                },
                "lastUpdated": {
                    "type": "number"
                },
                "isPremium": {
                    "type": "boolean"
                },
                "iconUrl": {
                    "type": "string"
                }
            },
            "required": [
                "canonicalName",
                "count",
                "creationDate",
                "criteriaMeta",
                "description",
                "iconUrl",
                "id",
                "isPremium",
                "lastUpdated",
                "predefinedScr",
                "quotes",
                "rawCriteria",
                "start",
                "title",
                "total",
                "useRecords",
                "versionId"
            ],
            "additionalProperties": false
        },
        "ScreenerResultUndervaluedLargeCaps": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "canonicalName": {
                    "type": "string",
                    "const": "UNDERVALUED_LARGE_CAPS"
                },
                "criteriaMeta": {
                    "type": "object",
                    "additionalProperties": false,
                    "properties": {
                        "includeFields": {
                            "type": "array",
                            "items": {
                                "type": "string",
                                "enum": [
                                    "change_in_number_of_institutional_holders",
                                    "trading_central_last_close_price_to_fair_value",
                                    "intradaypricechange",
                                    "estimated_revenue_growth",
                                    "intradaymarketcap",
                                    "morningstar_previous_rating",
                                    "fiftytwowkhigh",
                                    "fiftytwowkpercentchange",
                                    "pctheldinst",
                                    "morningstar_last_close_price_to_fair_value",
                                    "shares_bought_by_funds",
                                    "ror_percent",
                                    "morningstar_rating",
                                    "sector",
                                    "peratio.lasttwelvemonths",
                                    "bullish_proportion",
                                    "percent_change_in_number_of_institutional_holders",
                                    "number_of_institutional_sellers",
                                    "morningstar_stewardship",
                                    "lastclosetevebit.lasttwelvemonths",
                                    "percentchange",
                                    "morningstar_economic_moat",
                                    "percent_of_shares_outstanding_bought_by_institutions",
                                    "day_open_price",
                                    "morningstar_rating_change",
                                    "number_of_institutional_holders",
                                    "percent_in_funds_holding",
                                    "exchange",
                                    "percent_of_shares_outstanding_sold_by_institutions",
                                    "dayvolume",
                                    "bearish_proportion",
                                    "morningstar_fair_value",
                                    "sold_proportion",
                                    "industry",
                                    "morningstar_uncertainty",
                                    "shares_sold_by_funds",
                                    "fair_value",
                                    "bought_proportion",
                                    "percent_in_top_ten_holdings",
                                    "avgdailyvol3m",
                                    "last_close_price_to_nnwc_per_share",
                                    "estimated_earnings_growth",
                                    "ticker",
                                    "longname_us_en-us",
                                    "percent_change_in_shares_held_by_funds",
                                    "number_of_institutional_buyers",
                                    "companyshortname",
                                    "intradayprice",
                                    "change_in_shares_held_by_funds",
                                    "indices",
                                    "neutral_proportion",
                                    "latest_holdings_report_date",
                                    "fiftytwowklow",
                                    "value_description",
                                    "average_analyst_rating",
                                    "region",
                                    "epsgrowth.lasttwelvemonths",
                                    "quarterlyrevenuegrowth.quarterly",
                                    "pegratio_5y"
                                ]
                            }
                        },
                        "size": {
                            "type": "number"
                        },
                        "offset": {
                            "type": "number"
                        },
                        "sortField": {
                            "type": "string"
                        },
                        "sortType": {
                            "type": "string"
                        },
                        "quoteType": {
                            "type": "string"
                        },
                        "criteria": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/ScreenerCriterum"
                            }
                        },
                        "topOperator": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "criteria",
                        "includeFields",
                        "offset",
                        "quoteType",
                        "size",
                        "sortField",
                        "sortType",
                        "topOperator"
                    ]
                },
                "rawCriteria": {
                    "type": "string"
                },
                "start": {
                    "type": "number"
                },
                "count": {
                    "type": "number"
                },
                "total": {
                    "type": "number"
                },
                "quotes": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/ScreenerQuote"
                    }
                },
                "useRecords": {
                    "type": "boolean"
                },
                "predefinedScr": {
                    "type": "boolean"
                },
                "versionId": {
                    "type": "number"
                },
                "creationDate": {
                    "type": "number"
                },
                "lastUpdated": {
                    "type": "number"
                },
                "isPremium": {
                    "type": "boolean"
                },
                "iconUrl": {
                    "type": "string"
                }
            },
            "required": [
                "canonicalName",
                "count",
                "creationDate",
                "criteriaMeta",
                "description",
                "iconUrl",
                "id",
                "isPremium",
                "lastUpdated",
                "predefinedScr",
                "quotes",
                "rawCriteria",
                "start",
                "title",
                "total",
                "useRecords",
                "versionId"
            ],
            "additionalProperties": false
        },
        "ScreenerResult": {
            "type": "object",
            "discriminator": {
                "propertyName": "canonicalName"
            },
            "required": [
                "canonicalName"
            ],
            "oneOf": [
                {
                    "$ref": "#/definitions/ScreenerResultAggressiveSmallCaps"
                },
                {
                    "$ref": "#/definitions/ScreenerResultConservativeForeignFunds"
                },
                {
                    "$ref": "#/definitions/ScreenerResultDayGainers"
                },
                {
                    "$ref": "#/definitions/ScreenerResultDayLosers"
                },
                {
                    "$ref": "#/definitions/ScreenerResultGrowthTechnologyStocks"
                },
                {
                    "$ref": "#/definitions/ScreenerResultHighYieldBond"
                },
                {
                    "$ref": "#/definitions/ScreenerResultMostActives"
                },
                {
                    "$ref": "#/definitions/ScreenerResultMostShortedStocks"
                },
                {
                    "$ref": "#/definitions/ScreenerResultPortfolioAnchors"
                },
                {
                    "$ref": "#/definitions/ScreenerResultSmallCapGainers"
                },
                {
                    "$ref": "#/definitions/ScreenerResultSolidLargeGrowthFunds"
                },
                {
                    "$ref": "#/definitions/ScreenerResultSolidMidcapGrowthFunds"
                },
                {
                    "$ref": "#/definitions/ScreenerResultTopMutualFunds"
                },
                {
                    "$ref": "#/definitions/ScreenerResultUndervaluedGrowthStocks"
                },
                {
                    "$ref": "#/definitions/ScreenerResultUndervaluedLargeCaps"
                }
            ]
        },
        "PredefinedScreenerModules": {
            "type": "string",
            "enum": [
                "aggressive_small_caps",
                "conservative_foreign_funds",
                "day_gainers",
                "day_losers",
                "growth_technology_stocks",
                "high_yield_bond",
                "most_actives",
                "most_shorted_stocks",
                "portfolio_anchors",
                "small_cap_gainers",
                "solid_large_growth_funds",
                "solid_midcap_growth_funds",
                "top_mutual_funds",
                "undervalued_growth_stocks",
                "undervalued_large_caps"
            ]
        },
        "ScreenerOptions": {
            "type": "object",
            "properties": {
                "lang": {
                    "type": "string"
                },
                "region": {
                    "type": "string"
                },
                "scrIds": {
                    "$ref": "#/definitions/PredefinedScreenerModules"
                },
                "count": {
                    "type": "number"
                }
            },
            "required": [
                "scrIds"
            ],
            "additionalProperties": false
        },
        "screener": {}
    }
};
