export default {
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$comment": "DO NOT EDIT THIS FILE.  It is generated automatically from typescript interfaces in the project.  To update, run `deno task schema` (with optional `--watch`).  In VSCode, this is run automatically for you on folder open.",
    "definitions": {
        "QuoteSummaryResult": {
            "type": "object",
            "properties": {
                "assetProfile": {
                    "$ref": "#/definitions/AssetProfile"
                },
                "balanceSheetHistory": {
                    "$ref": "#/definitions/BalanceSheetHistory"
                },
                "balanceSheetHistoryQuarterly": {
                    "$ref": "#/definitions/BalanceSheetHistory"
                },
                "calendarEvents": {
                    "$ref": "#/definitions/CalendarEvents"
                },
                "cashflowStatementHistory": {
                    "$ref": "#/definitions/CashflowStatementHistory"
                },
                "cashflowStatementHistoryQuarterly": {
                    "$ref": "#/definitions/CashflowStatementHistory"
                },
                "defaultKeyStatistics": {
                    "$ref": "#/definitions/DefaultKeyStatistics"
                },
                "earnings": {
                    "$ref": "#/definitions/QuoteSummaryEarnings"
                },
                "earningsHistory": {
                    "$ref": "#/definitions/EarningsHistory"
                },
                "earningsTrend": {
                    "$ref": "#/definitions/EarningsTrend"
                },
                "financialData": {
                    "$ref": "#/definitions/FinancialData"
                },
                "fundOwnership": {
                    "$ref": "#/definitions/Ownership"
                },
                "fundPerformance": {
                    "$ref": "#/definitions/FundPerformance"
                },
                "fundProfile": {
                    "$ref": "#/definitions/FundProfile"
                },
                "incomeStatementHistory": {
                    "$ref": "#/definitions/IncomeStatementHistory"
                },
                "incomeStatementHistoryQuarterly": {
                    "$ref": "#/definitions/IncomeStatementHistory"
                },
                "indexTrend": {
                    "$ref": "#/definitions/IndexTrend"
                },
                "industryTrend": {
                    "$ref": "#/definitions/Trend"
                },
                "insiderHolders": {
                    "$ref": "#/definitions/Holders"
                },
                "insiderTransactions": {
                    "$ref": "#/definitions/InsiderTransactions"
                },
                "institutionOwnership": {
                    "$ref": "#/definitions/Ownership"
                },
                "majorDirectHolders": {
                    "$ref": "#/definitions/Holders"
                },
                "majorHoldersBreakdown": {
                    "$ref": "#/definitions/MajorHoldersBreakdown"
                },
                "netSharePurchaseActivity": {
                    "$ref": "#/definitions/NetSharePurchaseActivity"
                },
                "price": {
                    "$ref": "#/definitions/Price"
                },
                "quoteType": {
                    "$ref": "#/definitions/QuoteType"
                },
                "recommendationTrend": {
                    "$ref": "#/definitions/RecommendationTrend"
                },
                "secFilings": {
                    "$ref": "#/definitions/SECFilings"
                },
                "sectorTrend": {
                    "$ref": "#/definitions/Trend"
                },
                "summaryDetail": {
                    "$ref": "#/definitions/SummaryDetail"
                },
                "summaryProfile": {
                    "$ref": "#/definitions/SummaryProfile"
                },
                "topHoldings": {
                    "$ref": "#/definitions/TopHoldings"
                },
                "upgradeDowngradeHistory": {
                    "$ref": "#/definitions/UpgradeDowngradeHistory"
                }
            },
            "additionalProperties": {}
        },
        "AssetProfile": {
            "type": "object",
            "properties": {
                "maxAge": {
                    "type": "number"
                },
                "address1": {
                    "type": "string"
                },
                "address2": {
                    "type": "string"
                },
                "address3": {
                    "type": "string"
                },
                "city": {
                    "type": "string"
                },
                "state": {
                    "type": "string"
                },
                "zip": {
                    "type": "string"
                },
                "country": {
                    "type": "string"
                },
                "phone": {
                    "type": "string"
                },
                "fax": {
                    "type": "string"
                },
                "website": {
                    "type": "string"
                },
                "industry": {
                    "type": "string"
                },
                "industryDisp": {
                    "type": "string"
                },
                "industryKey": {
                    "type": "string"
                },
                "industrySymbol": {
                    "type": "string"
                },
                "sector": {
                    "type": "string"
                },
                "sectorDisp": {
                    "type": "string"
                },
                "sectorKey": {
                    "type": "string"
                },
                "longBusinessSummary": {
                    "type": "string"
                },
                "fullTimeEmployees": {
                    "type": "number"
                },
                "companyOfficers": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/CompanyOfficer"
                    }
                },
                "auditRisk": {
                    "type": "number"
                },
                "boardRisk": {
                    "type": "number"
                },
                "compensationRisk": {
                    "type": "number"
                },
                "shareHolderRightsRisk": {
                    "type": "number"
                },
                "overallRisk": {
                    "type": "number"
                },
                "governanceEpochDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "compensationAsOfEpochDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "name": {
                    "type": "string"
                },
                "startDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "description": {
                    "type": "string"
                },
                "twitter": {
                    "type": "string"
                },
                "irWebsite": {
                    "type": "string"
                },
                "executiveTeam": {
                    "type": "array",
                    "items": {}
                }
            },
            "required": [
                "maxAge",
                "companyOfficers"
            ],
            "additionalProperties": {}
        },
        "CompanyOfficer": {
            "type": "object",
            "properties": {
                "maxAge": {
                    "type": "number"
                },
                "name": {
                    "type": "string"
                },
                "age": {
                    "type": "number"
                },
                "title": {
                    "type": "string"
                },
                "yearBorn": {
                    "type": "number"
                },
                "fiscalYear": {
                    "type": "number"
                },
                "totalPay": {
                    "type": "number"
                },
                "exercisedValue": {
                    "type": "number"
                },
                "unexercisedValue": {
                    "type": "number"
                }
            },
            "required": [
                "maxAge",
                "name",
                "title"
            ],
            "additionalProperties": {}
        },
        "BalanceSheetHistory": {
            "type": "object",
            "properties": {
                "balanceSheetStatements": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/BalanceSheetStatement"
                    }
                },
                "maxAge": {
                    "type": "number"
                }
            },
            "required": [
                "balanceSheetStatements",
                "maxAge"
            ],
            "additionalProperties": {}
        },
        "BalanceSheetStatement": {
            "type": "object",
            "properties": {
                "maxAge": {
                    "type": "number"
                },
                "endDate": {
                    "type": "string",
                    "format": "date-time"
                }
            },
            "required": [
                "maxAge",
                "endDate"
            ],
            "additionalProperties": false
        },
        "CalendarEvents": {
            "type": "object",
            "properties": {
                "maxAge": {
                    "type": "number"
                },
                "earnings": {
                    "$ref": "#/definitions/CalendarEventsEarnings"
                },
                "exDividendDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "dividendDate": {
                    "type": "string",
                    "format": "date-time"
                }
            },
            "required": [
                "maxAge",
                "earnings"
            ],
            "additionalProperties": {}
        },
        "CalendarEventsEarnings": {
            "type": "object",
            "properties": {
                "earningsCallDate": {
                    "type": "array",
                    "items": {
                        "type": "string",
                        "format": "date-time"
                    }
                },
                "isEarningsDateEstimate": {
                    "type": "boolean"
                },
                "earningsDate": {
                    "type": "array",
                    "items": {
                        "type": "string",
                        "format": "date-time"
                    }
                },
                "earningsAverage": {
                    "type": "number"
                },
                "earningsLow": {
                    "type": "number"
                },
                "earningsHigh": {
                    "type": "number"
                },
                "revenueAverage": {
                    "type": "number"
                },
                "revenueLow": {
                    "type": "number"
                },
                "revenueHigh": {
                    "type": "number"
                }
            },
            "required": [
                "earningsCallDate",
                "earningsDate"
            ],
            "additionalProperties": {}
        },
        "CashflowStatementHistory": {
            "type": "object",
            "properties": {
                "cashflowStatements": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/CashflowStatement"
                    }
                },
                "maxAge": {
                    "type": "number"
                }
            },
            "required": [
                "cashflowStatements",
                "maxAge"
            ],
            "additionalProperties": false
        },
        "CashflowStatement": {
            "type": "object",
            "properties": {
                "maxAge": {
                    "type": "number"
                },
                "endDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "netIncome": {
                    "type": "number"
                }
            },
            "required": [
                "maxAge",
                "endDate",
                "netIncome"
            ],
            "additionalProperties": false
        },
        "DefaultKeyStatistics": {
            "type": "object",
            "properties": {
                "maxAge": {
                    "type": "number"
                },
                "priceHint": {
                    "type": "number"
                },
                "enterpriseValue": {
                    "type": "number"
                },
                "forwardPE": {
                    "type": "number"
                },
                "profitMargins": {
                    "type": "number"
                },
                "floatShares": {
                    "type": "number"
                },
                "sharesOutstanding": {
                    "type": "number"
                },
                "sharesShort": {
                    "type": "number"
                },
                "sharesShortPriorMonth": {
                    "type": "string",
                    "format": "date-time"
                },
                "sharesShortPreviousMonthDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "dateShortInterest": {
                    "type": "string",
                    "format": "date-time"
                },
                "sharesPercentSharesOut": {
                    "type": "number"
                },
                "heldPercentInsiders": {
                    "type": "number"
                },
                "heldPercentInstitutions": {
                    "type": "number"
                },
                "shortRatio": {
                    "type": "number"
                },
                "shortPercentOfFloat": {
                    "type": "number"
                },
                "beta": {
                    "type": "number"
                },
                "impliedSharesOutstanding": {
                    "type": "number"
                },
                "category": {
                    "type": [
                        "null",
                        "string"
                    ]
                },
                "bookValue": {
                    "type": "number"
                },
                "priceToBook": {
                    "type": "number"
                },
                "fundFamily": {
                    "type": [
                        "null",
                        "string"
                    ]
                },
                "legalType": {
                    "type": [
                        "null",
                        "string"
                    ]
                },
                "lastFiscalYearEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "nextFiscalYearEnd": {
                    "type": "string",
                    "format": "date-time"
                },
                "mostRecentQuarter": {
                    "type": "string",
                    "format": "date-time"
                },
                "earningsQuarterlyGrowth": {
                    "type": "number"
                },
                "netIncomeToCommon": {
                    "type": "number"
                },
                "trailingEps": {
                    "type": "number"
                },
                "forwardEps": {
                    "type": "number"
                },
                "pegRatio": {
                    "type": "number"
                },
                "lastSplitFactor": {
                    "type": [
                        "null",
                        "string"
                    ]
                },
                "lastSplitDate": {
                    "type": "number"
                },
                "enterpriseToRevenue": {
                    "type": "number"
                },
                "enterpriseToEbitda": {
                    "type": "number"
                },
                "52WeekChange": {
                    "type": "number"
                },
                "SandP52WeekChange": {
                    "type": "number"
                },
                "lastDividendValue": {
                    "type": "number"
                },
                "lastDividendDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "ytdReturn": {
                    "type": "number"
                },
                "beta3Year": {
                    "type": "number"
                },
                "totalAssets": {
                    "type": "number"
                },
                "yield": {
                    "type": "number"
                },
                "fundInceptionDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "threeYearAverageReturn": {
                    "type": "number"
                },
                "fiveYearAverageReturn": {
                    "type": "number"
                },
                "morningStarOverallRating": {
                    "type": "number"
                },
                "morningStarRiskRating": {
                    "type": "number"
                },
                "annualReportExpenseRatio": {
                    "type": "number"
                },
                "lastCapGain": {
                    "type": "number"
                },
                "annualHoldingsTurnover": {
                    "type": "number"
                },
                "latestShareClass": {},
                "leadInvestor": {}
            },
            "required": [
                "maxAge",
                "priceHint",
                "category",
                "fundFamily",
                "legalType",
                "lastSplitFactor"
            ],
            "additionalProperties": {}
        },
        "QuoteSummaryEarnings": {
            "type": "object",
            "properties": {
                "maxAge": {
                    "type": "number"
                },
                "earningsChart": {
                    "$ref": "#/definitions/EarningsChart"
                },
                "financialsChart": {
                    "$ref": "#/definitions/FinancialsChart"
                },
                "financialCurrency": {
                    "type": "string"
                }
            },
            "required": [
                "maxAge",
                "earningsChart",
                "financialsChart"
            ],
            "additionalProperties": {}
        },
        "EarningsChart": {
            "type": "object",
            "properties": {
                "quarterly": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/EarningsChartQuarterly"
                    }
                },
                "currentQuarterEstimate": {
                    "type": "number"
                },
                "currentQuarterEstimateDate": {
                    "type": "string"
                },
                "currentQuarterEstimateYear": {
                    "type": "number"
                },
                "earningsDate": {
                    "type": "array",
                    "items": {
                        "type": "string",
                        "format": "date-time"
                    }
                },
                "isEarningsDateEstimate": {
                    "type": "boolean"
                }
            },
            "required": [
                "quarterly",
                "earningsDate"
            ],
            "additionalProperties": {}
        },
        "EarningsChartQuarterly": {
            "type": "object",
            "properties": {
                "date": {
                    "type": "string"
                },
                "actual": {
                    "type": "number"
                },
                "estimate": {
                    "type": "number"
                }
            },
            "required": [
                "date",
                "estimate"
            ],
            "additionalProperties": {}
        },
        "FinancialsChart": {
            "type": "object",
            "properties": {
                "yearly": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/Yearly"
                    }
                },
                "quarterly": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/FinancialsChartQuarterly"
                    }
                }
            },
            "required": [
                "yearly",
                "quarterly"
            ],
            "additionalProperties": {}
        },
        "Yearly": {
            "type": "object",
            "properties": {
                "date": {
                    "type": "number"
                },
                "revenue": {
                    "type": "number"
                },
                "earnings": {
                    "type": "number"
                }
            },
            "required": [
                "date",
                "revenue",
                "earnings"
            ],
            "additionalProperties": {}
        },
        "FinancialsChartQuarterly": {
            "type": "object",
            "properties": {
                "date": {
                    "type": "string"
                },
                "revenue": {
                    "type": "number"
                },
                "earnings": {
                    "type": "number"
                }
            },
            "required": [
                "date",
                "revenue",
                "earnings"
            ],
            "additionalProperties": {}
        },
        "EarningsHistory": {
            "type": "object",
            "properties": {
                "history": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/EarningsHistoryHistory"
                    }
                },
                "maxAge": {
                    "type": "number"
                }
            },
            "required": [
                "history",
                "maxAge"
            ],
            "additionalProperties": {}
        },
        "EarningsHistoryHistory": {
            "type": "object",
            "properties": {
                "maxAge": {
                    "type": "number"
                },
                "epsActual": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "epsEstimate": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "epsDifference": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "surprisePercent": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "quarter": {
                    "anyOf": [
                        {
                            "type": "string",
                            "format": "date-time"
                        },
                        {
                            "type": "null"
                        }
                    ]
                },
                "period": {
                    "type": "string"
                },
                "currency": {
                    "type": "string"
                }
            },
            "required": [
                "maxAge",
                "epsActual",
                "epsEstimate",
                "epsDifference",
                "surprisePercent",
                "quarter",
                "period"
            ],
            "additionalProperties": {}
        },
        "EarningsTrend": {
            "type": "object",
            "properties": {
                "trend": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/EarningsTrendTrend"
                    }
                },
                "maxAge": {
                    "type": "number"
                }
            },
            "required": [
                "trend",
                "maxAge"
            ],
            "additionalProperties": {}
        },
        "EarningsTrendTrend": {
            "type": "object",
            "properties": {
                "maxAge": {
                    "type": "number"
                },
                "period": {
                    "type": "string"
                },
                "endDate": {
                    "anyOf": [
                        {
                            "type": "string",
                            "format": "date-time"
                        },
                        {
                            "type": "null"
                        }
                    ]
                },
                "growth": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "earningsEstimate": {
                    "$ref": "#/definitions/EarningsEstimate"
                },
                "revenueEstimate": {
                    "$ref": "#/definitions/RevenueEstimate"
                },
                "epsTrend": {
                    "$ref": "#/definitions/EpsTrend"
                },
                "epsRevisions": {
                    "$ref": "#/definitions/EpsRevisions"
                }
            },
            "required": [
                "maxAge",
                "period",
                "endDate",
                "growth",
                "earningsEstimate",
                "revenueEstimate",
                "epsTrend",
                "epsRevisions"
            ],
            "additionalProperties": {}
        },
        "EarningsEstimate": {
            "type": "object",
            "properties": {
                "avg": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "low": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "high": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "yearAgoEps": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "numberOfAnalysts": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "growth": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "earningsCurrency": {
                    "type": [
                        "string",
                        "null"
                    ]
                }
            },
            "required": [
                "avg",
                "low",
                "high",
                "yearAgoEps",
                "numberOfAnalysts",
                "growth"
            ],
            "additionalProperties": {}
        },
        "RevenueEstimate": {
            "type": "object",
            "properties": {
                "avg": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "low": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "high": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "numberOfAnalysts": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "yearAgoRevenue": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "growth": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "revenueCurrency": {
                    "type": [
                        "string",
                        "null"
                    ]
                }
            },
            "required": [
                "avg",
                "low",
                "high",
                "numberOfAnalysts",
                "yearAgoRevenue",
                "growth"
            ],
            "additionalProperties": {}
        },
        "EpsTrend": {
            "type": "object",
            "properties": {
                "current": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "7daysAgo": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "30daysAgo": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "60daysAgo": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "90daysAgo": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "epsTrendCurrency": {
                    "type": [
                        "string",
                        "null"
                    ]
                }
            },
            "required": [
                "current",
                "7daysAgo",
                "30daysAgo",
                "60daysAgo",
                "90daysAgo"
            ],
            "additionalProperties": {}
        },
        "EpsRevisions": {
            "type": "object",
            "properties": {
                "upLast7days": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "upLast30days": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "upLast90days": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "downLast7Days": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "downLast30days": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "downLast90days": {
                    "type": [
                        "number",
                        "null"
                    ]
                },
                "epsRevisionsCurrency": {
                    "type": [
                        "string",
                        "null"
                    ]
                }
            },
            "additionalProperties": {}
        },
        "FinancialData": {
            "type": "object",
            "properties": {
                "maxAge": {
                    "type": "number"
                },
                "currentPrice": {
                    "type": "number"
                },
                "targetHighPrice": {
                    "type": "number"
                },
                "targetLowPrice": {
                    "type": "number"
                },
                "targetMeanPrice": {
                    "type": "number"
                },
                "targetMedianPrice": {
                    "type": "number"
                },
                "recommendationMean": {
                    "type": "number"
                },
                "recommendationKey": {
                    "type": "string"
                },
                "numberOfAnalystOpinions": {
                    "type": "number"
                },
                "totalCash": {
                    "type": "number"
                },
                "totalCashPerShare": {
                    "type": "number"
                },
                "ebitda": {
                    "type": "number"
                },
                "totalDebt": {
                    "type": "number"
                },
                "quickRatio": {
                    "type": "number"
                },
                "currentRatio": {
                    "type": "number"
                },
                "totalRevenue": {
                    "type": "number"
                },
                "debtToEquity": {
                    "type": "number"
                },
                "revenuePerShare": {
                    "type": "number"
                },
                "returnOnAssets": {
                    "type": "number"
                },
                "returnOnEquity": {
                    "type": "number"
                },
                "grossProfits": {
                    "type": "number"
                },
                "freeCashflow": {
                    "type": "number"
                },
                "operatingCashflow": {
                    "type": "number"
                },
                "earningsGrowth": {
                    "type": "number"
                },
                "revenueGrowth": {
                    "type": "number"
                },
                "grossMargins": {
                    "type": "number"
                },
                "ebitdaMargins": {
                    "type": "number"
                },
                "operatingMargins": {
                    "type": "number"
                },
                "profitMargins": {
                    "type": "number"
                },
                "financialCurrency": {
                    "type": [
                        "string",
                        "null"
                    ]
                }
            },
            "required": [
                "maxAge",
                "recommendationKey",
                "financialCurrency"
            ],
            "additionalProperties": {}
        },
        "Ownership": {
            "type": "object",
            "properties": {
                "maxAge": {
                    "type": "number"
                },
                "ownershipList": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/OwnershipList"
                    }
                }
            },
            "required": [
                "maxAge",
                "ownershipList"
            ],
            "additionalProperties": {}
        },
        "OwnershipList": {
            "type": "object",
            "properties": {
                "maxAge": {
                    "type": "number"
                },
                "reportDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "organization": {
                    "type": "string"
                },
                "pctHeld": {
                    "type": "number"
                },
                "position": {
                    "type": "number"
                },
                "value": {
                    "type": "number"
                },
                "pctChange": {
                    "type": "number"
                }
            },
            "required": [
                "maxAge",
                "reportDate",
                "organization",
                "pctHeld",
                "position",
                "value"
            ],
            "additionalProperties": {}
        },
        "FundPerformance": {
            "type": "object",
            "properties": {
                "maxAge": {
                    "type": "number"
                },
                "loadAdjustedReturns": {
                    "$ref": "#/definitions/PeriodRange"
                },
                "rankInCategory": {
                    "$ref": "#/definitions/PeriodRange"
                },
                "performanceOverview": {
                    "$ref": "#/definitions/FundPerformancePerformanceOverview"
                },
                "performanceOverviewCat": {
                    "$ref": "#/definitions/FundPerformancePerformanceOverviewCat"
                },
                "trailingReturns": {
                    "$ref": "#/definitions/FundPerformanceTrailingReturns"
                },
                "trailingReturnsNav": {
                    "$ref": "#/definitions/FundPerformanceTrailingReturns"
                },
                "trailingReturnsCat": {
                    "$ref": "#/definitions/FundPerformanceTrailingReturns"
                },
                "annualTotalReturns": {
                    "$ref": "#/definitions/FundPerformanceReturns"
                },
                "pastQuarterlyReturns": {
                    "$ref": "#/definitions/FundPerformanceReturns"
                },
                "riskOverviewStatistics": {
                    "$ref": "#/definitions/FundPerformanceRiskOverviewStats"
                },
                "riskOverviewStatisticsCat": {
                    "$ref": "#/definitions/FundPerformanceRiskOverviewStatsCat"
                },
                "fundCategoryName": {
                    "type": "string"
                }
            },
            "required": [
                "maxAge",
                "performanceOverview",
                "performanceOverviewCat",
                "trailingReturns",
                "trailingReturnsNav",
                "trailingReturnsCat",
                "annualTotalReturns",
                "pastQuarterlyReturns",
                "riskOverviewStatistics",
                "riskOverviewStatisticsCat"
            ],
            "additionalProperties": {}
        },
        "PeriodRange": {
            "type": "object",
            "properties": {
                "asOfDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "ytd": {
                    "type": "number"
                },
                "oneMonth": {
                    "type": "number"
                },
                "threeMonth": {
                    "type": "number"
                },
                "oneYear": {
                    "type": "number"
                },
                "threeYear": {
                    "type": "number"
                },
                "fiveYear": {
                    "type": "number"
                },
                "tenYear": {
                    "type": "number"
                }
            },
            "additionalProperties": {}
        },
        "FundPerformancePerformanceOverview": {
            "type": "object",
            "properties": {
                "asOfDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "ytdReturnPct": {
                    "type": "number"
                },
                "oneYearTotalReturn": {
                    "type": "number"
                },
                "threeYearTotalReturn": {
                    "type": "number"
                },
                "fiveYrAvgReturnPct": {
                    "type": "number"
                },
                "morningStarReturnRating": {
                    "type": "number"
                },
                "numYearsUp": {
                    "type": "number"
                },
                "numYearsDown": {
                    "type": "number"
                },
                "bestOneYrTotalReturn": {
                    "type": "number"
                },
                "worstOneYrTotalReturn": {
                    "type": "number"
                },
                "bestThreeYrTotalReturn": {
                    "type": "number"
                },
                "worstThreeYrTotalReturn": {
                    "type": "number"
                }
            },
            "additionalProperties": {}
        },
        "FundPerformancePerformanceOverviewCat": {
            "type": "object",
            "properties": {
                "ytdReturnPct": {
                    "type": "number"
                },
                "fiveYrAvgReturnPct": {
                    "type": "number"
                },
                "oneYearTotalReturn": {
                    "type": "number"
                },
                "threeYearTotalReturn": {
                    "type": "number"
                }
            },
            "additionalProperties": {}
        },
        "FundPerformanceTrailingReturns": {
            "type": "object",
            "properties": {
                "asOfDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "ytd": {
                    "type": "number"
                },
                "oneMonth": {
                    "type": "number"
                },
                "threeMonth": {
                    "type": "number"
                },
                "oneYear": {
                    "type": "number"
                },
                "threeYear": {
                    "type": "number"
                },
                "fiveYear": {
                    "type": "number"
                },
                "tenYear": {
                    "type": "number"
                },
                "lastBullMkt": {
                    "type": "number"
                },
                "lastBearMkt": {
                    "type": "number"
                }
            },
            "additionalProperties": {
                "anyOf": [
                    {},
                    {}
                ]
            }
        },
        "FundPerformanceReturns": {
            "type": "object",
            "properties": {
                "returns": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/FundPerformanceReturnsRow"
                    }
                },
                "returnsCat": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/FundPerformanceReturnsRow"
                    }
                }
            },
            "required": [
                "returns"
            ],
            "additionalProperties": {}
        },
        "FundPerformanceReturnsRow": {
            "type": "object",
            "properties": {
                "year": {
                    "type": "number"
                },
                "annualValue": {
                    "type": "number"
                },
                "q1": {
                    "type": "number"
                },
                "q2": {
                    "type": "number"
                },
                "q3": {
                    "type": "number"
                },
                "q4": {
                    "type": "number"
                }
            },
            "required": [
                "year"
            ],
            "additionalProperties": {}
        },
        "FundPerformanceRiskOverviewStats": {
            "type": "object",
            "properties": {
                "riskStatistics": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/FundPerformanceRiskOverviewStatsRow"
                    }
                },
                "riskRating": {
                    "type": "number"
                }
            },
            "required": [
                "riskStatistics"
            ],
            "additionalProperties": {}
        },
        "FundPerformanceRiskOverviewStatsRow": {
            "type": "object",
            "properties": {
                "year": {
                    "type": "string"
                },
                "alpha": {
                    "type": "number"
                },
                "beta": {
                    "type": "number"
                },
                "meanAnnualReturn": {
                    "type": "number"
                },
                "rSquared": {
                    "type": "number"
                },
                "stdDev": {
                    "type": "number"
                },
                "sharpeRatio": {
                    "type": "number"
                },
                "treynorRatio": {
                    "type": "number"
                }
            },
            "required": [
                "year",
                "alpha",
                "beta",
                "meanAnnualReturn",
                "rSquared",
                "sharpeRatio",
                "treynorRatio"
            ],
            "additionalProperties": {}
        },
        "FundPerformanceRiskOverviewStatsCat": {
            "type": "object",
            "properties": {
                "riskStatisticsCat": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/FundPerformanceRiskOverviewStatsRow"
                    }
                }
            },
            "required": [
                "riskStatisticsCat"
            ],
            "additionalProperties": {}
        },
        "FundProfile": {
            "type": "object",
            "properties": {
                "maxAge": {
                    "type": "number"
                },
                "styleBoxUrl": {
                    "type": [
                        "null",
                        "string"
                    ]
                },
                "family": {
                    "type": [
                        "null",
                        "string"
                    ]
                },
                "categoryName": {
                    "type": [
                        "null",
                        "string"
                    ]
                },
                "legalType": {
                    "type": [
                        "null",
                        "string"
                    ]
                },
                "managementInfo": {
                    "$ref": "#/definitions/FundProfileManagementInfo"
                },
                "feesExpensesInvestment": {
                    "$ref": "#/definitions/FundProfileFeesExpensesInvestment"
                },
                "feesExpensesInvestmentCat": {
                    "$ref": "#/definitions/FundProfileFeesExpensesInvestmentCat"
                },
                "brokerages": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/FundProfileBrokerage"
                    }
                },
                "initInvestment": {
                    "type": "number"
                },
                "initIraInvestment": {
                    "type": "number"
                },
                "initAipInvestment": {
                    "type": "number"
                },
                "subseqInvestment": {
                    "type": "number"
                },
                "subseqIraInvestment": {
                    "type": "number"
                },
                "subseqAipInvestment": {
                    "type": "number"
                }
            },
            "required": [
                "maxAge",
                "family",
                "categoryName",
                "legalType"
            ],
            "additionalProperties": {}
        },
        "FundProfileManagementInfo": {
            "type": "object",
            "properties": {
                "managerName": {
                    "type": [
                        "null",
                        "string"
                    ]
                },
                "managerBio": {
                    "type": [
                        "null",
                        "string"
                    ]
                },
                "startdate": {
                    "type": "string",
                    "format": "date-time"
                }
            },
            "required": [
                "managerName",
                "managerBio"
            ],
            "additionalProperties": {}
        },
        "FundProfileFeesExpensesInvestment": {
            "type": "object",
            "properties": {
                "annualHoldingsTurnover": {
                    "type": "number"
                },
                "annualReportExpenseRatio": {
                    "type": "number"
                },
                "grossExpRatio": {
                    "type": "number"
                },
                "netExpRatio": {
                    "type": "number"
                },
                "projectionValues": {
                    "type": "object"
                },
                "totalNetAssets": {
                    "type": "number"
                }
            },
            "required": [
                "projectionValues"
            ],
            "additionalProperties": {}
        },
        "FundProfileFeesExpensesInvestmentCat": {
            "type": "object",
            "properties": {
                "annualHoldingsTurnover": {
                    "type": "number"
                },
                "annualReportExpenseRatio": {
                    "type": "number"
                },
                "grossExpRatio": {
                    "type": "number"
                },
                "netExpRatio": {
                    "type": "number"
                },
                "totalNetAssets": {
                    "type": "number"
                },
                "projectionValuesCat": {
                    "type": "object"
                }
            },
            "required": [
                "projectionValuesCat"
            ],
            "additionalProperties": {
                "anyOf": [
                    {},
                    {}
                ]
            }
        },
        "FundProfileBrokerage": {
            "type": "object",
            "additionalProperties": {}
        },
        "IncomeStatementHistory": {
            "type": "object",
            "properties": {
                "incomeStatementHistory": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/IncomeStatementHistoryElement"
                    }
                },
                "maxAge": {
                    "type": "number"
                }
            },
            "required": [
                "incomeStatementHistory",
                "maxAge"
            ],
            "additionalProperties": {}
        },
        "IncomeStatementHistoryElement": {
            "type": "object",
            "properties": {
                "maxAge": {
                    "type": "number"
                },
                "endDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "totalRevenue": {
                    "type": "number"
                },
                "costOfRevenue": {
                    "type": "number"
                },
                "grossProfit": {
                    "type": "number"
                },
                "researchDevelopment": {
                    "type": "null"
                },
                "sellingGeneralAdministrative": {
                    "type": "null"
                },
                "nonRecurring": {
                    "type": "null"
                },
                "otherOperatingExpenses": {
                    "type": "null"
                },
                "totalOperatingExpenses": {
                    "type": "number"
                },
                "operatingIncome": {
                    "type": "null"
                },
                "totalOtherIncomeExpenseNet": {
                    "type": "null"
                },
                "ebit": {
                    "type": "number"
                },
                "interestExpense": {
                    "type": "null"
                },
                "incomeBeforeTax": {
                    "type": "null"
                },
                "incomeTaxExpense": {
                    "type": "number"
                },
                "minorityInterest": {
                    "type": "null"
                },
                "netIncomeFromContinuingOps": {
                    "type": "null"
                },
                "discontinuedOperations": {
                    "type": "null"
                },
                "extraordinaryItems": {
                    "type": "null"
                },
                "effectOfAccountingCharges": {
                    "type": "null"
                },
                "otherItems": {
                    "type": "null"
                },
                "netIncome": {
                    "type": "number"
                },
                "netIncomeApplicableToCommonShares": {
                    "type": "null"
                }
            },
            "required": [
                "maxAge",
                "endDate",
                "totalRevenue",
                "costOfRevenue",
                "grossProfit",
                "researchDevelopment",
                "sellingGeneralAdministrative",
                "nonRecurring",
                "otherOperatingExpenses",
                "totalOperatingExpenses",
                "operatingIncome",
                "totalOtherIncomeExpenseNet",
                "ebit",
                "interestExpense",
                "incomeBeforeTax",
                "incomeTaxExpense",
                "minorityInterest",
                "netIncomeFromContinuingOps",
                "discontinuedOperations",
                "extraordinaryItems",
                "effectOfAccountingCharges",
                "otherItems",
                "netIncome",
                "netIncomeApplicableToCommonShares"
            ],
            "additionalProperties": false
        },
        "IndexTrend": {
            "type": "object",
            "properties": {
                "maxAge": {
                    "type": "number"
                },
                "symbol": {
                    "type": "string"
                },
                "peRatio": {
                    "type": "number"
                },
                "pegRatio": {
                    "type": "number"
                },
                "estimates": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/Estimate"
                    }
                }
            },
            "required": [
                "maxAge",
                "symbol",
                "estimates"
            ],
            "additionalProperties": {}
        },
        "Estimate": {
            "type": "object",
            "properties": {
                "period": {
                    "type": "string"
                },
                "growth": {
                    "type": "number"
                }
            },
            "required": [
                "period"
            ],
            "additionalProperties": {}
        },
        "Trend": {
            "type": "object",
            "properties": {
                "maxAge": {
                    "type": "number"
                },
                "symbol": {
                    "type": "null"
                },
                "estimates": {
                    "type": "array",
                    "items": {}
                }
            },
            "required": [
                "maxAge",
                "symbol",
                "estimates"
            ],
            "additionalProperties": {}
        },
        "Holders": {
            "type": "object",
            "properties": {
                "holders": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/Holder"
                    }
                },
                "maxAge": {
                    "type": "number"
                }
            },
            "required": [
                "holders",
                "maxAge"
            ],
            "additionalProperties": {}
        },
        "Holder": {
            "type": "object",
            "properties": {
                "maxAge": {
                    "type": "number"
                },
                "name": {
                    "type": "string"
                },
                "relation": {
                    "anyOf": [
                        {
                            "$ref": "#/definitions/Relation"
                        },
                        {
                            "type": "string"
                        }
                    ]
                },
                "url": {
                    "type": "string"
                },
                "transactionDescription": {
                    "type": "string"
                },
                "latestTransDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "positionDirect": {
                    "type": "number"
                },
                "positionDirectDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "positionIndirect": {
                    "type": "number"
                },
                "positionIndirectDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "positionSummaryDate": {
                    "type": "string",
                    "format": "date-time"
                }
            },
            "required": [
                "maxAge",
                "name",
                "relation",
                "url",
                "transactionDescription",
                "latestTransDate"
            ],
            "additionalProperties": {}
        },
        "Relation": {
            "type": "string",
            "enum": [
                "Chairman of the Board",
                "Chief Executive Officer",
                "Chief Financial Officer",
                "Chief Operating Officer",
                "Chief Technology Officer",
                "Director",
                "Director (Independent)",
                "",
                "General Counsel",
                "Independent Non-Executive Director",
                "Officer",
                "President"
            ]
        },
        "InsiderTransactions": {
            "type": "object",
            "properties": {
                "transactions": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/Transaction"
                    }
                },
                "maxAge": {
                    "type": "number"
                }
            },
            "required": [
                "transactions",
                "maxAge"
            ],
            "additionalProperties": {}
        },
        "Transaction": {
            "type": "object",
            "properties": {
                "maxAge": {
                    "type": "number"
                },
                "shares": {
                    "type": "number"
                },
                "filerUrl": {
                    "type": "string"
                },
                "transactionText": {
                    "type": "string"
                },
                "filerName": {
                    "type": "string"
                },
                "filerRelation": {
                    "anyOf": [
                        {
                            "$ref": "#/definitions/Relation"
                        },
                        {
                            "type": "string"
                        }
                    ]
                },
                "moneyText": {
                    "type": "string"
                },
                "startDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "ownership": {
                    "anyOf": [
                        {
                            "$ref": "#/definitions/OwnershipEnum"
                        },
                        {
                            "type": "string"
                        }
                    ]
                },
                "value": {
                    "type": "number"
                }
            },
            "required": [
                "maxAge",
                "shares",
                "filerUrl",
                "transactionText",
                "filerName",
                "filerRelation",
                "moneyText",
                "startDate",
                "ownership"
            ],
            "additionalProperties": {}
        },
        "OwnershipEnum": {
            "type": "string",
            "enum": [
                "D",
                "I"
            ]
        },
        "MajorHoldersBreakdown": {
            "type": "object",
            "properties": {
                "maxAge": {
                    "type": "number"
                },
                "insidersPercentHeld": {
                    "type": "number"
                },
                "institutionsPercentHeld": {
                    "type": "number"
                },
                "institutionsFloatPercentHeld": {
                    "type": "number"
                },
                "institutionsCount": {
                    "type": "number"
                }
            },
            "required": [
                "maxAge"
            ],
            "additionalProperties": {}
        },
        "NetSharePurchaseActivity": {
            "type": "object",
            "properties": {
                "maxAge": {
                    "type": "number"
                },
                "period": {
                    "type": "string"
                },
                "buyInfoCount": {
                    "type": "number"
                },
                "buyInfoShares": {
                    "type": "number"
                },
                "buyPercentInsiderShares": {
                    "type": "number"
                },
                "sellInfoCount": {
                    "type": "number"
                },
                "sellInfoShares": {
                    "type": "number"
                },
                "sellPercentInsiderShares": {
                    "type": "number"
                },
                "netInfoCount": {
                    "type": "number"
                },
                "netInfoShares": {
                    "type": "number"
                },
                "netPercentInsiderShares": {
                    "type": "number"
                },
                "totalInsiderShares": {
                    "type": "number"
                }
            },
            "required": [
                "maxAge",
                "period",
                "buyInfoCount",
                "buyInfoShares",
                "sellInfoCount",
                "netInfoCount",
                "netInfoShares",
                "totalInsiderShares"
            ],
            "additionalProperties": {}
        },
        "Price": {
            "type": "object",
            "properties": {
                "averageDailyVolume10Day": {
                    "type": "number"
                },
                "averageDailyVolume3Month": {
                    "type": "number"
                },
                "exchange": {
                    "type": "string"
                },
                "exchangeName": {
                    "type": "string"
                },
                "exchangeDataDelayedBy": {
                    "type": "number"
                },
                "maxAge": {
                    "type": "number"
                },
                "postMarketChangePercent": {
                    "type": "number"
                },
                "postMarketChange": {
                    "type": "number"
                },
                "postMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "postMarketPrice": {
                    "type": "number"
                },
                "postMarketSource": {
                    "type": "string"
                },
                "preMarketChangePercent": {
                    "type": "number"
                },
                "preMarketChange": {
                    "type": "number"
                },
                "preMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "preMarketPrice": {
                    "type": "number"
                },
                "preMarketSource": {
                    "type": "string"
                },
                "priceHint": {
                    "type": "number"
                },
                "regularMarketChangePercent": {
                    "type": "number"
                },
                "regularMarketChange": {
                    "type": "number"
                },
                "regularMarketTime": {
                    "type": "string",
                    "format": "date-time"
                },
                "regularMarketPrice": {
                    "type": "number"
                },
                "regularMarketDayHigh": {
                    "type": "number"
                },
                "regularMarketDayLow": {
                    "type": "number"
                },
                "regularMarketVolume": {
                    "type": "number"
                },
                "regularMarketPreviousClose": {
                    "type": "number"
                },
                "regularMarketSource": {
                    "type": "string"
                },
                "regularMarketOpen": {
                    "type": "number"
                },
                "quoteSourceName": {
                    "type": "string"
                },
                "quoteType": {
                    "type": "string"
                },
                "symbol": {
                    "type": "string"
                },
                "underlyingSymbol": {
                    "type": [
                        "null",
                        "string"
                    ]
                },
                "shortName": {
                    "type": [
                        "null",
                        "string"
                    ]
                },
                "longName": {
                    "type": [
                        "null",
                        "string"
                    ]
                },
                "lastMarket": {
                    "type": [
                        "null",
                        "string"
                    ]
                },
                "marketState": {
                    "type": "string"
                },
                "marketCap": {
                    "type": "number"
                },
                "currency": {
                    "type": "string"
                },
                "currencySymbol": {
                    "type": "string"
                },
                "fromCurrency": {
                    "type": [
                        "string",
                        "null"
                    ]
                },
                "toCurrency": {
                    "type": [
                        "string",
                        "null"
                    ]
                },
                "volume24Hr": {
                    "type": "number"
                },
                "volumeAllCurrencies": {
                    "type": "number"
                },
                "circulatingSupply": {
                    "type": "number"
                },
                "expireDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "openInterest": {
                    "type": "number"
                }
            },
            "required": [
                "maxAge",
                "priceHint",
                "quoteType",
                "symbol",
                "underlyingSymbol",
                "shortName",
                "longName",
                "lastMarket",
                "fromCurrency"
            ],
            "additionalProperties": {}
        },
        "QuoteType": {
            "type": "object",
            "properties": {
                "exchange": {
                    "type": "string"
                },
                "quoteType": {
                    "type": "string"
                },
                "symbol": {
                    "type": "string"
                },
                "underlyingSymbol": {
                    "type": "string"
                },
                "shortName": {
                    "type": [
                        "null",
                        "string"
                    ]
                },
                "longName": {
                    "type": [
                        "null",
                        "string"
                    ]
                },
                "firstTradeDateEpochUtc": {
                    "anyOf": [
                        {
                            "type": "null"
                        },
                        {
                            "type": "string",
                            "format": "date-time"
                        }
                    ]
                },
                "timeZoneFullName": {
                    "type": "string"
                },
                "timeZoneShortName": {
                    "type": "string"
                },
                "uuid": {
                    "type": "string"
                },
                "messageBoardId": {
                    "type": [
                        "null",
                        "string"
                    ]
                },
                "gmtOffSetMilliseconds": {
                    "type": "number"
                },
                "maxAge": {
                    "type": "number"
                }
            },
            "required": [
                "exchange",
                "quoteType",
                "symbol",
                "underlyingSymbol",
                "shortName",
                "timeZoneFullName",
                "timeZoneShortName",
                "uuid",
                "gmtOffSetMilliseconds",
                "maxAge"
            ],
            "additionalProperties": {}
        },
        "RecommendationTrend": {
            "type": "object",
            "properties": {
                "trend": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/RecommendationTrendTrend"
                    }
                },
                "maxAge": {
                    "type": "number"
                }
            },
            "required": [
                "trend",
                "maxAge"
            ],
            "additionalProperties": {}
        },
        "RecommendationTrendTrend": {
            "type": "object",
            "properties": {
                "period": {
                    "type": "string"
                },
                "strongBuy": {
                    "type": "number"
                },
                "buy": {
                    "type": "number"
                },
                "hold": {
                    "type": "number"
                },
                "sell": {
                    "type": "number"
                },
                "strongSell": {
                    "type": "number"
                }
            },
            "required": [
                "period",
                "strongBuy",
                "buy",
                "hold",
                "sell",
                "strongSell"
            ],
            "additionalProperties": {}
        },
        "SECFilings": {
            "type": "object",
            "properties": {
                "filings": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/Filing"
                    }
                },
                "maxAge": {
                    "type": "number"
                }
            },
            "required": [
                "filings",
                "maxAge"
            ],
            "additionalProperties": {}
        },
        "Filing": {
            "type": "object",
            "properties": {
                "date": {
                    "type": "string"
                },
                "epochDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "type": {
                    "type": "string",
                    "enum": [
                        "10-K",
                        "10-Q",
                        "8-K",
                        "8-K/A",
                        "10-K/A",
                        "10-Q/A",
                        "SD",
                        "PX14A6G",
                        "SC 13G/A",
                        "DEFA14A",
                        "25-NSE",
                        "S-8 POS",
                        "6-K",
                        "F-3ASR",
                        "SC 13D/A",
                        "20-F",
                        "425",
                        "SC14D9C",
                        "SC 13G",
                        "S-8",
                        "DEF 14A",
                        "F-10",
                        "S-3ASR",
                        "CORRESP",
                        "PX14A6N",
                        "N-PX",
                        "ARS",
                        "PRE 14A",
                        "F-6EF",
                        "S-3/A",
                        "S-3",
                        "POS AM",
                        "IRANNOTICE",
                        "20-F/A",
                        "11-K",
                        "DEFR14A",
                        "S4",
                        "RW",
                        "S-4/A",
                        "S-4",
                        "S-4MEF",
                        "PRER14A",
                        "8-A12B",
                        "D",
                        "SC 13D"
                    ]
                },
                "title": {
                    "type": "string"
                },
                "edgarUrl": {
                    "type": "string"
                },
                "maxAge": {
                    "type": "number"
                },
                "url": {
                    "type": "string"
                },
                "exhibits": {
                    "type": "array",
                    "items": {
                        "type": "object",
                        "properties": {
                            "type": {
                                "type": "string"
                            },
                            "url": {
                                "type": "string"
                            },
                            "downloadUrl": {
                                "type": "string"
                            }
                        },
                        "required": [
                            "type",
                            "url"
                        ],
                        "additionalProperties": false
                    }
                }
            },
            "required": [
                "date",
                "epochDate",
                "type",
                "title",
                "edgarUrl",
                "maxAge"
            ],
            "additionalProperties": {}
        },
        "SummaryDetail": {
            "type": "object",
            "properties": {
                "maxAge": {
                    "type": "number"
                },
                "priceHint": {
                    "type": "number"
                },
                "previousClose": {
                    "type": "number"
                },
                "open": {
                    "type": "number"
                },
                "dayLow": {
                    "type": "number"
                },
                "dayHigh": {
                    "type": "number"
                },
                "regularMarketPreviousClose": {
                    "type": "number"
                },
                "regularMarketOpen": {
                    "type": "number"
                },
                "regularMarketDayLow": {
                    "type": "number"
                },
                "regularMarketDayHigh": {
                    "type": "number"
                },
                "regularMarketVolume": {
                    "type": "number"
                },
                "dividendRate": {
                    "type": "number"
                },
                "dividendYield": {
                    "type": "number"
                },
                "exDividendDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "payoutRatio": {
                    "type": "number"
                },
                "fiveYearAvgDividendYield": {
                    "type": "number"
                },
                "beta": {
                    "type": "number"
                },
                "trailingPE": {
                    "type": "number"
                },
                "forwardPE": {
                    "type": "number"
                },
                "volume": {
                    "type": "number"
                },
                "averageVolume": {
                    "type": "number"
                },
                "averageVolume10days": {
                    "type": "number"
                },
                "averageDailyVolume10Day": {
                    "type": "number"
                },
                "bid": {
                    "type": "number"
                },
                "ask": {
                    "type": "number"
                },
                "bidSize": {
                    "type": "number"
                },
                "askSize": {
                    "type": "number"
                },
                "marketCap": {
                    "type": "number"
                },
                "fiftyDayAverage": {
                    "type": "number"
                },
                "fiftyTwoWeekLow": {
                    "type": "number"
                },
                "fiftyTwoWeekHigh": {
                    "type": "number"
                },
                "twoHundredDayAverage": {
                    "type": "number"
                },
                "priceToSalesTrailing12Months": {
                    "type": "number"
                },
                "trailingAnnualDividendRate": {
                    "type": "number"
                },
                "trailingAnnualDividendYield": {
                    "type": "number"
                },
                "currency": {
                    "type": "string"
                },
                "algorithm": {
                    "type": "null"
                },
                "tradeable": {
                    "type": "boolean"
                },
                "yield": {
                    "type": "number"
                },
                "totalAssets": {
                    "type": "number"
                },
                "navPrice": {
                    "type": "number"
                },
                "ytdReturn": {
                    "type": "number"
                },
                "fromCurrency": {
                    "type": [
                        "string",
                        "null"
                    ]
                },
                "toCurrency": {
                    "type": [
                        "string",
                        "null"
                    ]
                },
                "lastMarket": {
                    "type": [
                        "string",
                        "null"
                    ]
                },
                "volume24Hr": {
                    "type": "number"
                },
                "volumeAllCurrencies": {
                    "type": "number"
                },
                "circulatingSupply": {
                    "type": "number"
                },
                "startDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "coinMarketCapLink": {
                    "type": [
                        "string",
                        "null"
                    ]
                },
                "expireDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "openInterest": {
                    "type": "number"
                },
                "averageMaturity": {
                    "type": "number"
                }
            },
            "required": [
                "maxAge",
                "priceHint",
                "currency",
                "algorithm",
                "tradeable",
                "fromCurrency",
                "lastMarket"
            ],
            "additionalProperties": {}
        },
        "SummaryProfile": {
            "type": "object",
            "properties": {
                "address1": {
                    "type": "string"
                },
                "address2": {
                    "type": "string"
                },
                "address3": {
                    "type": "string"
                },
                "city": {
                    "type": "string"
                },
                "state": {
                    "type": "string"
                },
                "zip": {
                    "type": "string"
                },
                "country": {
                    "type": "string"
                },
                "phone": {
                    "type": "string"
                },
                "fax": {
                    "type": "string"
                },
                "website": {
                    "type": "string"
                },
                "industry": {
                    "type": "string"
                },
                "industryDisp": {
                    "type": "string"
                },
                "sector": {
                    "type": "string"
                },
                "sectorDisp": {
                    "type": "string"
                },
                "longBusinessSummary": {
                    "type": "string"
                },
                "fullTimeEmployees": {
                    "type": "number"
                },
                "companyOfficers": {
                    "type": "array",
                    "items": {}
                },
                "maxAge": {
                    "type": "number"
                },
                "twitter": {
                    "type": "string"
                },
                "industryKey": {
                    "type": "string"
                },
                "sectorKey": {
                    "type": "string"
                },
                "irWebsite": {
                    "type": "string"
                },
                "executiveTeam": {
                    "type": "array",
                    "items": {}
                },
                "name": {
                    "type": "string"
                },
                "startDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "description": {
                    "type": "string"
                }
            },
            "required": [
                "companyOfficers",
                "maxAge"
            ],
            "additionalProperties": {}
        },
        "TopHoldings": {
            "type": "object",
            "properties": {
                "maxAge": {
                    "type": "number"
                },
                "stockPosition": {
                    "type": "number"
                },
                "bondPosition": {
                    "type": "number"
                },
                "holdings": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/TopHoldingsHolding"
                    }
                },
                "equityHoldings": {
                    "$ref": "#/definitions/TopHoldingsEquityHoldings"
                },
                "bondHoldings": {
                    "type": "object"
                },
                "bondRatings": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/TopHoldingsBondRating"
                    }
                },
                "sectorWeightings": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/TopHoldingsSectorWeighting"
                    }
                },
                "cashPosition": {
                    "type": "number"
                },
                "otherPosition": {
                    "type": "number"
                },
                "preferredPosition": {
                    "type": "number"
                },
                "convertiblePosition": {
                    "type": "number"
                }
            },
            "required": [
                "maxAge",
                "holdings",
                "equityHoldings",
                "bondHoldings",
                "bondRatings",
                "sectorWeightings"
            ],
            "additionalProperties": {}
        },
        "TopHoldingsHolding": {
            "type": "object",
            "properties": {
                "symbol": {
                    "type": "string"
                },
                "holdingName": {
                    "type": "string"
                },
                "holdingPercent": {
                    "type": "number"
                }
            },
            "required": [
                "symbol",
                "holdingName",
                "holdingPercent"
            ],
            "additionalProperties": {}
        },
        "TopHoldingsEquityHoldings": {
            "type": "object",
            "properties": {
                "medianMarketCap": {
                    "type": "number"
                },
                "medianMarketCapCat": {
                    "type": "number"
                },
                "priceToBook": {
                    "type": "number"
                },
                "priceToBookCat": {
                    "type": "number"
                },
                "priceToCashflow": {
                    "type": "number"
                },
                "priceToCashflowCat": {
                    "type": "number"
                },
                "priceToEarnings": {
                    "type": "number"
                },
                "priceToEarningsCat": {
                    "type": "number"
                },
                "priceToSales": {
                    "type": "number"
                },
                "priceToSalesCat": {
                    "type": "number"
                },
                "threeYearEarningsGrowth": {
                    "type": "number"
                },
                "threeYearEarningsGrowthCat": {
                    "type": "number"
                }
            },
            "required": [
                "priceToBook",
                "priceToCashflow",
                "priceToEarnings",
                "priceToSales"
            ],
            "additionalProperties": {}
        },
        "TopHoldingsBondRating": {
            "type": "object",
            "properties": {
                "a": {
                    "type": "number"
                },
                "aa": {
                    "type": "number"
                },
                "aaa": {
                    "type": "number"
                },
                "other": {
                    "type": "number"
                },
                "b": {
                    "type": "number"
                },
                "bb": {
                    "type": "number"
                },
                "bbb": {
                    "type": "number"
                },
                "below_b": {
                    "type": "number"
                },
                "us_government": {
                    "type": "number"
                }
            },
            "additionalProperties": {}
        },
        "TopHoldingsSectorWeighting": {
            "type": "object",
            "properties": {
                "realestate": {
                    "type": "number"
                },
                "consumer_cyclical": {
                    "type": "number"
                },
                "basic_materials": {
                    "type": "number"
                },
                "consumer_defensive": {
                    "type": "number"
                },
                "technology": {
                    "type": "number"
                },
                "communication_services": {
                    "type": "number"
                },
                "financial_services": {
                    "type": "number"
                },
                "utilities": {
                    "type": "number"
                },
                "industrials": {
                    "type": "number"
                },
                "energy": {
                    "type": "number"
                },
                "healthcare": {
                    "type": "number"
                }
            },
            "additionalProperties": {}
        },
        "UpgradeDowngradeHistory": {
            "type": "object",
            "properties": {
                "history": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/UpgradeDowngradeHistoryHistory"
                    }
                },
                "maxAge": {
                    "type": "number"
                }
            },
            "required": [
                "history",
                "maxAge"
            ],
            "additionalProperties": {}
        },
        "UpgradeDowngradeHistoryHistory": {
            "type": "object",
            "properties": {
                "epochGradeDate": {
                    "type": "string",
                    "format": "date-time"
                },
                "firm": {
                    "type": "string"
                },
                "toGrade": {
                    "$ref": "#/definitions/Grade"
                },
                "fromGrade": {
                    "$ref": "#/definitions/Grade"
                },
                "action": {
                    "$ref": "#/definitions/Action"
                }
            },
            "required": [
                "epochGradeDate",
                "firm",
                "toGrade",
                "action"
            ],
            "additionalProperties": {}
        },
        "Grade": {
            "type": "string",
            "enum": [
                "Accumulate",
                "Add",
                "Average",
                "Below Average",
                "Buy",
                "Conviction Buy",
                "",
                "Equal-Weight",
                "Fair Value",
                "Equal-weight",
                "Long-term Buy",
                "Hold",
                "Long-Term Buy",
                "Market Outperform",
                "Market Perform",
                "Mixed",
                "Negative",
                "Neutral",
                "In-Line",
                "Outperform",
                "Overweight",
                "Peer Perform",
                "Perform",
                "Positive",
                "Reduce",
                "Sector Outperform",
                "Sector Perform",
                "Sector Weight",
                "Sell",
                "Strong Buy",
                "Top Pick",
                "Underperform",
                "Underperformer",
                "Underweight",
                "Trim",
                "Above Average",
                "In-line",
                "Outperformer",
                "OVerweight",
                "Cautious",
                "Market Weight",
                "Sector Underperform",
                "Market Underperform",
                "Peer perform",
                "Gradually Accumulate",
                "Action List Buy",
                "Performer",
                "Sector Performer",
                "Speculative Buy",
                "Strong Sell",
                "Speculative Hold",
                "Not Rated",
                "Hold Neutral",
                "Developing",
                "buy",
                "HOld",
                "Trading Sell",
                "Tender",
                "market perform",
                "BUy"
            ]
        },
        "Action": {
            "type": "string",
            "enum": [
                "down",
                "init",
                "main",
                "reit",
                "up"
            ]
        }
    }
};
