export default {
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$comment": "DO NOT EDIT THIS FILE.  It is generated automatically from typescript interfaces in the project.  To update, run `deno task schema` (with optional `--watch`).  In VSCode, this is run automatically for you on folder open.",
    "definitions": {
        "HistoricalHistoryResult": {
            "type": "array",
            "items": {
                "$ref": "#/definitions/HistoricalRowHistory"
            }
        },
        "HistoricalRowHistory": {
            "type": "object",
            "properties": {
                "date": {
                    "type": "string",
                    "format": "date-time"
                },
                "open": {
                    "type": "number"
                },
                "high": {
                    "type": "number"
                },
                "low": {
                    "type": "number"
                },
                "close": {
                    "type": "number"
                },
                "adjClose": {
                    "type": "number"
                },
                "volume": {
                    "type": "number"
                }
            },
            "required": [
                "date",
                "open",
                "high",
                "low",
                "close",
                "volume"
            ],
            "additionalProperties": {}
        },
        "HistoricalDividendsResult": {
            "type": "array",
            "items": {
                "$ref": "#/definitions/HistoricalRowDividend"
            }
        },
        "HistoricalRowDividend": {
            "type": "object",
            "properties": {
                "date": {
                    "type": "string",
                    "format": "date-time"
                },
                "dividends": {
                    "type": "number"
                }
            },
            "required": [
                "date",
                "dividends"
            ],
            "additionalProperties": false
        },
        "HistoricalStockSplitsResult": {
            "type": "array",
            "items": {
                "$ref": "#/definitions/HistoricalRowStockSplit"
            }
        },
        "HistoricalRowStockSplit": {
            "type": "object",
            "properties": {
                "date": {
                    "type": "string",
                    "format": "date-time"
                },
                "stockSplits": {
                    "type": "string"
                }
            },
            "required": [
                "date",
                "stockSplits"
            ],
            "additionalProperties": false
        },
        "HistoricalResult": {
            "anyOf": [
                {
                    "$ref": "#/definitions/HistoricalHistoryResult"
                },
                {
                    "$ref": "#/definitions/HistoricalDividendsResult"
                },
                {
                    "$ref": "#/definitions/HistoricalStockSplitsResult"
                }
            ]
        },
        "HistoricalOptions": {
            "type": "object",
            "properties": {
                "period1": {
                    "anyOf": [
                        {
                            "type": "string",
                            "format": "date-time"
                        },
                        {
                            "type": "string"
                        },
                        {
                            "type": "number"
                        }
                    ]
                },
                "period2": {
                    "anyOf": [
                        {
                            "type": "string",
                            "format": "date-time"
                        },
                        {
                            "type": "string"
                        },
                        {
                            "type": "number"
                        }
                    ]
                },
                "interval": {
                    "type": "string",
                    "enum": [
                        "1d",
                        "1wk",
                        "1mo"
                    ]
                },
                "events": {
                    "type": "string",
                    "enum": [
                        "history",
                        "dividends",
                        "split"
                    ]
                },
                "includeAdjustedClose": {
                    "type": "boolean"
                }
            },
            "required": [
                "period1"
            ],
            "additionalProperties": false
        },
        "HistoricalOptionsEventsHistory": {
            "type": "object",
            "properties": {
                "period1": {
                    "anyOf": [
                        {
                            "type": "string",
                            "format": "date-time"
                        },
                        {
                            "type": "string"
                        },
                        {
                            "type": "number"
                        }
                    ]
                },
                "period2": {
                    "anyOf": [
                        {
                            "type": "string",
                            "format": "date-time"
                        },
                        {
                            "type": "string"
                        },
                        {
                            "type": "number"
                        }
                    ]
                },
                "interval": {
                    "type": "string",
                    "enum": [
                        "1d",
                        "1wk",
                        "1mo"
                    ]
                },
                "events": {
                    "type": "string",
                    "const": "history"
                },
                "includeAdjustedClose": {
                    "type": "boolean"
                }
            },
            "additionalProperties": false,
            "required": [
                "period1"
            ]
        },
        "HistoricalOptionsEventsDividends": {
            "type": "object",
            "properties": {
                "period1": {
                    "anyOf": [
                        {
                            "type": "string",
                            "format": "date-time"
                        },
                        {
                            "type": "string"
                        },
                        {
                            "type": "number"
                        }
                    ]
                },
                "period2": {
                    "anyOf": [
                        {
                            "type": "string",
                            "format": "date-time"
                        },
                        {
                            "type": "string"
                        },
                        {
                            "type": "number"
                        }
                    ]
                },
                "interval": {
                    "type": "string",
                    "enum": [
                        "1d",
                        "1wk",
                        "1mo"
                    ]
                },
                "events": {
                    "type": "string",
                    "const": "dividends"
                },
                "includeAdjustedClose": {
                    "type": "boolean"
                }
            },
            "required": [
                "events",
                "period1"
            ],
            "additionalProperties": false
        },
        "HistoricalOptionsEventsSplit": {
            "type": "object",
            "properties": {
                "period1": {
                    "anyOf": [
                        {
                            "type": "string",
                            "format": "date-time"
                        },
                        {
                            "type": "string"
                        },
                        {
                            "type": "number"
                        }
                    ]
                },
                "period2": {
                    "anyOf": [
                        {
                            "type": "string",
                            "format": "date-time"
                        },
                        {
                            "type": "string"
                        },
                        {
                            "type": "number"
                        }
                    ]
                },
                "interval": {
                    "type": "string",
                    "enum": [
                        "1d",
                        "1wk",
                        "1mo"
                    ]
                },
                "events": {
                    "type": "string",
                    "const": "split"
                },
                "includeAdjustedClose": {
                    "type": "boolean"
                }
            },
            "required": [
                "events",
                "period1"
            ],
            "additionalProperties": false
        },
        "nullFieldCount": {},
        "historical": {}
    }
};
