import { ExtendedCookieJar } from "../cookieJar.js";
import { defaultOptions as defaultLoggerOptions } from "./logger.js";
import { defaultOptions as defaultQuoteCombineOptions } from "../../other/quoteCombine.js";
import pkg from "../../../deno.js";
// import { repository } from "../consts.ts";
// Big thanks to @nocodehummel who figured out a User-Agent that both
// works but still allows us to identify ourselves honestly.
const userAgent = `Mozilla/5.0 (compatible; yahoo-finance2/${pkg.version})`;
// const userAgent = `${pkg.name}/${pkg.version} (+${repository})`;
const options = {
    YF_QUERY_HOST: "query2.finance.yahoo.com",
    cookieJar: new ExtendedCookieJar(),
    queue: {
        concurrency: 4, // Min: 1, Max: Infinity
        // timeout: 60,
    },
    validation: {
        logErrors: true,
        logOptionsErrors: true,
        allowAdditionalProps: true,
    },
    logger: defaultLoggerOptions,
    quoteCombine: defaultQuoteCombineOptions,
    versionCheck: true,
    fetchOptions: {
        headers: {
            "User-Agent": userAgent,
        },
    },
};
export default options;
