import type { YahooFinanceFetchModuleOptions } from "./yahooFinanceFetch.js";
export type { YahooFinanceFetchModuleOptions };
/**
 * Common options for all "modules" ({@linkcode [modules/quote] quote()}, etc).
 * Usually the 3rd parameter in most option calls, i.e.
 *
 * @example
 * ```ts
 * const moduleOptions = { validateResults: false };
 * await yf.quote("AAPL", quoteOptions, moduleOptions);
 * ```
 *
 * @see {@linkcode YahooFinanceFetchModuleOptions} for options related to HTTP requests (e.g. custom fetch or fetch options like headers, etc).
 */
export interface ModuleOptions extends YahooFinanceFetchModuleOptions {
    /** If false, lib won't validate and will leave that to Yahoo */
    validateOptions?: boolean;
    /** If false, will pass back unvalidated / untyped result from Yahoo  */
    validateResult?: boolean;
}
export interface ModuleOptionsWithValidateFalse extends ModuleOptions {
    validateResult: false;
}
export interface ModuleOptionsWithValidateTrue extends ModuleOptions {
    validateResult?: true;
}
export interface ModuleThis {
    [key: string]: any;
    _moduleExec: any;
}
/**
 * test
 */
export type ModuleError = Error;
//# sourceMappingURL=moduleCommon.d.ts.map