/**
 * @module YahooFinance
 */
import { type YahooFinanceWithModules } from "./createYahooFinance.js";
import * as modules from "./modules/index.js";
import * as other from "./other/index.js";
declare const createOpts: {
    readonly modules: {
        readonly quoteCombine: typeof other.quoteCombine;
        readonly autoc: typeof modules.autoc;
        readonly chart: typeof modules.chart;
        readonly dailyGainers: typeof modules.dailyGainers;
        readonly dailyLosers: typeof modules.dailyLosers;
        readonly fundamentalsTimeSeries: typeof modules.fundamentalsTimeSeries;
        readonly historical: typeof modules.historical;
        readonly insights: typeof modules.insights;
        readonly options: typeof modules.options;
        readonly quote: typeof modules.quote;
        readonly quoteSummary: typeof modules.quoteSummary;
        readonly recommendationsBySymbol: typeof modules.recommendationsBySymbol;
        readonly screener: typeof modules.screener;
        readonly search: typeof modules.search;
        readonly trendingSymbols: typeof modules.trendingSymbols;
    };
};
/**
 * The full Yahoo Finance API client with all modules: `quote()`, `search()`, etc.
 *
 * @example
 * ```ts
 * import YahooFinance from "yahoo-finance2";
 *
 * const yahooFinance = new YahooFinance();
 * console.log(await yahooFinance.quote("AAPL"));
 * ```
 *
 * @see {@linkcode [createYahooFinance].YahooFinance YahooFinance} for instantiation options.
 * @see The full list of {@link [modules] main modules} and {@link [other] other modules}.
 * @see {@linkcode [createYahooFinance].createYahooFinance createYahooFinance} for creating an API client with custom modules (advanced use-cases only).
 */
declare const YahooFinance: YahooFinanceWithModules<typeof createOpts>;
export default YahooFinance;
//# sourceMappingURL=index.d.ts.map