import { type YahooFinanceOptions } from "./lib/options/options.js";
import yahooFinanceFetch from "./lib/yahooFinanceFetch.js";
import moduleExec from "./lib/moduleExec.js";
import Notices from "./lib/notices.js";
/**
 * Instantiate a new YahooFinance client.
 *
 * See {@linkcode YahooFinanceOptions} for available options.
 *
 * @example
 * ```ts
 * const yahooFinance = new YahooFinance(); // or YahooFinance({ ...options });
 * console.log(await yahooFinance.quote("AAPL"));
 * ```
 *
 * Internal / private properties (prefixed `_`) and shown below are not part of the public API and should not be depended on.
 * You're welcome to inspect or make use of them but they might change or disappear without notice.
 *
 * @see The full list of {@link [modules] main modules} and {@link [other] other modules}.
 * @see {@linkcode [createYahooFinance].createYahooFinance createYahooFinance} for creating an API client with custom modules (advanced use-cases only).
 * @see The {@link ../../~/default.html | default} entry point that includes all modules.
 */
export declare class YahooFinance {
    _opts: YahooFinanceOptions;
    _fetch: typeof yahooFinanceFetch;
    _moduleExec: typeof moduleExec;
    _notices: Notices;
    _env: {
        fetch: typeof fetch | null;
        fetchDevel?: () => typeof fetch;
    };
    _logObj: (obj: unknown, opts?: {
        depth?: number;
    }) => void;
    _setOpts(options: YahooFinanceOptions): void;
    constructor(options?: YahooFinanceOptions);
}
type ModuleMethod = (...args: any[]) => any;
interface CreateYahooFinanceOptions {
    /** The modules (`quote`, `search`, etc) to include in this YahooFinance class */
    modules: Record<string, ModuleMethod>;
    /** The default options to use for new instances */
    _opts?: YahooFinanceOptions;
}
export type YahooFinanceWithModules<T extends CreateYahooFinanceOptions> = {
    new (options?: YahooFinanceOptions): YahooFinance & {
        [K in keyof T["modules"]]: T["modules"][K];
    };
} & {
    /** @deprecated Use `const yf = new YahooFinance(); yf.chart(...)` instead. */
    chart(..._args: unknown[]): never;
    /** @deprecated Use `const yf = new YahooFinance(); yf.dailyGainers(...)` instead. */
    dailyGainers(..._args: unknown[]): never;
    /** @deprecated Use `const yf = new YahooFinance(); yf.dailyLosers(...)` instead. */
    dailyLosers(..._args: unknown[]): never;
    /** @deprecated Use `const yf = new YahooFinance(); yf.fundamentalsTimeSeries(...)` instead. */
    fundamentalsTimeSeries(..._args: unknown[]): never;
    /** @deprecated Use `const yf = new YahooFinance(); yf.historical(...)` instead. */
    historical(..._args: unknown[]): never;
    /** @deprecated Use `const yf = new YahooFinance(); yf.insights(...)` instead. */
    insights(..._args: unknown[]): never;
    /** @deprecated Use `const yf = new YahooFinance(); yf.options(...)` instead. */
    options(..._args: unknown[]): never;
    /** @deprecated Use `const yf = new YahooFinance(); yf.quote(...)` instead. */
    quote(..._args: unknown[]): never;
    /** @deprecated Use `const yf = new YahooFinance(); yf.quoteSummary(...)` instead. */
    quoteSummary(..._args: unknown[]): never;
    /** @deprecated Use `const yf = new YahooFinance(); yf.recommendationsBySymbol(...)` instead. */
    recommendationsBySymbol(..._args: unknown[]): never;
    /** @deprecated Use `const yf = new YahooFinance(); yf.screener(...)` instead. */
    screener(..._args: unknown[]): never;
    /** @deprecated Use `const yf = new YahooFinance(); yf.search(...)` instead. */
    search(..._args: unknown[]): never;
    /** @deprecated Use `const yf = new YahooFinance(); yf.trendingSymbols(...)` instead. */
    trendingSymbols(..._args: unknown[]): never;
};
/**
 * Create a new YahooFinance **class** with the given options (usually a list of modules,
 * or special options useful for testing).
 *
 * @example Basic Example
 * ```ts
 * import quote from "yahoo-finance2/modules/quote.ts";
 * import search from "yahoo-finance2/modules/search.ts";
 *
 * // Create a YahooFinance instance with the quote and search modules only.
 * const yahooFinance = createYahooFinance({
 *   modules: { quote, search }
 * });
 * ```
 *
 * By using only the modules you need, you'll have a small bundle size.  But remember,
 * `yahoo-finance2` is never bundled to the client (browser), so your savings will be
 * will be marginal (e.g. a marginally faster serverless cold start time).
 *
 * @param createOpts The {@link CreateYahooFinanceOptions} that influence the class creation.
 * @returns A {@link YahooFinance} class that you can call with `new YahooFinance()`.
 */
export default function createYahooFinance<T extends CreateYahooFinanceOptions>(createOpts: T): YahooFinanceWithModules<T>;
export {};
//# sourceMappingURL=createYahooFinance.d.ts.map